<?php

require __DIR__.'/vendor/autoload.php';

$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

use Spatie\Permission\Models\Role;

// Verificar roles existentes
echo "Roles existentes:" . PHP_EOL;
$roles = Role::all();
foreach ($roles as $role) {
    echo "- " . $role->name . PHP_EOL;
}

// Obtener primer usuario y asignarle rol de admin
$user = \App\Models\User::find(2);
echo PHP_EOL . "Usuario: " . $user->name . PHP_EOL;

if ($roles->count() > 0) {
    $adminRole = Role::where('name', 'Administrador')->first();
    if ($adminRole) {
        $user->assignRole($adminRole);
        echo "Rol 'de Administrador' asignado exitosamente!" . PHP_EOL;
    } else {
        echo "Rol 'Administrador' no encontrado" . PHP_EOL;
    }
} else {
    echo "No hay roles en el sistema" . PHP_EOL;
}

echo "Roles del usuario: " . implode(', ', $user->getRoleNames()->toArray()) . PHP_EOL;
