<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🧪 PRUEBA DE NOTIFICACIÓN DE PEDIDO WHATSAPP\n";
echo "=============================================\n\n";

try {
    // Buscar el último pedido
    $pedido = \App\Models\Pedido::with(['user', 'detalles.producto'])->latest()->first();
    
    if (!$pedido) {
        echo "❌ No se encontraron pedidos en la base de datos\n";
        exit;
    }
    
    echo "📋 Pedido encontrado:\n";
    echo "• ID: {$pedido->id}\n";
    echo "• Código: {$pedido->codigo}\n";
    echo "• Usuario: {$pedido->user->name}\n";
    echo "• Teléfono: {$pedido->user->telefono}\n";
    echo "• Total: $" . number_format($pedido->total_usd, 2) . "\n\n";
    
    // Probar el servicio de WhatsApp
    echo "🔄 Probando conexión con WhatsApp API...\n";
    $whatsappService = new \App\Services\WhatsAppService();
    
    $connectionTest = $whatsappService->testConnection();
    echo "• Conexión: " . ($connectionTest['success'] ? '✅ OK' : '❌ FALLO') . "\n";
    if (!$connectionTest['success']) {
        echo "• Error: " . $connectionTest['error'] . "\n";
    }
    
    $status = $whatsappService->getStatus();
    echo "• Estado: " . ($status['success'] ? '✅ OK' : '❌ FALLO') . "\n";
    if ($status['success']) {
        echo "• WhatsApp Ready: " . ($status['isReady'] ?? false ? '✅ SÍ' : '❌ NO') . "\n";
    }
    
    echo "\n🚀 Enviando notificación de pedido...\n";
    
    $result = $whatsappService->sendOrderNotification($pedido);
    
    echo "📤 Resultado del envío:\n";
    echo "• Éxito: " . ($result['success'] ? '✅ SÍ' : '❌ NO') . "\n";
    
    if ($result['success']) {
        echo "• Message ID: " . ($result['message_id'] ?? 'N/A') . "\n";
        if (isset($result['simulated']) && $result['simulated']) {
            echo "• ⚠️  MODO SIMULADO: " . ($result['note'] ?? '') . "\n";
        }
    } else {
        echo "• Error: " . ($result['error'] ?? 'Error desconocido') . "\n";
    }
    
    echo "\n📊 Información adicional:\n";
    echo "• Teléfono limpio: " . $whatsappService->cleanPhoneNumber($pedido->user->telefono) . "\n";
    
    // Probar el Job también
    echo "\n🔄 Probando Job de WhatsApp...\n";
    try {
        \App\Jobs\SendOrderWhatsAppNotification::dispatch($pedido);
        echo "• Job despachado: ✅ OK\n";
        
        // Intentar procesar inmediatamente
        \Artisan::call('queue:work', ['--once' => true, '--quiet' => true]);
        echo "• Job procesado: ✅ OK\n";
    } catch (\Exception $e) {
        echo "• Error en Job: ❌ " . $e->getMessage() . "\n";
    }
    
} catch (\Exception $e) {
    echo "💥 Error general: " . $e->getMessage() . "\n";
    echo "• Archivo: " . $e->getFile() . "\n";
    echo "• Línea: " . $e->getLine() . "\n";
}

echo "\n=============================================\n";