<?php

// Script simple para verificar el funcionamiento del dashboard de WhatsApp

echo "🔍 Verificando el dashboard de WhatsApp...\n\n";

// Verificar archivos necesarios
$filesToCheck = [
    'app/Livewire/Admin/WhatsApp/Dashboard.php',
    'app/Services/WhatsAppService.php',
    'resources/views/livewire/admin/whatsapp/dashboard.blade.php',
    'routes/admin.php'
];

$allFilesExist = true;
foreach ($filesToCheck as $file) {
    if (file_exists($file)) {
        echo "✅ $file - EXISTE\n";
    } else {
        echo "❌ $file - NO EXISTE\n";
        $allFilesExist = false;
    }
}

echo "\n";

if ($allFilesExist) {
    echo "✅ Todos los archivos necesarios están presentes\n\n";
    
    // Verificar que la ruta esté definida
    $routesContent = file_get_contents('routes/admin.php');
    if (strpos($routesContent, 'whatsapp/dashboard') !== false) {
        echo "✅ La ruta /whatsapp/dashboard está definida en routes/admin.php\n";
    } else {
        echo "❌ La ruta /whatsapp/dashboard NO está definida\n";
    }
    
    echo "\n";
    
    // Verificar métodos en el servicio
    $serviceContent = file_get_contents('app/Services/WhatsAppService.php');
    $methods = ['getStatus', 'sendMessage', 'testConnection', 'getQueueStats', 'getDailyStats', 'getDetailedStatus'];
    
    echo "Verificando métodos en WhatsAppService:\n";
    foreach ($methods as $method) {
        if (strpos($serviceContent, "public function $method(") !== false) {
            echo "✅ Método $method() - EXISTE\n";
        } else {
            echo "❌ Método $method() - NO EXISTE\n";
        }
    }
    
    echo "\n";
    
    // Verificar componente Livewire
    $componentContent = file_get_contents('app/Livewire/Admin/WhatsApp/Dashboard.php');
    $componentMethods = ['checkStatus', 'sendTestMessage', 'loadQueueStats', 'loadDailyStats'];
    
    echo "Verificando métodos en Dashboard Livewire:\n";
    foreach ($componentMethods as $method) {
        if (strpos($componentContent, "public function $method(") !== false) {
            echo "✅ Método $method() - EXISTE\n";
        } else {
            echo "❌ Método $method() - NO EXISTE\n";
        }
    }
    
    echo "\n";
    
    // Verificar secciones en la vista
    $viewContent = file_get_contents('resources/views/livewire/admin/whatsapp/dashboard.blade.php');
    $sections = ['Panel de Control WhatsApp', 'Estado', 'En Cola', 'Enviados', 'Conexión WhatsApp', 'Mensaje de Prueba', 'Estadísticas de Uso', 'Diagnóstico del Sistema'];
    
    echo "Verificando secciones en la vista:\n";
    foreach ($sections as $section) {
        if (strpos($viewContent, $section) !== false) {
            echo "✅ Sección '$section' - EXISTE\n";
        } else {
            echo "❌ Sección '$section' - NO EXISTE\n";
        }
    }
    
    echo "\n";
    echo "🎯 RESUMEN:\n";
    echo "   - Ruta del dashboard: http://localhost:8000/admin/whatsapp/dashboard\n";
    echo "   - Componente: App\\Livewire\\Admin\\WhatsApp\\Dashboard\n";
    echo "   - Servicio: App\\Services\\WhatsAppService\n";
    echo "   - Vista: resources/views/livewire/admin/whatsapp/dashboard.blade.php\n";
    echo "\n";
    echo "✅ El dashboard de WhatsApp está correctamente implementado y listo para usar!\n";
    echo "💡 El servicio funcionará en modo simulado si la API externa no está disponible.\n";
    
} else {
    echo "❌ Faltan archivos necesarios. Por favor verifica la implementación.\n";
}

echo "\n";