<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🔐 Probando mensaje de bienvenida con credenciales...\n\n";

try {
    // Simular un usuario recién registrado
    $testUser = new stdClass();
    $testUser->id = 999;
    $testUser->name = 'Juan Pérez';
    $testUser->username = 'juan.perez';
    $testUser->telefono = '584241234567';
    
    $originalPassword = 'MiPassword123';
    
    $whatsappService = new \App\Services\WhatsAppService();
    
    // Obtener nombre de la empresa
    $empresa = \App\Models\Empresa::find(1);
    $empresaNombre = $empresa ? $empresa->name : 'nuestra tienda';
    
    // Crear el mensaje de bienvenida con credenciales
    $message = "🎉 *¡Bienvenido a {$empresaNombre}!* 🎉\n\n";
    $message .= "*Hola {$testUser->name}!*\n\n";
    $message .= "Gracias por registrarte en nuestra plataforma. Ahora puedes:\n\n";
    $message .= "🛒 Realizar pedidos fácilmente\n";
    $message .= "📱 Recibir notificaciones de tus pedidos\n";
    $message .= "⭐ Guardar productos en favoritos\n";
    $message .= "🚚 Seguimiento de entregas\n\n";
    $message .= "🔑 *Datos de acceso:*\n";
    $message .= "Usuario: {$testUser->username}\n";
    $message .= "Contraseña: {$originalPassword}\n\n";
    $message .= "¡Esperamos que disfrutes de tu experiencia de compra!\n\n";
    $message .= "Si tienes alguna pregunta, no dudes en contactarnos.";
    
    echo "Mensaje a enviar:\n";
    echo "==================\n";
    echo $message . "\n";
    echo "==================\n\n";
    
    // Verificar estado de WhatsApp
    $status = $whatsappService->getStatus();
    if (!$status['success'] || !$status['isReady']) {
        echo "⚠️  WhatsApp no está listo. Estado: " . ($status['status'] ?? 'desconocido') . "\n";
        echo "Simulando envío...\n";
    } else {
        echo "📤 Enviando mensaje de bienvenida con credenciales...\n";
    }
    
    $result = $whatsappService->sendMessage($testUser->telefono, $message);
    
    if ($result['success']) {
        echo "✅ Mensaje de bienvenida con credenciales enviado exitosamente\n";
        if (isset($result['simulated']) && $result['simulated']) {
            echo "   (Modo simulado - API externa no disponible)\n";
        }
    } else {
        echo "❌ Error enviando mensaje: " . $result['error'] . "\n";
    }
    
    echo "\n📋 Información incluida en el mensaje:\n";
    echo "- Saludo personalizado\n";
    echo "- Funcionalidades disponibles\n";
    echo "- Usuario: {$testUser->username}\n";
    echo "- Contraseña: {$originalPassword}\n";
    echo "- Mensaje de bienvenida\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}