<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "✅ Probando registro final con procesamiento automático...\n\n";

try {
    // Simular datos de registro
    $userData = [
        'name' => 'Test Final User',
        'username' => 'testfinal' . time(),
        'telefono' => '+584242115948',
        'password' => 'TestFinal123'
    ];
    
    echo "📝 Datos de registro:\n";
    echo "   Nombre: {$userData['name']}\n";
    echo "   Usuario: {$userData['username']}\n";
    echo "   Teléfono: {$userData['telefono']}\n";
    echo "   Contraseña: {$userData['password']}\n\n";
    
    // Crear usuario temporal para simular el Job
    $tempUser = new stdClass();
    $tempUser->id = 999;
    $tempUser->name = $userData['name'];
    $tempUser->username = $userData['username'];
    $tempUser->telefono = '584242115948';
    
    echo "🚀 Ejecutando Job de mensaje de bienvenida...\n";
    
    // Crear y ejecutar el Job directamente
    $job = new \App\Jobs\SendWelcomeWhatsAppMessage($tempUser, $userData['password']);
    $job->handle();
    
    echo "✅ Job ejecutado exitosamente\n\n";
    
    echo "📱 El mensaje debería incluir:\n";
    echo "- Saludo personalizado: Hola {$userData['name']}!\n";
    echo "- Usuario: {$userData['username']}\n";
    echo "- Contraseña: {$userData['password']}\n";
    echo "- Enviado a: {$userData['telefono']}\n\n";
    
    echo "🔧 Para procesamiento automático de Jobs:\n";
    echo "1. Ejecutar: start-queue-worker.bat\n";
    echo "2. O manualmente: php artisan queue:work\n";
    echo "3. Los Jobs se procesarán automáticamente en background\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}