<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🚀 Probando flujo completo de registro con credenciales...\n\n";

try {
    // Simular datos de registro
    $userData = [
        'name' => 'María González Test',
        'username' => 'maria.test.' . time(),
        'telefono' => '0424-567-8901',
        'password' => 'TestPassword123'
    ];
    
    echo "1. Datos de registro:\n";
    echo "   Nombre: {$userData['name']}\n";
    echo "   Usuario: {$userData['username']}\n";
    echo "   Teléfono: {$userData['telefono']}\n";
    echo "   Contraseña: {$userData['password']}\n\n";
    
    // Formatear teléfono
    function formatPhoneNumber($phoneNumber) {
        $empresa = \App\Models\Empresa::where('status', 1)->first();
        if (!$empresa || !$empresa->pais) {
            return $phoneNumber;
        }

        $pais = $empresa->pais;
        $codigoPais = $pais->codigo_telefonico ?? '+58';
        $codigoLimpio = str_replace('+', '', $codigoPais);
        $cleanNumber = preg_replace('/[\s\-\(\)\+]/', '', $phoneNumber);
        
        if (substr($cleanNumber, 0, strlen($codigoLimpio)) === $codigoLimpio) {
            return $cleanNumber;
        }
        
        if (substr($cleanNumber, 0, 1) === '0') {
            $cleanNumber = substr($cleanNumber, 1);
        }
        
        return $codigoLimpio . $cleanNumber;
    }
    
    $formattedPhone = formatPhoneNumber($userData['telefono']);
    echo "2. Teléfono formateado: {$formattedPhone}\n\n";
    
    // Simular creación del Job
    echo "3. Creando Job de mensaje de bienvenida...\n";
    
    // Crear usuario temporal para simular el Job
    $tempUser = new stdClass();
    $tempUser->id = 999;
    $tempUser->name = $userData['name'];
    $tempUser->username = $userData['username'];
    $tempUser->telefono = $formattedPhone;
    
    // Simular ejecución del Job
    echo "4. Ejecutando Job en background...\n";
    
    $whatsappService = new \App\Services\WhatsAppService();
    $empresa = \App\Models\Empresa::find(1);
    $empresaNombre = $empresa ? $empresa->name : 'nuestra tienda';
    
    $message = "🎉 *¡Bienvenido a {$empresaNombre}!* 🎉\n\n";
    $message .= "*Hola {$tempUser->name}!*\n\n";
    $message .= "Gracias por registrarte en nuestra plataforma. Ahora puedes:\n\n";
    $message .= "🛒 Realizar pedidos fácilmente\n";
    $message .= "📱 Recibir notificaciones de tus pedidos\n";
    $message .= "⭐ Guardar productos en favoritos\n";
    $message .= "🚚 Seguimiento de entregas\n\n";
    $message .= "🔑 *Datos de acceso:*\n";
    $message .= "Usuario: {$tempUser->username}\n";
    $message .= "Contraseña: {$userData['password']}\n\n";
    $message .= "¡Esperamos que disfrutes de tu experiencia de compra!\n\n";
    $message .= "Si tienes alguna pregunta, no dudes en contactarnos.";
    
    $result = $whatsappService->sendMessage($tempUser->telefono, $message);
    
    if ($result['success']) {
        echo "✅ Mensaje enviado exitosamente\n";
        if (isset($result['simulated']) && $result['simulated']) {
            echo "   (Modo simulado)\n";
        }
    } else {
        echo "❌ Error: " . $result['error'] . "\n";
    }
    
    echo "\n📱 Mensaje enviado incluye:\n";
    echo "- Saludo personalizado con nombre\n";
    echo "- Lista de funcionalidades\n";
    echo "- Usuario: {$tempUser->username}\n";
    echo "- Contraseña: {$userData['password']}\n";
    echo "- Teléfono formateado: {$formattedPhone}\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}