<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;

class WhatsAppDashboardTest extends TestCase
{
    use RefreshDatabase, WithFaker;

    /**
     * Test that the WhatsApp dashboard is accessible for authenticated users.
     */
    public function test_whatsapp_dashboard_is_accessible()
    {
        // Create a user with admin role
        $user = User::factory()->create();
        $user->assignRole('Administrador');

        // Test dashboard access
        $response = $this->actingAs($user)->get('/admin/whatsapp/dashboard');
        
        $response->assertStatus(200);
        $response->assertSee('Panel de Control WhatsApp');
        $response->assertSee('Conexión WhatsApp');
        $response->assertSee('Mensaje de Prueba');
    }

    /**
     * Test that the dashboard shows correct status indicators.
     */
    public function test_dashboard_shows_status_indicators()
    {
        $user = User::factory()->create();
        $user->assignRole('Administrador');

        $response = $this->actingAs($user)->get('/admin/whatsapp/dashboard');
        
        // Check for status cards
        $response->assertSee('Estado');
        $response->assertSee('En Cola');
        $response->assertSee('Enviados');
        $response->assertSee('Última Hora');
        
        // Check for connection status section
        $response->assertSee('Conexión WhatsApp');
        
        // Check for test message section
        $response->assertSee('Mensaje de Prueba');
        
        // Check for statistics section
        $response->assertSee('Estadísticas de Uso');
        $response->assertSee('Mensajes Hoy');
        $response->assertSee('Entregados');
        $response->assertSee('Pendientes');
        $response->assertSee('Fallidos');
    }

    /**
     * Test that the dashboard includes diagnostic information.
     */
    public function test_dashboard_includes_diagnostics()
    {
        $user = User::factory()->create();
        $user->assignRole('Administrador');

        $response = $this->actingAs($user)->get('/admin/whatsapp/dashboard');
        
        // Check for diagnostics section
        $response->assertSee('Diagnóstico del Sistema');
        $response->assertSee('Estado Básico');
        $response->assertSee('Estado Detallado');
    }

    /**
     * Test that unauthenticated users are redirected.
     */
    public function test_unauthenticated_users_are_redirected()
    {
        $response = $this->get('/admin/whatsapp/dashboard');
        
        $response->assertRedirect('/login');
    }
}