<?php

namespace Tests\Feature;

use Tests\TestCase;

class WhatsAppDashboardSimpleTest extends TestCase
{
    /**
     * Test that the WhatsApp dashboard route exists.
     */
    public function test_whatsapp_dashboard_route_exists()
    {
        // Verificar que la ruta existe sin necesidad de autenticación
        $this->assertTrue(
            \Illuminate\Support\Facades\Route::has('admin.whatsapp.dashboard'),
            'La ruta admin.whatsapp.dashboard no está definida'
        );
    }

    /**
     * Test that the WhatsApp service class exists and has required methods.
     */
    public function test_whatsapp_service_has_required_methods()
    {
        $service = new \App\Services\WhatsAppService();
        
        // Verificar que los métodos existen
        $this->assertTrue(method_exists($service, 'getStatus'), 'El método getStatus no existe');
        $this->assertTrue(method_exists($service, 'sendMessage'), 'El método sendMessage no existe');
        $this->assertTrue(method_exists($service, 'testConnection'), 'El método testConnection no existe');
        $this->assertTrue(method_exists($service, 'getQueueStats'), 'El método getQueueStats no existe');
        $this->assertTrue(method_exists($service, 'getDailyStats'), 'El método getDailyStats no existe');
        $this->assertTrue(method_exists($service, 'getDetailedStatus'), 'El método getDetailedStatus no existe');
    }

    /**
     * Test that the Livewire component exists.
     */
    public function test_dashboard_livewire_component_exists()
    {
        $component = new \App\Livewire\Admin\WhatsApp\Dashboard();
        
        $this->assertInstanceOf(\Livewire\Component::class, $component);
        $this->assertTrue(method_exists($component, 'checkStatus'), 'El método checkStatus no existe');
        $this->assertTrue(method_exists($component, 'sendTestMessage'), 'El método sendTestMessage no existe');
        $this->assertTrue(method_exists($component, 'loadQueueStats'), 'El método loadQueueStats no existe');
        $this->assertTrue(method_exists($component, 'loadDailyStats'), 'El método loadDailyStats no existe');
    }

    /**
     * Test that the WhatsApp service can test connection.
     */
    public function test_whatsapp_service_can_test_connection()
    {
        $service = new \App\Services\WhatsAppService();
        
        // Test connection (should work in simulation mode)
        $result = $service->testConnection();
        
        $this->assertIsArray($result);
        $this->assertArrayHasKey('success', $result);
        
        if ($result['success']) {
            $this->assertTrue($result['success'], 'La conexión debería ser exitosa en modo simulado');
        } else {
            $this->assertArrayHasKey('error', $result, 'Debería haber un mensaje de error si falla');
        }
    }

    /**
     * Test that the WhatsApp service can get status.
     */
    public function test_whatsapp_service_can_get_status()
    {
        $service = new \App\Services\WhatsAppService();
        
        // Get status
        $result = $service->getStatus();
        
        $this->assertIsArray($result);
        $this->assertArrayHasKey('success', $result);
        
        if ($result['success']) {
            $this->assertArrayHasKey('status', $result);
            $this->assertArrayHasKey('isReady', $result);
        }
    }

    /**
     * Test that the WhatsApp service can get queue stats.
     */
    public function test_whatsapp_service_can_get_queue_stats()
    {
        $service = new \App\Services\WhatsAppService();
        
        // Get queue stats
        $result = $service->getQueueStats();
        
        $this->assertIsArray($result);
        $this->assertArrayHasKey('success', $result);
        
        if ($result['success']) {
            $this->assertArrayHasKey('stats', $result);
            $this->assertIsArray($result['stats']);
        }
    }

    /**
     * Test that the WhatsApp service can get daily stats.
     */
    public function test_whatsapp_service_can_get_daily_stats()
    {
        $service = new \App\Services\WhatsAppService();
        
        // Get daily stats
        $result = $service->getDailyStats();
        
        $this->assertIsArray($result);
        $this->assertArrayHasKey('success', $result);
        
        if ($result['success']) {
            $this->assertArrayHasKey('stats', $result);
            $this->assertIsArray($result['stats']);
        }
    }
}