<?php

require __DIR__.'/vendor/autoload.php';

use App\Models\Empresa;
use Illuminate\Support\Str;

// Crear empresa de prueba
try {
    $empresa = Empresa::create([
        'razon_social' => 'Empresa de Prueba S.A.',
        'documento' => 'J-12345678-9',
        'direccion' => 'Av. Principal, Edificio Test',
        'latitud' => 10.5,
        'longitud' => -66.9,
        'representante_legal' => 'Juan Pérez',
        'status' => true,
        'telefono' => '0212-1234567',
        'email' => 'contacto@empresaprueba.com',
        'pais_id' => 1,
        'whatsapp_api_key' => 'wapi_empresa-de-prueba-s.a_' . date('YmdHis') . '_' . Str::random(16)
    ]);

    echo "Empresa creada exitosamente!\n";
    echo "ID: " . $empresa->id . "\n";
    echo "Razón Social: " . $empresa->razon_social . "\n";
    echo "WhatsApp API Key: " . $empresa->whatsapp_api_key . "\n";

} catch (\Exception $e) {
    echo "Error al crear empresa: " . $e->getMessage() . "\n";
}