<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🧪 PROBANDO FORMATO DE TELÉFONO\n";
echo "================================\n\n";

$whatsappService = new \App\Services\WhatsAppService();

$testNumbers = [
    '04242115948',
    '4242115948',
    '584242115948',
    '+584242115948',
    '0424170346',
    '424170346',
    '58424170346',
];

foreach ($testNumbers as $number) {
    echo "Número original: {$number}\n";
    $cleanNumber = $whatsappService->cleanPhoneNumber($number);
    echo "Número formateado: {$cleanNumber}\n";
    echo "---\n";
}