<?php

require_once 'vendor/autoload.php';

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "🔍 PROBANDO SINCRONIZACIÓN JWT ENTRE LARAVEL Y WHATSAPP API\n";
echo "============================================================\n\n";

// 1. Verificar JWT secret de Laravel
$laravelJwtSecret = config('app.jwt_secret');
echo "1. Laravel JWT Secret: " . substr($laravelJwtSecret, 0, 10) . "...\n";

// 2. Verificar conexión con WhatsApp API
$whatsappService = new \App\Services\WhatsAppService();

echo "\n2. PROBANDO CONEXIÓN CON WHATSAPP API\n";
echo "   ---------------------------------\n";

try {
    $status = $whatsappService->getStatus();
    
    if ($status) {
        echo "   ✅ Conexión exitosa con WhatsApp API\n";
        echo "   Estado: " . ($status['status'] ?? 'desconocido') . "\n";
        echo "   Listo: " . ($status['isReady'] ?? 'false') . "\n";
    } else {
        echo "   ❌ No se pudo obtener estado de WhatsApp API\n";
    }
    
} catch (Exception $e) {
    echo "   ❌ Error conectando con WhatsApp API: " . $e->getMessage() . "\n";
}

// 3. Probar envío de mensaje de prueba
echo "\n3. PROBANDO ENVÍO DE MENSAJE\n";
echo "   -------------------------\n";

try {
    $result = $whatsappService->sendMessage('584241234567', '🧪 Test de sincronización JWT');
    
    if ($result) {
        echo "   ✅ Mensaje enviado exitosamente\n";
        echo "   ID del mensaje: " . ($result['messageId'] ?? 'N/A') . "\n";
    } else {
        echo "   ❌ No se pudo enviar el mensaje\n";
    }
    
} catch (Exception $e) {
    echo "   ❌ Error enviando mensaje: " . $e->getMessage() . "\n";
}

echo "\n✅ Prueba de sincronización completada\n";