<?php

require_once __DIR__ . '/vendor/autoload.php';

use App\Services\WhatsAppService;

echo "=== PRUEBA DE ENVÍO DIRECTO DE WHATSAPP ===\n\n";

$whatsappService = new WhatsAppService();

// Probar con tu número
$telefono = '584242115948';
$mensaje = "🧪 *Mensaje de prueba directa*\n\n";
$mensaje .= "Esta es una prueba directa del servicio de WhatsApp.\n";
$mensaje .= "Hora: " . date('Y-m-d H:i:s') . "\n";
$mensaje .= "Número: $telefono";

echo "Enviando mensaje a: $telefono\n";
echo "Mensaje: $mensaje\n\n";

try {
    $resultado = $whatsappService->sendMessage($telefono, $mensaje);
    
    echo "=== RESULTADO ===\n";
    echo "Success: " . ($resultado['success'] ? 'Sí' : 'No') . "\n";
    echo "Simulated: " . (isset($resultado['simulated']) && $resultado['simulated'] ? 'Sí' : 'No') . "\n";
    
    if (isset($resultado['message_id'])) {
        echo "Message ID: " . $resultado['message_id'] . "\n";
    }
    
    if (isset($resultado['error'])) {
        echo "Error: " . $resultado['error'] . "\n";
    }
    
    echo "Respuesta completa: " . json_encode($resultado, JSON_PRETTY_PRINT) . "\n";
    
} catch (Exception $e) {
    echo "❌ ERROR: " . $e->getMessage() . "\n";
    echo "Stack trace: " . $e->getTraceAsString() . "\n";
}

echo "\n=== FIN DE PRUEBA ===\n";