<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Cotización <?php echo e($cotizacion->numero_completo); ?></h1>
            <p class="mb-0 text-muted">Detalle completo de la cotización</p>
        </div>
        <div>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cotizacion->estado === 'aprobada' && !$cotizacion->nota_venta_id): ?>
                <button wire:click="abrirModalConvertir" class="btn btn-success me-2">
                    <i class="ri-exchange-line me-2"></i>Convertir a Nota de Venta
                </button>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cotizacion->nota_venta_id): ?>
                <a href="<?php echo e(route('admin.notas-venta.show', $cotizacion->nota_venta_id)); ?>" class="btn btn-info me-2">
                    <i class="ri-file-text-line me-2"></i>Ver Nota de Venta
                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cotizacion->estado === 'pendiente'): ?>
                <a href="<?php echo e(route('admin.cotizaciones.edit', $cotizacion->id)); ?>" class="btn btn-outline-primary me-2">
                    <i class="ri-edit-line me-2"></i>Editar
                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <a href="<?php echo e(route('admin.cotizaciones.index')); ?>" class="btn btn-outline-secondary">
                <i class="ri-arrow-left-line me-2"></i>Volver al listado
            </a>
        </div>
    </div>

    <div class="row">
        <!-- Información Principal -->
        <div class="col-lg-8">
            <!-- Datos de la Cotización -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Información General</h5>
                        <div class="d-flex gap-2">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cotizacion->estado === 'pendiente'): ?>
                                <button wire:click="cambiarEstado('aprobada')" class="btn btn-success btn-sm">
                                    <i class="ri-check-line me-1"></i>Aprobar
                                </button>
                                <button wire:click="cambiarEstado('rechazada')" class="btn btn-danger btn-sm">
                                    <i class="ri-close-line me-1"></i>Rechazar
                                </button>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row g-4">
                        <div class="col-md-6">
                            <div class="d-flex align-items-center mb-3">
                                <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                    <i class="ri-file-text-line text-primary"></i>
                                </div>
                                <div>
                                    <h6 class="mb-0"><?php echo e($cotizacion->numero_completo); ?></h6>
                                    <small class="text-muted">Número de Cotización</small>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label text-muted small">FECHA DE EMISIÓN</label>
                                <div class="fw-semibold"><?php echo e($cotizacion->fecha_emision->format('d/m/Y')); ?></div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label text-muted small">FECHA DE VENCIMIENTO</label>
                                <div class="fw-semibold"><?php echo e($cotizacion->fecha_vencimiento->format('d/m/Y')); ?></div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted small">CLIENTE</label>
                                <div class="d-flex align-items-center">
                                    <i class="ri-user-line text-muted me-2"></i>
                                    <span class="fw-semibold"><?php echo e($cotizacion->cliente->nombre_completo ?? 'Sin cliente'); ?></span>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label text-muted small">ESTADO</label>
                                <div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($cotizacion->estado):
                                        case ('pendiente'): ?>
                                            <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-3 py-2">
                                                <i class="ri-time-line me-1"></i>Pendiente
                                            </span>
                                            <?php break; ?>
                                        <?php case ('aprobada'): ?>
                                            <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-3 py-2">
                                                <i class="ri-check-line me-1"></i>Aprobada
                                            </span>
                                            <?php break; ?>
                                        <?php case ('rechazada'): ?>
                                            <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-3 py-2">
                                                <i class="ri-close-line me-1"></i>Rechazada
                                            </span>
                                            <?php break; ?>
                                        <?php case ('vencida'): ?>
                                            <span class="badge bg-secondary bg-opacity-10 text-secondary border border-secondary border-opacity-25 px-3 py-2">
                                                <i class="ri-calendar-line me-1"></i>Vencida
                                            </span>
                                            <?php break; ?>
                                        <?php case ('convertida'): ?>
                                            <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25 px-3 py-2">
                                                <i class="ri-exchange-line me-1"></i>Convertida
                                            </span>
                                            <?php break; ?>
                                    <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label text-muted small">CREADO POR</label>
                                <div class="fw-semibold"><?php echo e($cotizacion->user->name ?? 'Usuario'); ?></div>
                                <small class="text-muted"><?php echo e($cotizacion->created_at->format('d/m/Y H:i')); ?></small>
                            </div>
                        </div>
                        
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cotizacion->observaciones): ?>
                            <div class="col-12">
                                <label class="form-label text-muted small">OBSERVACIONES</label>
                                <div class="bg-light rounded p-3">
                                    <?php echo e($cotizacion->observaciones); ?>

                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Productos -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Productos Cotizados</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="border-0 ps-4">Producto</th>
                                    <th class="border-0 text-center">Cantidad</th>
                                    <th class="border-0 text-end">Precio Unit.</th>
                                    <th class="border-0 text-end pe-4">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $cotizacion->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="ps-4">
                                            <div class="d-flex align-items-center">
                                                <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                    <i class="ri-product-hunt-line text-primary"></i>
                                                </div>
                                                <div>
                                                    <div class="fw-semibold"><?php echo e($detalle->descripcion); ?></div>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($detalle->producto): ?>
                                                        <small class="text-muted"><?php echo e($detalle->producto->codigo); ?></small>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-light text-dark px-3 py-2"><?php echo e(number_format($detalle->cantidad, 2)); ?></span>
                                        </td>
                                        <td class="text-end"><?php echo e(format_money($detalle->precio_unitario)); ?></td>
                                        <td class="text-end pe-4 fw-semibold"><?php echo e(format_money($detalle->subtotal)); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Resumen y Acciones -->
        <div class="col-lg-4">
            <!-- Resumen Financiero -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Resumen Financiero</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-3">
                        <span class="text-muted">Subtotal:</span>
                        <span class="fw-semibold"><?php echo e(format_money($cotizacion->subtotal)); ?></span>
                    </div>
                    <div class="d-flex justify-content-between mb-3">
                        <span class="text-muted">Impuestos:</span>
                        <span class="fw-semibold"><?php echo e(format_money($cotizacion->impuestos)); ?></span>
                    </div>
                    <div class="border-top pt-3">
                        <div class="d-flex justify-content-between">
                            <span class="fw-bold fs-5">Total:</span>
                            <span class="fw-bold fs-4 text-primary"><?php echo e(format_money($cotizacion->total)); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Información Adicional -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Información Adicional</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label text-muted small">EMPRESA</label>
                        <div class="fw-semibold"><?php echo e($cotizacion->empresa->nombre ?? 'N/A'); ?></div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted small">SUCURSAL</label>
                        <div class="fw-semibold"><?php echo e($cotizacion->sucursal->nombre ?? 'N/A'); ?></div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label text-muted small">ÚLTIMA ACTUALIZACIÓN</label>
                        <div class="fw-semibold"><?php echo e($cotizacion->updated_at->format('d/m/Y H:i')); ?></div>
                    </div>
                    
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cotizacion->fecha_vencimiento < now() && $cotizacion->estado === 'pendiente'): ?>
                        <div class="alert alert-warning">
                            <i class="ri-alert-line me-2"></i>
                            <strong>Cotización Vencida</strong><br>
                            Esta cotización venció el <?php echo e($cotizacion->fecha_vencimiento->format('d/m/Y')); ?>

                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Convertir a Nota de Venta -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showConvertModal): ?>
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Convertir a Nota de Venta</h5>
                        <button type="button" wire:click="cerrarModalConvertir" class="btn-close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-info">
                            <i class="ri-information-line me-2"></i>
                            Se creará una nota de venta con todos los productos de esta cotización.
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label">Observaciones para la Nota de Venta</label>
                            <textarea wire:model="observaciones_nota" class="form-control" rows="3" 
                                      placeholder="Observaciones adicionales para la nota de venta..."></textarea>
                        </div>
                        
                        <div class="bg-light rounded p-3">
                            <div class="d-flex justify-content-between mb-2">
                                <span>Total:</span>
                                <span class="fw-bold"><?php echo e(format_money($cotizacion->total)); ?></span>
                            </div>
                            <div class="d-flex justify-content-between">
                                <span>Cliente:</span>
                                <span class="fw-semibold"><?php echo e($cotizacion->cliente->nombre_completo ?? 'Sin cliente'); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" wire:click="cerrarModalConvertir" class="btn btn-secondary">Cancelar</button>
                        <button type="button" wire:click="convertirANotaVenta" class="btn btn-success">
                            <i class="ri-exchange-line me-2"></i>Convertir a Nota de Venta
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div><?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/cotizaciones/show.blade.php ENDPATH**/ ?>