<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Estadísticas Detalladas</h5>
        <div class="btn-group" role="group">
            <button type="button" wire:click="setPeriod('week')" class="btn btn-sm btn-<?php echo e($period == 'week' ? 'primary' : 'outline-primary'); ?>">
                7 días
            </button>
            <button type="button" wire:click="setPeriod('month')" class="btn btn-sm btn-<?php echo e($period == 'month' ? 'primary' : 'outline-primary'); ?>">
                Mes
            </button>
            <button type="button" wire:click="setPeriod('quarter')" class="btn btn-sm btn-<?php echo e($period == 'quarter' ? 'primary' : 'outline-primary'); ?>">
                Trimestre
            </button>
            <button type="button" wire:click="setPeriod('year')" class="btn btn-sm btn-<?php echo e($period == 'year' ? 'primary' : 'outline-primary'); ?>">
                Año
            </button>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-3 mb-3">
                <div class="d-flex align-items-center">
                    <div class="avatar flex-shrink-0 me-3">
                        <div class="avatar-initial bg-primary rounded">
                            <i class="ri-shopping-cart-line"></i>
                        </div>
                    </div>
                    <div>
                        <span class="fw-semibold d-block mb-1">Total Pedidos</span>
                        <h4 class="card-title mb-1"><?php echo e(number_format($stats['current']['total_pedidos'])); ?></h4>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($stats['changes']['total_pedidos'] != 0): ?>
                            <small class="text-<?php echo e($stats['changes']['total_pedidos'] > 0 ? 'success' : 'danger'); ?>">
                                <i class="ri-arrow-<?php echo e($stats['changes']['total_pedidos'] > 0 ? 'up' : 'down'); ?>-line"></i>
                                <?php echo e(abs($stats['changes']['total_pedidos'])); ?>%
                            </small>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-3 mb-3">
                <div class="d-flex align-items-center">
                    <div class="avatar flex-shrink-0 me-3">
                        <div class="avatar-initial bg-success rounded">
                            <i class="ri-check-line"></i>
                        </div>
                    </div>
                    <div>
                        <span class="fw-semibold d-block mb-1">Completados</span>
                        <h4 class="card-title mb-1"><?php echo e(number_format($stats['current']['pedidos_completados'])); ?></h4>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($stats['changes']['pedidos_completados'] != 0): ?>
                            <small class="text-<?php echo e($stats['changes']['pedidos_completados'] > 0 ? 'success' : 'danger'); ?>">
                                <i class="ri-arrow-<?php echo e($stats['changes']['pedidos_completados'] > 0 ? 'up' : 'down'); ?>-line"></i>
                                <?php echo e(abs($stats['changes']['pedidos_completados'])); ?>%
                            </small>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-3 mb-3">
                <div class="d-flex align-items-center">
                    <div class="avatar flex-shrink-0 me-3">
                        <div class="avatar-initial bg-info rounded">
                            <i class="ri-money-dollar-circle-line"></i>
                        </div>
                    </div>
                    <div>
                        <span class="fw-semibold d-block mb-1">Total Gastado</span>
                        <h4 class="card-title mb-1">$<?php echo e(number_format($stats['current']['total_gastado'], 2)); ?></h4>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($stats['changes']['total_gastado'] != 0): ?>
                            <small class="text-<?php echo e($stats['changes']['total_gastado'] > 0 ? 'success' : 'danger'); ?>">
                                <i class="ri-arrow-<?php echo e($stats['changes']['total_gastado'] > 0 ? 'up' : 'down'); ?>-line"></i>
                                <?php echo e(abs($stats['changes']['total_gastado'])); ?>%
                            </small>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-3 mb-3">
                <div class="d-flex align-items-center">
                    <div class="avatar flex-shrink-0 me-3">
                        <div class="avatar-initial bg-warning rounded">
                            <i class="ri-bar-chart-line"></i>
                        </div>
                    </div>
                    <div>
                        <span class="fw-semibold d-block mb-1">Promedio por Pedido</span>
                        <h4 class="card-title mb-1">$<?php echo e(number_format($stats['current']['promedio_pedido'], 2)); ?></h4>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($stats['changes']['promedio_pedido'] != 0): ?>
                            <small class="text-<?php echo e($stats['changes']['promedio_pedido'] > 0 ? 'success' : 'danger'); ?>">
                                <i class="ri-arrow-<?php echo e($stats['changes']['promedio_pedido'] > 0 ? 'up' : 'down'); ?>-line"></i>
                                <?php echo e(abs($stats['changes']['promedio_pedido'])); ?>%
                            </small>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Chart -->
        <div class="mt-4">
            <h6 class="mb-3">Actividad de Pedidos (<?php echo e($stats['period_name']); ?>)</h6>
            <div id="activityChart" wire:ignore style="height: 300px;"></div>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
<script>
let activityChart;

function initChart(chartData) {
    const chartElement = document.querySelector("#activityChart");
    if (!chartElement || !chartElement.offsetParent) {
        setTimeout(() => initChart(chartData), 100);
        return;
    }

    const options = {
        series: [{
            name: 'Pedidos',
            data: chartData.map(item => item.pedidos)
        }],
        chart: {
            type: 'area',
            height: 300,
            toolbar: {
                show: false
            }
        },
        dataLabels: {
            enabled: false
        },
        stroke: {
            curve: 'smooth',
            width: 2
        },
        xaxis: {
            categories: chartData.map(item => item.label || item.date),
            labels: {
                rotate: chartData.length > 30 ? -45 : 0,
                maxHeight: 60,
                style: {
                    fontSize: chartData.length > 90 ? '10px' : '12px'
                }
            }
        },
        yaxis: {
            title: {
                text: 'Número de Pedidos'
            }
        },
        fill: {
            type: 'gradient',
            gradient: {
                shadeIntensity: 1,
                opacityFrom: 0.7,
                opacityTo: 0.3,
                stops: [0, 90, 100]
            }
        },
        colors: ['#696cff'],
        grid: {
            borderColor: '#e7e7e7',
            strokeDashArray: 5
        },
        tooltip: {
            x: {
                formatter: function(val, opts) {
                    if (chartData[opts.dataPointIndex]) {
                        const item = chartData[opts.dataPointIndex];
                        const date = new Date(item.date);
                        return date.toLocaleDateString('es-ES', { 
                            weekday: 'long', 
                            year: 'numeric', 
                            month: 'long', 
                            day: 'numeric' 
                        });
                    }
                    return val;
                }
            },
            y: {
                formatter: function(val) {
                    return val + ' pedidos';
                }
            }
        }
    };

    if (activityChart) {
        activityChart.destroy();
    }
    
    activityChart = new ApexCharts(chartElement, options);
    activityChart.render();
}

document.addEventListener('DOMContentLoaded', function() {
    setTimeout(() => {
        initChart(<?php echo json_encode($chartData, 15, 512) ?>);
    }, 200);
});

document.addEventListener('livewire:initialized', () => {
    Livewire.on('updateChart', (event) => {
        initChart(event.chartData);
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/users/profile/profile-stats.blade.php ENDPATH**/ ?>