<div>
    <?php $__env->startSection('title', 'Detalle del Pedido #' . $pedido->codigo); ?>

    <style>
        /* Header con gradiente */
        .order-header {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, var(--velzon-secondary) 100%);
            border-radius: var(--velzon-radius-xl);
            color: white;
            position: relative;
            overflow: hidden;
            animation: headerFadeIn 0.8s ease-out;
        }

        @keyframes headerFadeIn {
            from {
                opacity: 0;
                transform: translateY(-20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .order-header::after {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: linear-gradient(45deg, transparent 30%, rgba(255,255,255,0.1) 50%, transparent 70%);
            transform: rotate(45deg);
            animation: shine 3s infinite;
        }

        @keyframes shine {
            0% {
                transform: translateX(-100%) translateY(-100%) rotate(45deg);
            }
            100% {
                transform: translateX(100%) translateY(100%) rotate(45deg);
            }
        }

        .order-header::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 300px;
            height: 100%;

            background-size: contain;
            opacity: 0.5;
        }

        .order-number {
            font-size: 2.5rem;
            font-weight: 800;
            letter-spacing: 2px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.2);
        }

        .order-date-time {
            background: rgba(255,255,255,0.15);
            backdrop-filter: blur(10px);
            border-radius: 50px;
            padding: 0.5rem 1rem;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            font-weight: 500;
            border: 1px solid rgba(255,255,255,0.2);
            transition: all 0.3s ease;
        }

        .order-date-time:hover {
            background: rgba(255,255,255,0.25);
            transform: translateY(-2px);
        }



        .order-status-badge:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 25px rgba(0,0,0,0.15);
        }

        .order-icon-wrapper {
            position: relative;
            transition: all 0.3s ease;
        }

        .order-icon-wrapper:hover {
            transform: scale(1.1) rotate(5deg);
        }

        .order-icon-wrapper::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 0;
            height: 0;
            background: rgba(255,255,255,0.3);
            border-radius: 50%;
            transform: translate(-50%, -50%);
            transition: all 0.5s ease;
        }

        .order-icon-wrapper:hover::before {
            width: 120%;
            height: 120%;
        }

        /* Timeline de estado */
        .order-timeline {
            display: flex;
            justify-content: space-between;
            position: relative;
            padding: 1rem 0;
        }

        .order-timeline::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--velzon-gray-200);
            transform: translateY(-50%);
            z-index: 0;
        }

        .timeline-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            position: relative;
            z-index: 1;
            flex: 1;
        }

        .timeline-step .step-icon {
            width: 48px;
            height: 48px;
            border-radius: 50%;
            background: var(--velzon-gray-200);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.25rem;
            color: var(--velzon-gray-500);
            transition: all var(--velzon-transition);
            border: 3px solid white;
            box-shadow: var(--velzon-shadow-sm);
        }

        .timeline-step.active .step-icon {
            background: var(--velzon-primary);
            color: white;
        }

        .timeline-step.completed .step-icon {
            background: var(--velzon-success);
            color: white;
        }

        .timeline-step .step-label {
            margin-top: 0.5rem;
            font-size: 0.75rem;
            font-weight: 500;
            color: var(--velzon-gray-600);
            text-align: center;
        }

        .timeline-step.active .step-label,
        .timeline-step.completed .step-label {
            color: var(--velzon-gray-800);
            font-weight: 600;
        }

        /* Product cards mejoradas */
        .product-item {
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-lg);
            padding: 1rem;
            margin-bottom: 1rem;
            border: 1px solid var(--velzon-gray-200);
            transition: all var(--velzon-transition);
        }

        .product-item:hover {
            transform: translateX(5px);
            box-shadow: var(--velzon-shadow);
            border-color: rgba(var(--velzon-primary-rgb), 0.3);
        }

        /* Estilos para el mapa de LeafletJS */
        .map-container {
            position: relative;
            border-radius: var(--velzon-radius-lg);
            overflow: hidden;
            box-shadow: var(--velzon-shadow-sm);
            border: 1px solid var(--velzon-gray-200);
            background: var(--velzon-white);
        }

        .map-container .leaflet-container {
            height: 300px;
            width: 100%;
            border-radius: var(--velzon-radius-lg);
        }

        .map-loading {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            z-index: 1000;
            background: rgba(255, 255, 255, 0.9);
            padding: 1rem 1.5rem;
            border-radius: var(--velzon-radius);
            box-shadow: var(--velzon-shadow);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .map-placeholder {
            height: 300px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            border: 2px dashed var(--velzon-gray-300);
            border-radius: var(--velzon-radius-lg);
            color: var(--velzon-gray-500);
            transition: all var(--velzon-transition);
            cursor: pointer;
        }

        .map-placeholder:hover {
            background: linear-gradient(135deg, #e9ecef 0%, #dee2e6 100%);
            border-color: var(--velzon-primary);
            color: var(--velzon-primary);
        }

        .map-placeholder i {
            font-size: 3rem;
            margin-bottom: 1rem;
            opacity: 0.7;
        }

        .map-placeholder span {
            font-size: 0.9rem;
            font-weight: 500;
        }

        /* Estilos personalizados para el popup del marcador */
        .custom-popup .leaflet-popup-content-wrapper {
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-lg);
            box-shadow: var(--velzon-shadow-lg);
            border: 1px solid var(--velzon-gray-200);
        }

        .custom-popup .leaflet-popup-content {
            margin: 1rem;
            line-height: 1.5;
        }

        .custom-popup .leaflet-popup-tip {
            background: var(--velzon-white);
            border: 1px solid var(--velzon-gray-200);
        }

        .popup-content {
            text-align: center;
            min-width: 200px;
        }

        .popup-title {
            font-weight: 600;
            color: var(--velzon-primary);
            margin-bottom: 0.5rem;
            font-size: 1rem;
        }

        .popup-address {
            color: var(--velzon-gray-600);
            font-size: 0.85rem;
            margin-bottom: 0.5rem;
        }

        .popup-coords {
            font-size: 0.75rem;
            color: var(--velzon-gray-500);
            font-family: 'Courier New', monospace;
        }

        .product-item-img {
            width: 90px;
            height: 90px;
            object-fit: cover;
            border-radius: var(--velzon-radius-lg);
            box-shadow: var(--velzon-shadow-sm);
        }

        .product-item-placeholder {
            width: 90px;
            height: 90px;
            border-radius: var(--velzon-radius-lg);
            background: linear-gradient(135deg, var(--velzon-gray-100), var(--velzon-gray-200));
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 2rem;
            color: var(--velzon-gray-400);
        }

        /* Payment info cards */
        .payment-info-card {
            background: linear-gradient(135deg, var(--velzon-gray-100) 0%, var(--velzon-white) 100%);
            border-radius: var(--velzon-radius-lg);
            padding: 1.25rem;
            border-left: 4px solid var(--velzon-primary);
        }

        .payment-detail-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem 0;
            border-bottom: 1px dashed var(--velzon-gray-200);
        }

        .payment-detail-row:last-child {
            border-bottom: none;
        }

        /* Summary card mejorada */
        .summary-card-velzon {
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-xl);
            box-shadow: var(--velzon-shadow-lg);
            overflow: hidden;
        }

        .summary-header {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, rgba(var(--velzon-primary-rgb), 0.8) 100%);
            color: white;
            padding: 1.25rem;
        }

        .summary-total {
            background: linear-gradient(135deg, var(--velzon-success) 0%, #08977f 100%);
            color: white;
            padding: 1rem 1.25rem;
            margin: 0 -1.25rem;
        }

        /* Status badges mejorados */
        .status-badge-velzon {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            border-radius: 50px;
            font-weight: 600;
            font-size: 0.875rem;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }

        .status-badge-velzon.status-pendiente {
            background: rgba(var(--velzon-warning-rgb), 0.15);
            color: #cc8d19;
        }

        .status-badge-velzon.status-procesando {
            background: rgba(var(--velzon-info-rgb), 0.15);
            color: var(--velzon-info);
        }

        .status-badge-velzon.status-completado {
            background: rgba(var(--velzon-success-rgb), 0.15);
            color: var(--velzon-success);
        }

        .status-badge-velzon.status-cancelado {
            background: rgba(var(--velzon-danger-rgb), 0.15);
            color: var(--velzon-danger);
        }

        /* Action buttons */
        .action-btn {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
            padding: 0.75rem 1rem;
            border-radius: var(--velzon-radius-lg);
            font-weight: 500;
            transition: all var(--velzon-transition);
        }

        .action-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--velzon-shadow);
        }

        /* Map placeholder */
        .map-placeholder {
            background: linear-gradient(135deg, var(--velzon-gray-100), var(--velzon-gray-200));
            border-radius: var(--velzon-radius-lg);
            height: 150px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: var(--velzon-gray-500);
            border: 2px dashed var(--velzon-gray-300);
        }

        /* Product list scroll */
        .product-list-scroll::-webkit-scrollbar {
            width: 6px;
        }

        .product-list-scroll::-webkit-scrollbar-track {
            background: var(--velzon-gray-100);
            border-radius: 3px;
        }

        .product-list-scroll::-webkit-scrollbar-thumb {
            background: var(--velzon-gray-400);
            border-radius: 3px;
        }

        .product-list-scroll::-webkit-scrollbar-thumb:hover {
            background: var(--velzon-gray-500);
        }

        /* Card velzon */
        .card-velzon {
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-xl);
            border: none;
            box-shadow: var(--velzon-shadow-sm);
            overflow: hidden;
            transition: box-shadow var(--velzon-transition);
        }

        .card-velzon:hover {
            box-shadow: var(--velzon-shadow);
        }

        .card-header-velzon {
            background: var(--velzon-white);
            border-bottom: 1px solid var(--velzon-gray-200);
            padding: 1rem 1.25rem;
        }

        /* Pagos realizados */
        .pago-card {
            background: var(--velzon-gray-100);
            border-radius: var(--velzon-radius-lg);
            padding: 1rem;
            border-left: 3px solid var(--velzon-success);
            transition: all var(--velzon-transition);
        }

        .pago-card:hover {
            background: var(--velzon-white);
            box-shadow: var(--velzon-shadow-sm);
        }

        @media print {
            .no-print { display: none !important; }
            .order-header { background: var(--velzon-gray-200) !important; -webkit-print-color-adjust: exact; }
        }
    </style>

    <section class="section bg-light py-4">
        <div class="container">
            <!-- Breadcrumb -->
            <div class="row mb-4 no-print">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb mb-0">
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(url('front/store')); ?>" class="text-velzon-primary">
                                    <i class="ri-home-4-line"></i> Inicio
                                </a>
                            </li>
                            <li class="breadcrumb-item">
                                <a href="<?php echo e(route('front.pedido.historico')); ?>" class="text-velzon-primary">Mis Pedidos</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Pedido #<?php echo e($pedido->codigo); ?></li>
                        </ol>
                    </nav>
                </div>
            </div>

            <!-- Header del Pedido con Gradiente -->
            <div class="order-header p-4 mb-4">
                <div class="row align-items-center">
                    <div class="col-lg-8">
                        <div class="d-flex align-items-center gap-4 mb-3">

                            <div>
                                <p class="mb-1 opacity-75 fw-medium">Número de Pedido</p>
                                <h1 class="order-number mb-0 text-white">#<?php echo e($pedido->codigo); ?></h1>
                            </div>
                        </div>
                        <div class="d-flex flex-wrap gap-3">
                            <span>
                                <i class="ri-calendar-2-line"></i>
                                <?php echo e($pedido->created_at->format('d/m/Y')); ?>

                            </span>
                            <span class="">
                                <i class="ri-time-line"></i>
                                <?php echo e($pedido->created_at->format('H:i')); ?>

                            </span>
                        </div>
                    </div>
                    <div class="col-lg-4 text-lg-end mt-3 mt-lg-0">

                    </div>
                </div>
            </div>

            <!-- Timeline Visual del Estado -->
            <div class="card-velzon p-4 mb-4">
                <h6 class="mb-4 text-velzon-primary">
                    <i class="ri-route-line me-2"></i>Seguimiento del Pedido
                </h6>
                <?php
                    $estados = ['Pendiente', 'Procesando', 'Completado'];
                    $estadoActualIndex = array_search($pedido->estado, $estados);
                    if ($estadoActualIndex === false) $estadoActualIndex = -1;
                ?>
                <div class="order-timeline">
                    <div class="timeline-step <?php echo e($estadoActualIndex >= 0 ? ($estadoActualIndex > 0 ? 'completed' : 'active') : ''); ?>">
                        <div class="step-icon">
                            <i class="ri-file-list-3-line"></i>
                        </div>
                        <span class="step-label">Pedido Recibido</span>
                    </div>
                    <div class="timeline-step <?php echo e($estadoActualIndex >= 1 ? ($estadoActualIndex > 1 ? 'completed' : 'active') : ''); ?>">
                        <div class="step-icon">
                            <i class="ri-settings-3-line"></i>
                        </div>
                        <span class="step-label">En Proceso</span>
                    </div>
                    <div class="timeline-step <?php echo e($estadoActualIndex >= 2 ? 'completed' : ''); ?>">
                        <div class="step-icon">
                            <i class="ri-truck-line"></i>
                        </div>
                        <span class="step-label">En Camino</span>
                    </div>
                    <div class="timeline-step <?php echo e($estadoActualIndex >= 2 ? 'completed' : ''); ?>">
                        <div class="step-icon">
                            <i class="ri-checkbox-circle-line"></i>
                        </div>
                        <span class="step-label">Entregado</span>
                    </div>
                </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado == 'Cancelado'): ?>
                    <div class="alert alert-danger d-flex align-items-center mt-3 mb-0" role="alert">
                        <i class="ri-error-warning-line me-2 fs-5"></i>
                        <div>Este pedido ha sido <strong>cancelado</strong>.</div>
                    </div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            <div class="row">
                <div class="col-lg-8">
                    <!-- Productos del pedido -->
                    <div class="card-velzon mb-4">
                        <div class="card-header-velzon d-flex justify-content-between align-items-center">
                            <h5 class="mb-0 d-flex align-items-center gap-2">
                                <i class="ri-shopping-basket-2-line text-velzon-primary"></i>
                                Productos del Pedido
                            </h5>
                            <span class="badge-velzon badge-soft-primary">
                                <?php echo e($pedido->detalles->count()); ?> <?php echo e($pedido->detalles->count() == 1 ? 'producto' : 'productos'); ?>

                            </span>
                        </div>
                        <div class="card-body p-3">
                            <div class="product-list-scroll" style="max-height: 450px; overflow-y: auto; padding-right: 5px;">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $pedido->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $imageToShow = null;
                                        $productName = $detalle->product_name ?? $detalle->producto->name;

                                        if ($detalle->variant_id && $detalle->variant && $detalle->variant->image_path) {
                                            $imageToShow = $detalle->variant->image_path;
                                        } elseif ($detalle->producto && $detalle->producto->images && $detalle->producto->images->first()) {
                                            $imageToShow = $detalle->producto->images->first()->path;
                                        }
                                    ?>

                                    <div class="product-item d-flex align-items-center gap-3">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($imageToShow): ?>
                                            <img src="<?php echo e(asset('app/'.$imageToShow)); ?>"
                                                 alt="<?php echo e($productName); ?>"
                                                 class="product-item-img">
                                        <?php else: ?>
                                            <div class="product-item-placeholder">
                                                <i class="ri-image-line"></i>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                        <div class="flex-grow-1">
                                            <h6 class="mb-1 fw-semibold"><?php echo e($productName); ?></h6>
                                            <div class="d-flex flex-wrap gap-3 text-muted small">
                                                <span>
                                                    <i class="ri-stack-line me-1"></i>
                                                    Cant: <strong class="text-dark"><?php echo e($detalle->quantity); ?></strong>
                                                </span>
                                                <span>
                                                    <i class="ri-price-tag-3-line me-1"></i>
                                                    <?php echo e(format_money($detalle->price)); ?> c/u
                                                </span>
                                            </div>
                                        </div>

                                        <div class="text-end">
                                            <div class="fw-bold text-velzon-primary fs-5">
                                                <?php echo e(format_money($detalle->total_usd)); ?>

                                            </div>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(tasa() && empresa() == 'Venezuela'): ?>
                                                <small class="text-muted">
                                                    <?php echo e(number_format($detalle->total_usd * tasa()->usd_rate, 2)); ?> Bs
                                                </small>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Información de pago -->
                    <div class="card-velzon mb-4">
                        <div class="card-header-velzon">
                            <h5 class="mb-0 d-flex align-items-center gap-2">
                                <i class="ri-secure-payment-line text-velzon-primary"></i>
                                Información de Pago
                            </h5>
                        </div>
                        <div class="card-body p-4">
                            <div class="row g-4">
                                <div class="col-md-6">
                                    <div class="payment-info-card h-100">
                                        <h6 class="mb-3 d-flex align-items-center gap-2">
                                            <i class="ri-wallet-3-line text-velzon-secondary"></i>
                                            Método de Pago
                                        </h6>
                                        <div class="payment-detail-row">
                                            <span class="text-muted">Forma de pago</span>
                                            <span class="fw-semibold"><?php echo e($pedido->metodo_pago); ?></span>
                                        </div>

                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->metodo_pago == 'Mixto' && $pedido->referenciaBancaria): ?>
                                            <div class="mt-3 pt-3 border-top">
                                                <h6 class="mb-2 small text-uppercase text-muted">Desglose</h6>
                                                <div class="payment-detail-row">
                                                    <span class="d-flex align-items-center gap-2">
                                                        <i class="ri-money-dollar-circle-line text-velzon-success"></i>
                                                        Efectivo (USD)
                                                    </span>
                                                    <span class="fw-semibold"><?php echo e(format_money($pedido->referenciaBancaria->monto_efectivo)); ?></span>
                                                </div>
                                                <div class="payment-detail-row">
                                                    <span class="d-flex align-items-center gap-2">
                                                        <i class="ri-smartphone-line text-velzon-info"></i>
                                                        Digital
                                                    </span>
                                                    <span class="fw-semibold"><?php echo e(format_money($pedido->referenciaBancaria->monto_restante)); ?></span>
                                                </div>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>

                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->referenciaBancaria): ?>
                                    <div class="col-md-6">
                                        <div class="payment-info-card h-100" style="border-left-color: var(--velzon-success);">
                                            <h6 class="mb-3 d-flex align-items-center gap-2">
                                                <i class="ri-bank-line text-velzon-success"></i>
                                                Detalles Bancarios
                                            </h6>
                                            <div class="payment-detail-row">
                                                <span class="text-muted">Banco</span>
                                                <span class="fw-semibold"><?php echo e($pedido->referenciaBancaria->banco->nombre ?? 'N/A'); ?></span>
                                            </div>
                                            <div class="payment-detail-row">
                                                <span class="text-muted">Referencia</span>
                                                <code class="bg-light px-2 py-1 rounded"><?php echo e($pedido->referenciaBancaria->referencia); ?></code>
                                            </div>

                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->referenciaBancaria->tipo_pago == 'pago_movil'): ?>
                                                <div class="payment-detail-row">
                                                    <span class="text-muted">Documento</span>
                                                    <span class="fw-semibold"><?php echo e($pedido->referenciaBancaria->documento); ?></span>
                                                </div>
                                                <div class="payment-detail-row">
                                                    <span class="text-muted">Teléfono</span>
                                                    <span class="fw-semibold"><?php echo e($pedido->referenciaBancaria->numero_telefono); ?></span>
                                                </div>
                                            <?php else: ?>
                                                <div class="payment-detail-row">
                                                    <span class="text-muted">Nº Cuenta</span>
                                                    <span class="fw-semibold"><?php echo e($pedido->referenciaBancaria->numero_cuenta); ?></span>
                                                </div>
                                                <div class="payment-detail-row">
                                                    <span class="text-muted">Tipo</span>
                                                    <span class="fw-semibold"><?php echo e(ucfirst($pedido->referenciaBancaria->tipo_cuenta)); ?></span>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->pagos && $pedido->pagos->count() > 0): ?>
                                <div class="mt-4 pt-4 border-top">
                                    <h6 class="mb-3 d-flex align-items-center gap-2">
                                        <i class="ri-exchange-funds-line text-velzon-success"></i>
                                        Pagos Realizados
                                        <span class="badge-velzon badge-soft-success ms-2"><?php echo e($pedido->pagos->count()); ?></span>
                                    </h6>
                                    <div class="row g-3">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $pedido->pagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12">
                                                <div class="pago-card">
                                                    <div class="row align-items-center">
                                                        <div class="col-md-6">
                                                            <div class="d-flex align-items-center gap-2 mb-1">
                                                                <i class="ri-checkbox-circle-fill text-velzon-success"></i>
                                                                <strong><?php echo e($pago->metodo_pago); ?></strong>
                                                            </div>
                                                            <small class="text-muted">
                                                                <i class="ri-calendar-line me-1"></i>
                                                                <?php echo e($pago->created_at->format('d/m/Y H:i')); ?>

                                                            </small>
                                                        </div>
                                                        <div class="col-md-6 text-md-end mt-2 mt-md-0">
                                                            <div class="fw-bold text-velzon-success fs-5">
                                                                <?php echo e(format_money($pago->total_usd)); ?>

                                                            </div>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pago->total_bs && empresa() == 'Venezuela'): ?>
                                                                <small class="text-muted"><?php echo e(number_format($pago->total_bs, 2)); ?> Bs</small>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </div>
                                                    </div>

                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pago->referencia_bancaria): ?>
                                                        <div class="mt-2 pt-2 border-top d-flex flex-wrap gap-3">
                                                            <span class="small">
                                                                <i class="ri-hashtag me-1"></i>
                                                                Ref: <code><?php echo e($pago->referencia_bancaria); ?></code>
                                                            </span>
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pago->banco): ?>
                                                                <span class="small">
                                                                    <i class="ri-bank-line me-1"></i>
                                                                    <?php echo e($pago->banco->nombre ?? 'N/A'); ?>

                                                                </span>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </div>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Resumen del pedido -->
                <div class="col-lg-4">
                    <div class="summary-card-velzon sticky-top" style="top: 100px;">
                        <div class="summary-header">
                            <h5 class="mb-0 d-flex align-items-center gap-2 text-white">
                                <i class="ri-file-list-3-line"></i>
                                Resumen del Pedido
                            </h5>
                        </div>
                        <div class="card-body p-4">
                            <div class="mb-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('currency') && session()->get('currency') == 'usd'): ?>
                                    <div class="d-flex justify-content-between mb-2">
                                    <span class="text-muted">Subtotal</span>
                                    <span class="fw-semibold"><?php echo e(format_money($pedido->total_usd)); ?></span>
                                </div>
                                <?php else: ?>
                                    <div class="d-flex justify-content-between mb-2">
                                    <span class="text-muted">Subtotal</span>
                                    <span class="fw-semibold"><?php echo e(format_money($pedido->total_bs)); ?></span>
                                </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <div class="d-flex justify-content-between mb-2">
                                    <span class="text-muted">Envío</span>
                                    <span class="badge-velzon badge-soft-success">Gratis</span>
                                </div>
                                <?php if(tasa()): ?>
                                    <div class="d-flex justify-content-between">
                                        <span class="text-muted small">Tasa actual</span>
                                        <span class="small"><?php echo e(number_format(tasa()->usd_rate, 2)); ?> Bs/USD</span>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <div class="summary-total">
                                <div class="d-flex justify-content-between align-items-center">
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('currency') && session()->get('currency') == 'usd'): ?>
                                    <span class="fs-5">Total</span>
                                    <span class="fs-4 fw-bold"><?php echo e(format_money($pedido->total_usd)); ?></span>
                                </div>
                                <?php else: ?>
                                    <span class="fs-5">Total</span>
                                    <span class="fs-4 fw-bold"><?php echo e(format_money($pedido->total_bs)); ?></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(tasa() && empresa() == 'Venezuela'): ?>
                                    <div class="d-flex justify-content-between align-items-center mt-1 opacity-75">
                                </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                              </div>
                            </div>

                            <div class="mt-4">
                                <h6 class="mb-3 d-flex align-items-center gap-2">
                                    <i class="ri-map-pin-2-line text-velzon-danger"></i>
                                    Dirección de Entrega
                                </h6>
                                <p class="text-muted mb-3 small"><?php echo e($pedido->ubicacion); ?></p>

                                <!-- Mapa interactivo de LeafletJS -->
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->latitud && $pedido->longitud): ?>
                                    <div class="map-container mb-3">
                                        <div id="order-map" style="height: 300px; border-radius: var(--velzon-radius-lg);"></div>
                                        <div class="map-loading" id="map-loading">
                                            <i class="ri-map-pin-line text-velzon-primary"></i>
                                            <span>Cargando mapa...</span>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="map-placeholder mb-3">
                                        <i class="ri-map-2-line fs-1"></i>
                                        <span class="small mt-2">Ubicación no disponible</span>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>

                            <!-- Botones de acción -->
                            <div class="d-grid gap-2 mt-4 no-print">
                                <a href="<?php echo e(route('front.pedido.historico')); ?>" class="btn btn-primary action-btn">
                                    <i class="ri-arrow-left-line"></i> Volver al Historial
                                </a>

                                <button type="button" class="btn btn-soft-success action-btn" wire:click="$dispatch('openRepeatOrderModal', { pedidoId: <?php echo e($pedido->id); ?> })" disabled title="Próximamente">
                                    <i class="ri-refresh-line"></i> Repetir Pedido
                                </button>
                                <a href="https://wa.me/<?php echo e(config('app.whatsapp_support', '')); ?>?text=Hola, necesito ayuda con mi pedido %23<?php echo e($pedido->codigo); ?>"
                                   target="_blank"
                                   class="btn btn-success action-btn border">
                                    <i class="ri-whatsapp-line text-success"></i> Contactar Soporte
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<?php $__env->startSection('styles'); ?>
    <!-- CSS de LeafletJS -->
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"
          integrity="sha256-p4NxAoJBhIIN+hmNHrzRCf9tD/miZyoHS5obTRR9BMY="
          crossorigin=""/>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <!-- JavaScript de LeafletJS -->
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"
            integrity="sha256-20nQCchB9co0qIjJZRGuk2/Z9VM+kNiyxNV1lvTlZBo="
            crossorigin=""></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Verificar que el contenedor del mapa exista y tenga dimensiones
            const mapContainer = document.getElementById('order-map');
            const loadingElement = document.getElementById('map-loading');

            // Obtener las coordenadas desde los atributos de datos
            const lat = parseFloat('<?php echo e($pedido->latitud ?? ""); ?>');
            const lng = parseFloat('<?php echo e($pedido->longitud ?? ""); ?>');
            const ubicacion = "<?php echo e($pedido->ubicacion ?? ''); ?>";

            // Función para inicializar el mapa
            function initializeMap() {
                try {
                    // Verificar que el contenedor no esté ya inicializado
                    if (mapContainer._leaflet_id) {
                        console.log('⚠️ El mapa ya está inicializado, limpiando...');
                        mapContainer._leaflet_id = null;
                    }

                    // Crear el mapa
                    console.log('Creando mapa de LeafletJS...');
                    const map = L.map('order-map', {
                        zoomControl: true,
                        attributionControl: true
                    }).setView([lat, lng], 16);

                    console.log('Mapa creado exitosamente');

                    // Agregar capa de tiles de OpenStreetMap
                    console.log('Agregando capa de tiles...');

                    // Intentar con diferentes servidores de tiles si falla el primero
                    const tileUrls = [
                        'https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png',
                        'https://tile.openstreetmap.org/{z}/{x}/{y}.png',
                        'https://a.tile.openstreetmap.org/{z}/{x}/{y}.png'
                    ];

                    let tilesLoaded = false;

                    function tryLoadTiles(urlIndex = 0) {
                        if (urlIndex >= tileUrls.length) {
                            console.error('❌ No se pudieron cargar los tiles desde ningún servidor');

                            // Mostrar mensaje de error en el contenedor del mapa
                            if (mapContainer) {
                                mapContainer.innerHTML = `
                                    <div style="display: flex; flex-direction: column; align-items: center; justify-content: center; height: 100%; padding: 20px; text-align: center; background: linear-gradient(135deg, #ff6b6b, #ee5a24);">
                                        <div style="font-size: 3rem; margin-bottom: 15px;">🗺️</div>
                                        <div style="font-size: 1.2rem; font-weight: 600; color: white; margin-bottom: 10px;">
                                            Error al cargar el mapa
                                        </div>
                                        <div style="color: rgba(255,255,255,0.8); font-size: 0.9rem;">
                                            No se pudieron cargar los datos del mapa
                                        </div>
                                        <div style="margin-top: 15px; color: rgba(255,255,255,0.7); font-size: 0.8rem;">
                                            Coordenadas: ${lat}, ${lng}
                                        </div>
                                        <button onclick="location.reload()" style="margin-top: 15px; padding: 8px 16px; background: rgba(255,255,255,0.2); border: 1px solid rgba(255,255,255,0.3); color: white; border-radius: 6px; cursor: pointer; font-size: 0.9rem; transition: all 0.3s ease;">
                                            🔄 Recargar página
                                        </button>
                                    </div>
                                `;
                            }

                            // Ocultar el indicador de carga
                            if (loadingElement) {
                                loadingElement.style.display = 'none';
                            }

                            return;
                        }

                        const tileLayer = L.tileLayer(tileUrls[urlIndex], {
                            attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
                            maxZoom: 19,
                            tileSize: 256,
                            zoomOffset: 0,
                            errorTileUrl: 'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAYAAAAfFcSJAAAADUlEQVR42mNkYPhfDwAChwGA60e6kgAAAABJRU5ErkJggg=='
                        });

                        tileLayer.on('loading', function() {
                            console.log(`Cargando tiles desde: ${tileUrls[urlIndex]}`);
                        });

                        tileLayer.on('load', function() {
                            console.log('✅ Tiles cargados exitosamente');
                            tilesLoaded = true;
                        });

                        tileLayer.on('tileerror', function() {
                            if (!tilesLoaded) {
                                console.warn(`⚠️ Error cargando tiles desde: ${tileUrls[urlIndex]}`);
                                map.removeLayer(tileLayer);
                                tryLoadTiles(urlIndex + 1);
                            }
                        });

                        tileLayer.addTo(map);

                        // Verificar si los tiles se cargaron después de un tiempo
                        setTimeout(function() {
                            if (!tilesLoaded) {
                                console.warn(`⚠️ Timeout cargando tiles desde: ${tileUrls[urlIndex]}`);
                                map.removeLayer(tileLayer);
                                tryLoadTiles(urlIndex + 1);
                            }
                        }, 3000);
                    }

                    tryLoadTiles();

                    // Crear icono personalizado para el marcador
                    const customIcon = L.divIcon({
                        html: `<div style="
                            background: var(--velzon-primary);
                            color: white;
                            width: 40px;
                            height: 40px;
                            border-radius: 50% 50% 50% 0;
                            transform: rotate(-45deg);
                            display: flex;
                            align-items: center;
                            justify-content: center;
                            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
                            border: 3px solid white;
                        ">
                            <i class="ri-map-pin-line" style="
                                transform: rotate(45deg);
                                font-size: 18px;
                            "></i>
                        </div>`,
                        className: 'custom-marker-icon',
                        iconSize: [40, 40],
                        iconAnchor: [20, 35]
                    });

                    // Agregar marcador en la ubicación del pedido
                    const marker = L.marker([lat, lng], { icon: customIcon }).addTo(map);

                    // Crear contenido del popup
                    const popupContent = `
                        <div class="popup-content">
                            <div class="popup-title">
                                <i class="ri-map-pin-line"></i> Ubicación del Pedido
                            </div>
                            <div class="popup-address">
                                ${ubicacion}
                            </div>
                            <div class="popup-coords">
                                Coord: ${lat.toFixed(6)}, ${lng.toFixed(6)}
                            </div>
                        </div>
                    `;

                    // Agregar popup al marcador
                    marker.bindPopup(popupContent, {
                        className: 'custom-popup',
                        closeButton: true,
                        autoClose: true,
                        closeOnEscapeKey: true
                    });

                    // Abrir el popup automáticamente
                    marker.openPopup();

                    // Agregar control de escala
                    L.control.scale({
                        position: 'bottomleft',
                        imperial: false,
                        metric: true
                    }).addTo(map);

                    // Agregar botón personalizado para recargar el mapa
                    const reloadControl = L.Control.extend({
                        options: {
                            position: 'topright'
                        },
                        onAdd: function(map) {
                            const container = L.DomUtil.create('div', 'leaflet-control-reload');
                            container.innerHTML = '<button style="background: white; border: 2px solid #ccc; border-radius: 4px; padding: 5px; cursor: pointer; font-size: 14px;" title="Recargar mapa">🔄</button>';
                            container.onclick = function() {
                                location.reload();
                            };
                            return container;
                        }
                    });
                    map.addControl(new reloadControl());

                    // Forzar actualización del tamaño del mapa después de cargar
                    setTimeout(function() {
                        map.invalidateSize();
                        console.log('✅ Tamaño del mapa actualizado');
                    }, 500);

                    // Evento de clic en el mapa
                    map.on('click', function(e) {
                        // Opcional: puedes agregar funcionalidad adicional aquí
                        console.log('Coordenadas clicadas:', e.latlng.lat, e.latlng.lng);
                    });

                    // Ajustar el tamaño del mapa cuando se muestre
                    setTimeout(function() {
                        map.invalidateSize();
                    }, 100);

                    // Ocultar el indicador de carga
                    if (loadingElement) {
                        loadingElement.style.display = 'none';
                    }

                    console.log('✅ Mapa de LeafletJS cargado exitosamente');

                    // Verificar si hay bloqueadores de anuncios
                    setTimeout(function() {
                        if (mapContainer && mapContainer.querySelector('.leaflet-tile-pane')) {
                            console.log('✅ Los tiles del mapa están presentes');
                        } else {
                            console.warn('⚠️ Los tiles del mapa no están presentes, posible bloqueador de anuncios');

                            // Fallback a mapa estático de Google Maps
                            const staticMapUrl = `https://maps.googleapis.com/maps/api/staticmap?center=${lat},${lng}&zoom=16&size=600x400&markers=color:red%7C${lat},${lng}&key=YOUR_API_KEY`;

                            if (mapContainer) {
                                mapContainer.innerHTML = `
                                    <div style="position: relative; width: 100%; height: 100%; background: #f8f9fa; display: flex; align-items: center; justify-content: center;">
                                        <img src="${staticMapUrl}"
                                             style="width: 100%; height: 100%; object-fit: cover; border-radius: 8px;"
                                             alt="Mapa estático de la ubicación"
                                             onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                                        <div style="display: none; flex-direction: column; align-items: center; justify-content: center; height: 100%; padding: 20px; text-align: center;">
                                            <div style="font-size: 3rem; margin-bottom: 15px;">📍</div>
                                            <div style="font-size: 1.2rem; font-weight: 600; color: #495057; margin-bottom: 10px;">
                                                Ubicación del pedido
                                            </div>
                                            <div style="color: #6c757d; font-size: 0.9rem;">
                                                Lat: ${lat}, Lng: ${lng}
                                            </div>
                                            <a href="https://www.google.com/maps?q=${lat},${lng}"
                                               target="_blank"
                                               style="margin-top: 15px; padding: 8px 16px; background: #007bff; color: white; text-decoration: none; border-radius: 6px; font-size: 0.9rem;">
                                               Ver en Google Maps
                                            </a>
                                        </div>
                                    </div>
                                `;
                            }
                        }
                    }, 2000);

                } catch (error) {
                    console.error('❌ Error al cargar el mapa:', error);
                    if (loadingElement) {
                        loadingElement.innerHTML = '<i class="ri-error-warning-line text-danger"></i> Error al cargar el mapa';
                    }
                }
            }

            if (mapContainer) {
                console.log('Contenedor del mapa encontrado:', mapContainer);
                console.log('Dimensiones del contenedor:', {
                    width: mapContainer.offsetWidth,
                    height: mapContainer.offsetHeight,
                    display: window.getComputedStyle(mapContainer).display,
                    visibility: window.getComputedStyle(mapContainer).visibility
                });

                // Si el contenedor está oculto o tiene dimensiones cero, esperar un poco más
                if (mapContainer.offsetWidth === 0 || mapContainer.offsetHeight === 0) {
                    console.log('Contenedor del mapa tiene dimensiones cero, esperando...');
                    setTimeout(function() {
                        if (lat && lng && !isNaN(lat) && !isNaN(lng)) {
                            initializeMap();
                        }
                    }, 1000);
                } else if (lat && lng && !isNaN(lat) && !isNaN(lng)) {
                    console.log('Inicializando mapa con coordenadas:', lat, lng);

                    // Inicializar el mapa con un pequeño retraso para mejor UX
                    setTimeout(initializeMap, 500); // Pequeño retraso para mejor experiencia de usuario

                } else {
                    console.log('ℹ️ Mapa no inicializado: faltan coordenadas o contenedor');
                    if (loadingElement) {
                        loadingElement.style.display = 'none';
                    }
                }
            }

            // Función para abrir el mapa en pantalla completa (opcional)
            function openMapFullscreen() {
                const mapContainer = document.getElementById('order-map');
                if (mapContainer) {
                    if (mapContainer.requestFullscreen) {
                        mapContainer.requestFullscreen();
                    } else if (mapContainer.webkitRequestFullscreen) {
                        mapContainer.webkitRequestFullscreen();
                    } else if (mapContainer.msRequestFullscreen) {
                        mapContainer.msRequestFullscreen();
                    }
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/front/pedido/detalle.blade.php ENDPATH**/ ?>