<div>
    <?php $__env->startSection('title', 'Mi Perfil'); ?>

    <style>
        :root {
            --velzon-primary: #405189;
            --velzon-success: #0ab39c;
            --velzon-warning: #f7b84b;
            --velzon-danger: #f06548;
            --velzon-info: #299cdb;
        }

        .profile-header {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #3577f1 100%);
            border-radius: 0.5rem;
            position: relative;
            overflow: hidden;
        }

        .profile-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.05'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E");
            opacity: 0.3;
        }

        .avatar-xl {
            width: 120px;
            height: 120px;
        }

        .avatar-upload {
            position: relative;
            cursor: pointer;
        }

        .avatar-upload:hover .avatar-overlay {
            opacity: 1;
        }

        .avatar-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            opacity: 0;
            transition: opacity 0.3s;
        }

        .nav-profile-tabs {
            border: none;
            background: #fff;
            border-radius: 0.5rem;
            padding: 0.5rem;
            box-shadow: 0 0.125rem 0.25rem rgba(0,0,0,0.075);
        }

        .nav-profile-tabs .nav-link {
            border: none;
            color: #6c757d;
            padding: 0.75rem 1.25rem;
            border-radius: 0.375rem;
            font-weight: 500;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.2s;
        }

        .nav-profile-tabs .nav-link:hover {
            background: rgba(var(--bs-primary-rgb), 0.05);
            color: var(--velzon-primary);
        }

        .nav-profile-tabs .nav-link.active {
            background: var(--velzon-primary);
            color: #fff;
        }

        .stat-card {
            background: #fff;
            border-radius: 0.5rem;
            padding: 1.25rem;
            transition: all 0.3s;
            border: 1px solid rgba(0,0,0,0.05);
        }

        .stat-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.1);
        }

        .stat-icon {
            width: 48px;
            height: 48px;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
        }

        .session-card {
            background: #fff;
            border-radius: 0.5rem;
            padding: 1rem;
            border: 1px solid rgba(0,0,0,0.05);
            transition: all 0.2s;
        }

        .session-card:hover {
            border-color: var(--velzon-primary);
        }

        .session-card.active {
            border-left: 3px solid var(--velzon-success);
        }

        .timeline-item {
            position: relative;
            padding-left: 2rem;
            padding-bottom: 1.5rem;
        }

        .timeline-item::before {
            content: '';
            position: absolute;
            left: 0.5rem;
            top: 0;
            bottom: 0;
            width: 2px;
            background: #e9ecef;
        }

        .timeline-item::after {
            content: '';
            position: absolute;
            left: 0;
            top: 0.25rem;
            width: 1rem;
            height: 1rem;
            border-radius: 50%;
            background: var(--velzon-primary);
            border: 3px solid #fff;
            box-shadow: 0 0 0 2px var(--velzon-primary);
        }

        .timeline-item:last-child::before {
            display: none;
        }

        .form-floating-custom {
            position: relative;
        }

        .form-floating-custom label {
            position: absolute;
            top: -0.5rem;
            left: 0.75rem;
            background: #fff;
            padding: 0 0.25rem;
            font-size: 0.75rem;
            color: #6c757d;
        }

        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-fadeInUp {
            animation: fadeInUp 0.5s ease forwards;
        }
    </style>

    <section class="section bg-light py-4">
        <div class="container">
            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="/" class="text-decoration-none">Inicio</a></li>
                    <li class="breadcrumb-item active">Mi Perfil</li>
                </ol>
            </nav>

            <!-- Profile Header -->
            <div class="profile-header p-4 mb-4">
                <div class="row align-items-center">
                    <div class="col-auto">
                        <div class="avatar-upload">
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($avatar): ?>
                                <img src="<?php echo e(asset('storage/' . $avatar)); ?>" 
                                     alt="<?php echo e($name); ?>" 
                                     class="rounded-circle avatar-xl border border-4 border-white shadow">
                            <?php else: ?>
                                <div class="avatar-xl rounded-circle bg-white d-flex align-items-center justify-content-center shadow">
                                    <span class="text-primary" style="font-size: 3rem; font-weight: 600;">
                                        <?php echo e(strtoupper(substr($name, 0, 1))); ?>

                                    </span>
                                </div>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <div class="avatar-overlay rounded-circle">
                                <i class="ri-camera-line text-white fs-4"></i>
                            </div>
                        </div>
                    </div>
                    <div class="col">
                        <h2 class="text-white mb-1"><?php echo e($name); ?></h2>
                        <p class="text-white-50 mb-2">
                            <i class="ri-mail-line me-1"></i><?php echo e($email); ?>

                        </p>
                        <div class="d-flex gap-3 flex-wrap">
                            <span class="badge bg-white bg-opacity-25 text-white px-3 py-2">
                                <i class="ri-shopping-bag-line me-1"></i><?php echo e($totalPedidos); ?> Pedidos
                            </span>
                            <span class="badge bg-white bg-opacity-25 text-white px-3 py-2">
                                <i class="ri-heart-line me-1"></i><?php echo e($productosFavoritos); ?> Favoritos
                            </span>
                            <span class="badge bg-success px-3 py-2">
                                <i class="ri-vip-crown-line me-1"></i>Cliente desde <?php echo e(Auth::user()->created_at->format('M Y')); ?>

                            </span>
                        </div>
                    </div>
                    <div class="col-auto d-none d-md-block">
                        <a href="/front/pedido/historico" class="btn btn-light btn-lg rounded-pill">
                            <i class="ri-file-list-3-line me-2"></i>Ver Pedidos
                        </a>
                    </div>
                </div>
            </div>

            <!-- Statistics Cards -->
            <div class="row g-3 mb-4">
                <div class="col-6 col-lg-3">
                    <div class="stat-card animate-fadeInUp" style="animation-delay: 0.1s">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-primary bg-opacity-10 text-primary me-3">
                                <i class="ri-shopping-bag-3-line"></i>
                            </div>
                            <div>
                                <h3 class="mb-0"><?php echo e($totalPedidos); ?></h3>
                                <p class="text-muted mb-0 small">Total Pedidos</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6 col-lg-3">
                    <div class="stat-card animate-fadeInUp" style="animation-delay: 0.2s">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-success bg-opacity-10 text-success me-3">
                                <i class="ri-money-dollar-circle-line"></i>
                            </div>
                            <div>
                                <h3 class="mb-0"><?php echo e(format_money($totalGastado)); ?></h3>
                                <p class="text-muted mb-0 small">Total Gastado</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6 col-lg-3">
                    <div class="stat-card animate-fadeInUp" style="animation-delay: 0.3s">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-warning bg-opacity-10 text-warning me-3">
                                <i class="ri-time-line"></i>
                            </div>
                            <div>
                                <h3 class="mb-0"><?php echo e($pedidosPendientes); ?></h3>
                                <p class="text-muted mb-0 small">Pendientes</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6 col-lg-3">
                    <div class="stat-card animate-fadeInUp" style="animation-delay: 0.4s">
                        <div class="d-flex align-items-center">
                            <div class="stat-icon bg-info bg-opacity-10 text-info me-3">
                                <i class="ri-checkbox-circle-line"></i>
                            </div>
                            <div>
                                <h3 class="mb-0"><?php echo e($pedidosEntregados); ?></h3>
                                <p class="text-muted mb-0 small">Entregados</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <!-- Sidebar Tabs -->
                <div class="col-lg-3 mb-4">
                    <ul class="nav nav-pills flex-column nav-profile-tabs">
                        <li class="nav-item">
                            <button class="nav-link w-100 text-start <?php echo e($activeTab === 'overview' ? 'active' : ''); ?>" 
                                    wire:click="setTab('overview')">
                                <i class="ri-user-line"></i>
                                <span>Resumen</span>
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link w-100 text-start <?php echo e($activeTab === 'edit' ? 'active' : ''); ?>" 
                                    wire:click="setTab('edit')">
                                <i class="ri-edit-line"></i>
                                <span>Editar Perfil</span>
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link w-100 text-start <?php echo e($activeTab === 'security' ? 'active' : ''); ?>" 
                                    wire:click="setTab('security')">
                                <i class="ri-shield-keyhole-line"></i>
                                <span>Seguridad</span>
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link w-100 text-start <?php echo e($activeTab === 'sessions' ? 'active' : ''); ?>" 
                                    wire:click="setTab('sessions')">
                                <i class="ri-device-line"></i>
                                <span>Sesiones</span>
                            </button>
                        </li>
                        <li class="nav-item">
                            <button class="nav-link w-100 text-start <?php echo e($activeTab === 'notifications' ? 'active' : ''); ?>" 
                                    wire:click="setTab('notifications')">
                                <i class="ri-notification-3-line"></i>
                                <span>Notificaciones</span>
                            </button>
                        </li>
                    </ul>

                    <!-- Quick Links -->
                    <div class="card mt-4 border-0 shadow-sm">
                        <div class="card-body">
                            <h6 class="text-uppercase text-muted fs-11 mb-3">Accesos Rápidos</h6>
                            <div class="d-grid gap-2">
                                <a href="/front/pedido/historico" class="btn btn-primary btn-sm text-start">
                                    <i class="ri-file-list-3-line me-2"></i>Mis Pedidos
                                </a>
                                <a href="/front/wishlist" class="btn btn-danger btn-sm text-start">
                                    <i class="ri-heart-line me-2"></i>Mis Favoritos
                                </a>
                                <a href="/front/cart" class="btn btn-warning btn-sm text-start">
                                    <i class="ri-shopping-cart-line me-2"></i>Mi Carrito
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Main Content -->
                <div class="col-lg-9">
                    <!-- Overview Tab -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'overview'): ?>
                    <div class="animate-fadeInUp">
                        <div class="row">
                            <!-- Personal Info -->
                            <div class="col-md-6 mb-4">
                                <div class="card border-0 shadow-sm h-100">
                                    <div class="card-header bg-transparent border-0">
                                        <h5 class="mb-0">
                                            <i class="ri-user-3-line me-2 text-primary"></i>Información Personal
                                        </h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label class="text-muted small">Nombre completo</label>
                                            <p class="mb-0 fw-medium"><?php echo e($name); ?></p>
                                        </div>
                                        <div class="mb-3">
                                            <label class="text-muted small">Correo electrónico</label>
                                            <p class="mb-0 fw-medium"><?php echo e($email); ?></p>
                                        </div>
                                        <div class="mb-3">
                                            <label class="text-muted small">Teléfono</label>
                                            <p class="mb-0 fw-medium"><?php echo e($telefono ?: 'No especificado'); ?></p>
                                        </div>
                                        <div class="mb-0">
                                            <label class="text-muted small">Dirección</label>
                                            <p class="mb-0 fw-medium"><?php echo e($address ?: 'No especificada'); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Recent Orders -->
                            <div class="col-md-6 mb-4">
                                <div class="card border-0 shadow-sm h-100">
                                    <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center">
                                        <h5 class="mb-0">
                                            <i class="ri ri-shopping-bag-line me-2 text-primary"></i>Últimos Pedidos
                                        </h5>
                                        <a href="/front/pedido/historico" class="btn btn-sm btn-primary">Ver todos</a>
                                    </div>
                                    <div class="card-body p-0">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $ultimosPedidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pedido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="d-flex align-items-center p-3 border-bottom">
                                            <div class="flex-shrink-0 me-3">
                                                <div class="avatar-sm bg-primary rounded">
                                                    <span class="avatar-title text-white">
                                                        <i class="ri ri-file-2-line"></i>
                                                    </span>
                                                </div>
                                            </div>
                                            <div class="flex-grow-1">
                                                <h6 class="mb-0">#<?php echo e($pedido->codigo); ?></h6>
                                                <small class="text-muted"><?php echo e($pedido->created_at->format('d/m/Y')); ?></small>
                                            </div>
                                            <div class="text-end">
                                                <span class="badge bg-<?php echo e($pedido->estado === 'Entregado' ? 'success' : ($pedido->estado === 'Pendiente' ? 'warning' : 'info')); ?>">
                                                    <?php echo e($pedido->estado); ?>

                                                </span>
                                                <p class="mb-0 fw-medium"><?php echo e(format_money($pedido->total_usd)); ?></p>
                                            </div>
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <div class="text-center py-4">
                                            <i class="ri-shopping-bag-line text-muted fs-1"></i>
                                            <p class="text-muted mb-0">No tienes pedidos aún</p>
                                        </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Activity Timeline -->
                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-transparent border-0">
                                <h5 class="mb-0">
                                    <i class="ri-time-line me-2 text-primary"></i>Actividad Reciente
                                </h5>
                            </div>
                            <div class="card-body">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($historialSesiones) > 0): ?>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = array_slice($historialSesiones, 0, 5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="timeline-item">
                                        <div class="d-flex justify-content-between">
                                            <div>
                                                <h6 class="mb-1">
                                                    <i class="<?php echo e($this->getDeviceIcon($session['user_agent'] ?? '')); ?> me-1"></i>
                                                    Inicio de sesión
                                                </h6>
                                                <p class="text-muted small mb-0">
                                                    IP: <?php echo e($session['ip_address'] ?? 'Desconocida'); ?> 
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($session['location'] ?? false): ?>
                                                        • <?php echo e($session['location']); ?>

                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </p>
                                            </div>
                                            <small class="text-muted">
                                                <?php echo e(\Carbon\Carbon::parse($session['login_at'])->diffForHumans()); ?>

                                            </small>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                <?php else: ?>
                                    <p class="text-muted text-center mb-0">No hay actividad reciente</p>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <!-- Edit Profile Tab -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'edit'): ?>
                    <div class="card border-0 shadow-sm animate-fadeInUp">
                        <div class="card-header bg-transparent border-0">
                            <h5 class="mb-0">
                                <i class="ri-edit-line me-2 text-primary"></i>Editar Información
                            </h5>
                        </div>
                        <div class="card-body">
                            <form wire:submit.prevent="updateProfile">
                                <div class="row g-3">
                                    <div class="col-12 text-center mb-3">
                                        <div class="avatar-upload d-inline-block" onclick="document.getElementById('avatarInput').click()">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($newAvatar): ?>
                                                <img src="<?php echo e($newAvatar->temporaryUrl()); ?>" class="rounded-circle avatar-xl border">
                                            <?php elseif($avatar): ?>
                                                <img src="<?php echo e(asset('storage/' . $avatar)); ?>" class="rounded-circle avatar-xl border">
                                            <?php else: ?>
                                                <div class="avatar-xl rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center mx-auto">
                                                    <span class="text-primary" style="font-size: 2.5rem;"><?php echo e(strtoupper(substr($name, 0, 1))); ?></span>
                                                </div>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            <div class="avatar-overlay rounded-circle">
                                                <i class="ri-camera-line text-white fs-4"></i>
                                            </div>
                                        </div>
                                        <input type="file" id="avatarInput" wire:model="newAvatar" class="d-none" accept="image/*">
                                        <p class="text-muted small mt-2 mb-0">Haz clic para cambiar tu foto</p>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Nombre completo</label>
                                        <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               wire:model="name" placeholder="Tu nombre">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Correo electrónico</label>
                                        <input type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               wire:model="email" placeholder="tu@email.com">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Teléfono</label>
                                        <input type="tel" class="form-control <?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               wire:model="telefono" placeholder="+58 412 1234567">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Dirección</label>
                                        <input type="text" class="form-control <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                               wire:model="address" placeholder="Tu dirección">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <div class="col-12">
                                        <label class="form-label">Biografía</label>
                                        <textarea class="form-control <?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                  wire:model="bio" rows="3" placeholder="Cuéntanos sobre ti..."></textarea>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['bio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>

                                    <div class="col-12">
                                        <button type="submit" class="btn btn-primary rounded-pill">
                                            <i class="ri-save-line me-1"></i>Guardar Cambios
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <!-- Security Tab -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'security'): ?>
                    <div class="animate-fadeInUp">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-transparent border-0">
                                <h5 class="mb-0">
                                    <i class="ri-lock-password-line me-2 text-primary"></i>Cambiar Contraseña
                                </h5>
                            </div>
                            <div class="card-body">
                                <form wire:submit.prevent="updatePassword">
                                    <div class="row g-3">
                                        <div class="col-12">
                                            <label class="form-label">Contraseña actual</label>
                                            <input type="password" class="form-control <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   wire:model="current_password" placeholder="••••••••">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">Nueva contraseña</label>
                                            <input type="password" class="form-control <?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                                   wire:model="new_password" placeholder="••••••••">
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['new_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="invalid-feedback"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">Confirmar nueva contraseña</label>
                                            <input type="password" class="form-control" 
                                                   wire:model="new_password_confirmation" placeholder="••••••••">
                                        </div>

                                        <div class="col-12">
                                            <div class="alert alert-info border-0">
                                                <i class="ri-information-line me-2"></i>
                                                La contraseña debe tener al menos 8 caracteres
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <button type="submit" class="btn btn-primary rounded-pill">
                                                <i class="ri-lock-line me-1"></i>Actualizar Contraseña
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>

                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-transparent border-0">
                                <h5 class="mb-0">
                                    <i class="ri-shield-check-line me-2 text-success"></i>Seguridad de la Cuenta
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="d-flex align-items-center justify-content-between py-3 border-bottom">
                                    <div>
                                        <h6 class="mb-1">Verificación en dos pasos</h6>
                                        <p class="text-muted small mb-0">Añade una capa extra de seguridad</p>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" disabled>
                                    </div>
                                </div>
                                <div class="d-flex align-items-center justify-content-between py-3">
                                    <div>
                                        <h6 class="mb-1">Correo verificado</h6>
                                        <p class="text-muted small mb-0"><?php echo e($email); ?></p>
                                    </div>
                                    <span class="badge bg-success">
                                        <i class="ri-check-line me-1"></i>Verificado
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <!-- Sessions Tab -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'sessions'): ?>
                    <div class="animate-fadeInUp">
                        <div class="card border-0 shadow-sm mb-4">
                            <div class="card-header bg-transparent border-0 d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">
                                    <i class="ri-device-line me-2 text-primary"></i>Sesiones Activas
                                </h5>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($sesionesActivas) > 1): ?>
                                <button class="btn btn-sm btn-outline-danger rounded-pill" wire:click="closeAllOtherSessions">
                                    <i class="ri-logout-circle-line me-1"></i>Cerrar otras sesiones
                                </button>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <div class="card-body">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $sesionesActivas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="session-card mb-3 <?php echo e($session['session_id'] === session()->getId() ? 'active' : ''); ?>">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex">
                                            <div class="avatar-sm bg-primary rounded me-3">
                                                <span class="avatar-title text-primary">
                                                    <i class="<?php echo e($this->getDeviceIcon($session['user_agent'] ?? '')); ?> fs-4"></i>
                                                </span>
                                            </div>
                                            <div>
                                                <h6 class="mb-1">
                                                    <?php echo e($session['location'] ?: 'Ubicación desconocida'); ?>

                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($session['session_id'] === session()->getId()): ?>
                                                        <span class="badge bg-success ms-2">Actual</span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </h6>
                                                <p class="text-muted small mb-1">
                                                    <i class="ri-global-line me-1"></i>IP: <?php echo e($session['ip_address']); ?>

                                                </p>
                                                <p class="text-muted small mb-0">
                                                    <i class="ri-time-line me-1"></i>
                                                    Última actividad: <?php echo e(\Carbon\Carbon::parse($session['last_activity'])->diffForHumans()); ?>

                                                </p>
                                            </div>
                                        </div>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($session['session_id'] !== session()->getId()): ?>
                                        <button class="btn btn-sm btn-outline-danger" wire:click="closeSession(<?php echo e($session['id']); ?>)">
                                            <i class="ri-logout-box-line"></i>
                                        </button>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-muted text-center mb-0">No hay sesiones activas</p>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>

                        <div class="card border-0 shadow-sm">
                            <div class="card-header bg-transparent border-0">
                                <h5 class="mb-0">
                                    <i class="ri-history-line me-2 text-primary"></i>Historial de Sesiones
                                </h5>
                            </div>
                            <div class="card-body p-0">
                                <div class="table-responsive">
                                    <table class="table table-hover mb-0">
                                        <thead class="table-light">
                                            <tr>
                                                <th>Dispositivo</th>
                                                <th>IP</th>
                                                <th>Ubicación</th>
                                                <th>Fecha</th>
                                                <th>Estado</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $historialSesiones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $session): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                            <tr>
                                                <td>
                                                    <i class="<?php echo e($this->getDeviceIcon($session['user_agent'] ?? '')); ?> me-2"></i>
                                                    <i class="<?php echo e($this->getBrowserIcon($session['user_agent'] ?? '')); ?>"></i>
                                                </td>
                                                <td><?php echo e($session['ip_address']); ?></td>
                                                <td><?php echo e($session['location'] ?: '-'); ?></td>
                                                <td><?php echo e(\Carbon\Carbon::parse($session['login_at'])->format('d/m/Y H:i')); ?></td>
                                                <td>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($session['is_active']): ?>
                                                        <span class="badge bg-success">Activa</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-secondary">Finalizada</span>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </td>
                                            </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                            <tr>
                                                <td colspan="5" class="text-center text-muted py-4">No hay historial de sesiones</td>
                                            </tr>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <!-- Notifications Tab -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($activeTab === 'notifications'): ?>
                    <div class="card border-0 shadow-sm animate-fadeInUp">
                        <div class="card-header bg-transparent border-0">
                            <h5 class="mb-0">
                                <i class="ri-notification-3-line me-2 text-primary"></i>Preferencias de Notificación
                            </h5>
                        </div>
                        <div class="card-body">
                            <form wire:submit.prevent="updateNotifications">
                                <div class="d-flex align-items-center justify-content-between py-3 border-bottom">
                                    <div>
                                        <h6 class="mb-1">
                                            <i class="ri-mail-line me-2 text-primary"></i>Notificaciones por Email
                                        </h6>
                                        <p class="text-muted small mb-0">Recibe actualizaciones sobre tus pedidos y ofertas</p>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" wire:model="notifications_email">
                                    </div>
                                </div>

                                <div class="d-flex align-items-center justify-content-between py-3 border-bottom">
                                    <div>
                                        <h6 class="mb-1">
                                            <i class="ri-smartphone-line me-2 text-success"></i>Notificaciones por SMS
                                        </h6>
                                        <p class="text-muted small mb-0">Recibe mensajes de texto con el estado de tus pedidos</p>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" wire:model="notifications_sms">
                                    </div>
                                </div>

                                <div class="d-flex align-items-center justify-content-between py-3">
                                    <div>
                                        <h6 class="mb-1">
                                            <i class="ri-notification-4-line me-2 text-warning"></i>Notificaciones Push
                                        </h6>
                                        <p class="text-muted small mb-0">Recibe notificaciones en tiempo real en tu navegador</p>
                                    </div>
                                    <div class="form-check form-switch">
                                        <input class="form-check-input" type="checkbox" wire:model="notifications_push">
                                    </div>
                                </div>

                                <div class="mt-4">
                                    <button type="submit" class="btn btn-primary rounded-pill">
                                        <i class="ri-save-line me-1"></i>Guardar Preferencias
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
            </div>
        </div>
    </section>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/front/user/profile.blade.php ENDPATH**/ ?>