<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Editar Nota de Venta</h1>
            <p class="mb-0 text-muted">Editar nota de venta: <?php echo e($notaVenta->numeroCompleto ?? 'Nueva'); ?></p>
        </div>
        <a href="<?php echo e(route('admin.notas-venta.index')); ?>" class="btn btn-outline-secondary">
            <i class="ri-arrow-left-line me-2"></i>Volver
        </a>
    </div>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('message')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(session()->has('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($notaVenta && $notaVenta->cotizaciones->count() > 0): ?>
        <div class="alert alert-info">
            <i class="ri-file-list-3-line me-2"></i>
            Esta nota de venta proviene de la cotización: 
            <a href="<?php echo e(route('admin.cotizaciones.show', $notaVenta->cotizaciones->first()->id)); ?>" class="alert-link fw-bold">
                <?php echo e($notaVenta->cotizaciones->first()->numeroCompleto); ?>

            </a>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($notaVenta && $notaVenta->venta): ?>
        <div class="alert alert-success">
            <i class="ri-shopping-cart-line me-2"></i>
            Esta nota de venta ha sido convertida a venta: 
            <a href="<?php echo e(route('admin.ventas.show', $notaVenta->venta->id)); ?>" class="alert-link fw-bold">
                Ver Venta
            </a>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <form wire:submit="save">
        <div class="row">
            <!-- Información de la Nota de Venta -->
            <div class="col-lg-8">
                <!-- Datos Básicos -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Información Básica</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Código</label>
                                    <input type="text" wire:model="codigo" class="form-control" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Serie y Correlativo</label>
                                    <input type="text"
                                           class="form-control"
                                           readonly
                                           value="<?php echo e($this->correlativoActual); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label class="form-label">Cliente</label>
                                    <div class="input-group">
                                        <select wire:model="cliente_id" class="form-select">
                                            <option value="">Cliente general</option>
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $clientes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cliente): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($cliente->id); ?>"><?php echo e($cliente->nombres.' '.$cliente->apellidos); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </select>
                                        <button type="button" wire:click="openCreateClientModal" class="btn btn-primary">
                                            <i class="ri-add-line"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

                <!-- Búsqueda de Productos -->
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Agregar Productos</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="form-label">Buscar Producto</label>
                            <div class="input-group">
                                <span class="input-group-text bg-light border-end-0">
                                    <i class="ri-search-line text-muted"></i>
                                </span>
                                <input type="text" wire:model.live.debounce.300ms="search"
                                       class="form-control border-start-0"
                                       placeholder="Buscar por nombre o código...">
                            </div>
                        </div>

                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($searchResults) > 0): ?>
                            <div class="row g-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $searchResults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-6 col-md-4 col-lg-3">
                                        <div class="product-card card h-100 border-0 shadow-sm position-relative"
                                             wire:click="addToCart(<?php echo e($result['id']); ?>)"
                                             style="cursor: pointer; transition: all 0.3s ease;">

                                            <!-- Badge de stock -->
                                            <div class="position-absolute top-0 end-0 m-2 z-index-1">
                                                <span class="badge <?php echo e($result['quantity'] > 10 ? 'bg-success' : ($result['quantity'] > 0 ? 'bg-warning text-dark' : 'bg-danger')); ?> shadow-sm">
                                                    <i class="ri-inventory-2-line me-1"></i><?php echo e($result['quantity']); ?>

                                                </span>
                                            </div>

                                            <!-- Imagen del producto -->
                                            <div class="product-image-container position-relative">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($result['image_path']): ?>
                                                    <img src="<?php echo e(asset('app/'.$result['image_path'])); ?>"
                                                         alt="<?php echo e($result['name']); ?>"
                                                         class="card-img-top"
                                                         style="height: 160px; object-fit: cover;">
                                                <?php else: ?>
                                                    <div class="card-img-top bg-gradient-light d-flex align-items-center justify-content-center"
                                                         style="height: 160px;">
                                                        <i class="ri-image-line" style="font-size: 3rem; color: #6c757d;"></i>
                                                    </div>
                                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                                                <!-- Overlay con precio destacado -->
                                                <div class="position-absolute bottom-0 start-0 end-0 bg-gradient-dark text-white p-2">
                                                    <div class="d-flex justify-content-between align-items-center">
                                                        <span class="fw-bold fs-5"><?php echo e(format_money($result['price'])); ?></span>
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($result['has_variants']): ?>
                                                            <small class="badge bg-info">
                                                                <i class="ri-list-check-2 me-1"></i>Variantes
                                                            </small>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="card-body p-3">
                                                <h6 class="card-title mb-2 fw-bold text-truncate" title="<?php echo e($result['name']); ?>">
                                                    <?php echo e($result['name']); ?>

                                                </h6>
                                                <p class="card-text small text-muted mb-2 text-truncate" style="height: 2.4em; line-height: 1.2em;">
                                                    <?php echo e($result['description'] ?: 'Sin descripción disponible'); ?>

                                                </p>
                                                <div class="d-flex justify-content-between align-items-center mt-auto">
                                                    <small class="text-muted">
                                                        <i class="ri-barcode-line me-1"></i><?php echo e($result['code']); ?>

                                                    </small>
                                                    <button class="btn btn-primary btn-sm">
                                                        <i class="ri-add-line"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        <?php else: ?>
                            <div class="empty-state text-center py-5">
                                <div class="mb-4">
                                    <i class="ri-search-line" style="font-size: 5rem; color: #6c757d; opacity: 0.5;"></i>
                                </div>
                                <h4 class="text-muted mb-3">Buscar productos</h4>
                                <p class="text-muted mb-4">Escriba el nombre, código o escanee el código de barras para encontrar productos</p>
                                <div class="d-flex justify-content-center gap-3">
                                    <span class="badge bg-light text-dark px-3 py-2">
                                        <i class="ri-keyboard-line me-1"></i>Escribir nombre
                                    </span>
                                    <span class="badge bg-light text-dark px-3 py-2">
                                        <i class="ri-barcode-line me-1"></i>Escanear código
                                    </span>
                                    <span class="badge bg-light text-dark px-3 py-2">
                                        <i class="ri-hashtag me-1"></i>Código manual
                                    </span>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>

                <!-- Carrito -->
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Productos Seleccionados</h5>
                    </div>
                    <div class="card-body p-0">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(empty($cart)): ?>
                            <div class="text-center py-5">
                                <i class="ri-shopping-cart-line text-muted" style="font-size: 3rem;"></i>
                                <p class="text-muted mt-2">No hay productos en el carrito</p>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small ps-4">Producto</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-center">Cantidad</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Precio</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Subtotal</th>
                                            <th class="border-0 fw-semibold text-uppercase text-muted small text-center pe-4">Acción</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $cart; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="ps-4">
                                                    <div class="d-flex align-items-center">
                                                        <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                            <i class="ri-product-hunt-line text-primary"></i>
                                                        </div>
                                                        <div>
                                                            <div class="fw-semibold"><?php echo e($item['nombre']); ?></div>
                                                            <small class="text-muted"><?php echo e($item['codigo']); ?></small>
                                                        </div>
                                                    </div>
                                                </td>
                                                <td class="text-center">
                                                    <input type="number"
                                                           wire:change="updateQuantity(<?php echo e($index); ?>, $event.target.value)"
                                                           value="<?php echo e($item['cantidad']); ?>"
                                                           min="1"
                                                           class="form-control form-control-sm text-center"
                                                           style="width: 80px;">
                                                </td>
                                                <td class="text-end">
                                                    <span class="fw-semibold"><?php echo e(format_money($item['precio_unitario'])); ?></span>
                                                </td>
                                                <td class="text-end">
                                                    <span class="fw-bold"><?php echo e(format_money($item['subtotal'])); ?></span>
                                                </td>
                                                <td class="text-center pe-4">
                                                    <button type="button"
                                                            wire:click="removeFromCart(<?php echo e($index); ?>)"
                                                            class="btn btn-outline-danger btn-sm">
                                                        <i class="ri-delete-bin-line"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </tbody>
                                    <tfoot class="table-light">
                                        <tr>
                                            <td colspan="3" class="text-end fw-bold ps-4">Total:</td>
                                            <td class="text-end fw-bold fs-5 text-success"><?php echo e(format_money($this->getTotal())); ?></td>
                                            <td class="pe-4"></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Resumen y Acciones -->
            <div class="col-lg-4">
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Resumen</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-3">
                            <span>Productos:</span>
                            <span class="fw-semibold"><?php echo e(count($cart)); ?></span>
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <span>Subtotal:</span>
                            <span class="fw-semibold"><?php echo e(format_money($this->getTotal())); ?></span>
                        </div>
                        <hr>
                        <div class="d-flex justify-content-between">
                            <span class="fw-bold">Total:</span>
                            <span class="fw-bold fs-4 text-success"><?php echo e(format_money($this->getTotal())); ?></span>
                        </div>
                    </div>
                </div>

                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Observaciones</h5>
                    </div>
                    <div class="card-body">
                        <textarea wire:model="observaciones"
                                  class="form-control"
                                  rows="3"
                                  placeholder="Observaciones adicionales..."></textarea>
                    </div>
                    <div class="card-footer bg-white border-0">
                        <button type="submit"
                                class="btn btn-success w-100"
                                <?php echo e(empty($cart) ? 'disabled' : ''); ?>>
                            <i class="ri-save-line me-2"></i>Crear Nota de Venta
                        </button>
                    </div>
                </div>

                <!-- Componente de conversión a venta -->
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($notaVenta && $notaVenta->estado === 'aprobada'): ?>
                    <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('admin.notas-venta.convert-to-venta', ['notaVentaId' => $notaVenta->id]);

$key = null;

$key ??= \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::generateKey('lw-4153756097-0', null);

$__html = app('livewire')->mount($__name, $__params, $key);

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        </div>
    </form>

    <!-- Modal de crear cliente -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCreateClientModal): ?>
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.7); z-index: 9999; position: fixed; top: 0; left: 0; width: 100%; height: 100%;" wire:click.self="closeCreateClientModal">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0 shadow-lg">
                    <div class="modal-header bg-gradient-primary text-white border-0">
                        <h5 class="modal-title fw-bold">
                            <i class="ri-user-add-line me-2"></i>
                            Crear Nuevo Cliente
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeCreateClientModal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <form wire:submit.prevent="createClient">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Nombres <span class="text-danger">*</span></label>
                                        <input type="text" wire:model="newClient.nombres" class="form-control" placeholder="Ingrese los nombres">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['newClient.nombres'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Apellidos <span class="text-danger">*</span></label>
                                        <input type="text" wire:model="newClient.apellidos" class="form-control" placeholder="Ingrese los apellidos">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['newClient.apellidos'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Email</label>
                                        <input type="email" wire:model="newClient.email" class="form-control" placeholder="ejemplo@correo.com">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['newClient.email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Teléfono <span class="text-danger">*</span></label>
                                        <input type="text" wire:model="newClient.telefono" class="form-control" placeholder="Ingrese el teléfono">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['newClient.telefono'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Documento de Identidad</label>
                                        <input type="text" wire:model="newClient.documento_identidad" class="form-control" placeholder="Ingrese el documento de identidad">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['newClient.documento_identidad'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Dirección</label>
                                        <input type="text" wire:model="newClient.direccion" class="form-control" placeholder="Ingrese la dirección">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['newClient.direccion'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger small"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="text-end mt-4">
                                <button type="button" wire:click="closeCreateClientModal" class="btn btn-secondary me-2">
                                    <i class="ri-close-line me-1"></i>Cancelar
                                </button>
                                <button type="submit" class="btn btn-primary">
                                    <i class="ri-save-line me-1"></i>Guardar Cliente
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Modal de variantes -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showVariantsModal && $selectedProductForVariants): ?>
        <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.7); z-index: 9999; position: fixed; top: 0; left: 0; width: 100%; height: 100%;" wire:click.self="closeVariantsModal">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content border-0 shadow-lg">
                    <div class="modal-header bg-gradient-primary text-white border-0">
                        <h5 class="modal-title fw-bold">
                            <i class="ri-shopping-bag-3-line me-2"></i>
                            Seleccionar Producto
                        </h5>
                        <button type="button" class="btn-close btn-close-white" wire:click="closeVariantsModal"></button>
                    </div>
                    <div class="modal-body p-4">
                        <!-- Información del producto -->
                        <div class="product-info mb-4">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="product-image-container rounded-3 overflow-hidden shadow-sm">
                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($selectedProductForVariants->featuredImage): ?>
                                            <img src="<?php echo e(asset('app/'.$selectedProductForVariants->featuredImage->path)); ?>"
                                                 alt="<?php echo e($selectedProductForVariants->name); ?>"
                                                 class="img-fluid">
                                        <?php else: ?>
                                            <div class="bg-gradient-light d-flex align-items-center justify-content-center"
                                                 style="height: 200px;">
                                                <i class="ri-image-line" style="font-size: 4rem; color: #6c757d;"></i>
                                            </div>
                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <h4 class="fw-bold mb-2"><?php echo e($selectedProductForVariants->name); ?></h4>
                                    <p class="text-muted mb-3"><?php echo e($selectedProductForVariants->description ?: 'Sin descripción disponible'); ?></p>
                                    <div class="d-flex align-items-center mb-3">
                                        <span class="fw-bold fs-4 text-success me-3"><?php echo e(format_money($selectedProductForVariants->precio)); ?></span>
                                        <span class="badge <?php echo e($selectedProductForVariants->quantity > 10 ? 'bg-success' : ($selectedProductForVariants->quantity > 0 ? 'bg-warning text-dark' : 'bg-danger')); ?>">
                                            <i class="ri-inventory-2-line me-1"></i>Stock: <?php echo e($selectedProductForVariants->quantity); ?>

                                        </span>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Cantidad</label>
                                        <input type="number" wire:model="variantQuantity" class="form-control" min="1" value="1">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Variantes del producto -->
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($selectedProductForVariants->variants && $selectedProductForVariants->variants->count() > 0): ?>
                            <div class="variants-section">
                                <h5 class="fw-bold mb-3">Opciones Disponibles</h5>
                                <div class="row g-3">
                                    <div class="col-md-6">
                                        <div class="variant-option card h-100 border-2 <?php echo e($selectedVariant === 'main' ? 'border-primary bg-light' : ''); ?>"
                                             wire:click="selectVariant('main')"
                                             style="cursor: pointer;">
                                            <div class="card-body">
                                                <div class="d-flex align-items-center justify-content-between">
                                                    <div>
                                                        <h6 class="fw-bold mb-1">Producto Principal</h6>
                                                        <small class="text-muted">Opción estándar</small>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" wire:model="selectedVariant" value="main" class="form-check-input">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $selectedProductForVariants->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variante): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6">
                                            <div class="variant-option card h-100 border-2 <?php echo e($selectedVariant === $variante->id ? 'border-primary bg-light' : ''); ?>"
                                                 wire:click="selectVariant(<?php echo e($variante->id); ?>)"
                                                 style="cursor: pointer;">
                                                <div class="card-body">
                                                    <div class="d-flex align-items-center justify-content-between">
                                                        <div>
                                                            <h6 class="fw-bold mb-1"><?php echo e($variante->name); ?></h6>
                                                            <small class="text-muted"><?php echo e($variante->formatted_values); ?></small>
                                                            <div class="mt-2">
                                                                <span class="fw-bold text-primary"><?php echo e(format_money($selectedProductForVariants->precio + $variante->price_adjustment)); ?></span>
                                                                <span class="badge bg-light text-dark ms-2">
                                                                    <i class="ri-inventory-2-line me-1"></i><?php echo e($variante->quantity); ?>

                                                                </span>
                                                            </div>
                                                        </div>
                                                        <div class="form-check">
                                                            <input type="radio" wire:model="selectedVariant" value="<?php echo e($variante->id); ?>" class="form-check-input">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                    <div class="modal-footer bg-white border-0">
                        <button type="button" wire:click="closeVariantsModal" class="btn btn-secondary">
                            <i class="ri-close-line me-1"></i>Cancelar
                        </button>
                        <button type="button" wire:click="addVariantToCart" class="btn btn-primary">
                            <i class="ri-add-line me-1"></i>Agregar al Carrito
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    document.addEventListener('livewire:init', () => {
        Livewire.on('clienteCreado', (clienteId) => {
            // Forzar actualización del select
            setTimeout(() => {
                const select = document.querySelector('select[wire\\:model="cliente_id"]');
                if (select) {
                    select.value = clienteId;
                    select.dispatchEvent(new Event('change'));
                }
            }, 100);
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/notas-venta/edit.blade.php ENDPATH**/ ?>