<div>
    <a class="nav-link dropdown-toggle hide-arrow btn btn-icon btn-text-secondary rounded-pill"
       href="javascript:void(0);"
       data-bs-toggle="dropdown"
       data-bs-auto-close="outside"
       aria-expanded="false"
       aria-label="<?php echo e(__('messages.notifications')); ?><?php echo e($unreadCount > 0 ? ', ' . $unreadCount . ' ' . __('messages.unread') : ''); ?>">
        <i class=" ri-notification-3-line icon-base icon-22px"></i>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($unreadCount > 0): ?>
            <span class="position-absolute top-0 start-50 translate-middle-y badge badge-dot bg-danger mt-2 border"></span>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </a>
    <ul class="dropdown-menu dropdown-menu-end py-0" role="menu" aria-label="<?php echo e(__('messages.notifications')); ?>">
        <li class="dropdown-menu-header border-bottom py-3">
            <div class="dropdown-header d-flex align-items-center py-2">
                <h6 class="mb-0 me-auto"><?php echo e(__('messages.notifications')); ?></h6>
                <div class="d-flex align-items-center h6 mb-0">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($unreadCount > 0): ?>
                        <span class="badge rounded-pill bg-label-primary fs-xsmall me-2" aria-live="polite">
                            <?php echo e($unreadCount); ?> Nuevas
                        </span>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <a href="javascript:void(0)"
                       wire:click="markAllAsRead"
                       class="dropdown-notifications-all p-2"
                       data-bs-toggle="tooltip"
                       data-bs-placement="top"
                       title="<?php echo e(__('messages.mark_all_read')); ?>"
                       aria-label="<?php echo e(__('messages.mark_all_read')); ?>">
                        <i class=" ri-mail-opened-line icon-base text-heading"></i>
                    </a>
                </div>

<?php $__env->startPush('styles'); ?>
<style>
    .dropdown-notifications-item.marked-as-read {
        opacity: 0.7;
    }

    .dropdown-notifications-item.marked-as-read .text-body {
        color: #6c757d !important;
    }

    .dropdown-notifications-item.marked-as-read .text-body-secondary {
        color: #adb5bd !important;
    }
</style>
<?php $__env->stopPush(); ?>
            </div>
        </li>
        <li class="dropdown-notifications-list scrollable-container">
            <ul class="list-group list-group-flush">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <li class="list-group-item list-group-item-action dropdown-notifications-item <?php echo e($notification->isRead() ? 'marked-as-read' : ''); ?>"
                        id="notification-<?php echo e($notification->id); ?>"
                        onclick="markNotificationAsRead(<?php echo e($notification->id); ?>)"
                        role="button"
                        tabindex="0"
                        aria-label="<?php echo e($notification->title); ?>: <?php echo e($notification->message); ?>. <?php echo e($notification->created_at->diffForHumans()); ?>">
                        <div class="d-flex">
                            <div class="flex-shrink-0 me-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($notification->icon_type === 'image' && $notification->avatar): ?>
                                    <div class="avatar">
                                        <img src="<?php echo e($notification->avatar); ?>" alt="avatar" class="w-px-40 h-auto rounded-circle">
                                    </div>
                                <?php elseif($notification->icon_type === 'initials'): ?>
                                    <div class="avatar">
                                        <span class="avatar-initial rounded-circle bg-label-<?php echo e($notification->type); ?>">
                                            <?php echo e($notification->avatar); ?>

                                        </span>
                                    </div>
                                <?php elseif($notification->icon_type === 'initials-icon' && $notification->icon): ?>
                                    <div class="avatar">
                                        <span class="avatar-initial rounded-circle bg-label-<?php echo e($notification->type); ?>">
                                            <i class="icon-base ri <?php echo e($notification->icon); ?> icon-18px" aria-hidden="true"></iconify-icon>
                                        </span>
                                    </div>
                                <?php else: ?>
                                    <div class="avatar">
                                        <span class="avatar-initial rounded-circle bg-label-<?php echo e($notification->type); ?>">
                                            <i class="icon-base ri <?php echo e($notification->icon); ?> icon-18px" aria-hidden="true"></iconify-icon>
                                        </span>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="small mb-1"><?php echo e($notification->title); ?></h6>
                                <small class="mb-1 d-block text-body"><?php echo e($notification->message); ?></small>
                                <small class="text-body-secondary"><?php echo e($notification->created_at->diffForHumans()); ?></small>
                            </div>
                            <div class="flex-shrink-0 dropdown-notifications-actions">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($notification->isUnread()): ?>
                                    <span id="unread-indicator-<?php echo e($notification->id); ?>" class="badge badge-dot bg-danger"
                                          aria-label="Unread notification"></span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                        </div>
                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <li class="list-group-item text-center py-4">
                        <i class=" ri-notification-off-line icon-base icon-48px text-body mb-2"></i>
                        <p class="text-body mb-0">No hay notificaciones pendientes</p>
                    </li>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </ul>
        </li>
        <li class="border-top">
            <div class="d-grid p-4">
                <a class="btn btn-primary btn-sm d-flex" href="<?php echo e(route('admin.notifications.index')); ?>" aria-label="Ver todas las notificaciones">
                    <small class="align-middle">Ver todas las notificaciones</small>
                </a>
            </div>
        </li>
    </ul>
</div>

<script>
function markNotificationAsRead(notificationId) {
    const notification = document.getElementById('notification-' + notificationId);
    const badge = document.querySelector('.badge.badge-dot.bg-danger');
    const countBadge = document.querySelector('.badge.rounded-pill.bg-label-primary');

    // Remove notification from list with animation
    if (notification) {
        notification.style.transition = 'opacity 0.3s ease';
        notification.style.opacity = '0';

        setTimeout(() => {
            notification.remove();

            // Check if there are any notifications left
            const remainingNotifications = document.querySelectorAll('.dropdown-notifications-item:not([style*="opacity: 0"])');

            if (remainingNotifications.length === 0) {
                // Show empty state
                const notificationsList = document.querySelector('.dropdown-notifications-list .list-group');
                if (notificationsList) {
                    notificationsList.innerHTML = `
                        <li class="list-group-item text-center py-4">
                            <i class=" ri-notification-off-line  ri-48px-line text-body mb-2"></i>
                            <p class="text-body mb-0">No hay notificaciones pendientes</p>
                        </li>
                    `;
                }

                // Remove badges
                if (badge) badge.remove();
                if (countBadge) countBadge.remove();
            } else {
                // Update count
                const newCount = remainingNotifications.length;
                if (countBadge) {
                    countBadge.textContent = newCount + ' Nuevas';
                }
            }
        }, 300);
    }

    // Call Livewire method
    window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('markAsRead', notificationId);
}
</script>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/notification-bell.blade.php ENDPATH**/ ?>