<div>
    <!-- Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="h3 mb-0 text-gray-800">Detalle de Venta</h1>
            <p class="mb-0 text-muted"><?php echo e($venta->codigo); ?> - <?php echo e($venta->created_at->format('d/m/Y H:i')); ?></p>
        </div>
        <div class="d-flex gap-2">
            <a href="<?php echo e(route('admin.ventas.index')); ?>" class="btn btn-outline-secondary">
                <i class="ri-arrow-left-line me-2"></i>Volver
            </a>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($venta->estado !== 'anulada'): ?>
                <a href="<?php echo e(route('admin.ventas.edit', $venta->id)); ?>" class="btn btn-warning">
                    <i class="ri-edit-line me-2"></i>Editar
                </a>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

    <div class="row">
        <!-- Información de la Venta -->
        <div class="col-lg-8">
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Información de la Venta</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Código</label>
                                <p class="fw-semibold"><?php echo e($venta->codigo); ?></p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Cliente</label>
                                <p class="fw-semibold"><?php echo e($venta->cliente->name ?? 'Cliente general'); ?></p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Método de Pago</label>
                                <div class="d-flex align-items-center">
                                    <?php
                                        $iconClass = match($venta->metodo_pago) {
                                            'efectivo' => 'ri-money-dollar-circle-line text-success',
                                            'transferencia' => 'ri-bank-line text-info',
                                            'pago_movil' => 'ri-smartphone-line text-primary',
                                            'tarjeta' => 'ri-bank-card-line text-warning',
                                            'punto_de_venta' => 'ri-calculator-line text-secondary',
                                            default => 'ri-question-line text-muted'
                                        };
                                    ?>
                                    <i class="<?php echo e($iconClass); ?> me-2"></i>
                                    <span class="fw-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $venta->metodo_pago))); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label text-muted">Fecha</label>
                                <p class="fw-semibold"><?php echo e($venta->created_at->format('d/m/Y H:i:s')); ?></p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Usuario</label>
                                <p class="fw-semibold"><?php echo e($venta->usuario->name); ?></p>
                            </div>
                            <div class="mb-3">
                                <label class="form-label text-muted">Estado</label>
                                <div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php switch($venta->estado):
                                        case ('pagado'): ?>
                                            <span class="badge bg-success bg-opacity-10 text-success border border-success border-opacity-25 px-3 py-2">
                                                <i class="ri-check-line me-1"></i>Pagado
                                            </span>
                                            <?php break; ?>
                                        <?php case ('pendiente'): ?>
                                            <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 px-3 py-2">
                                                <i class="ri-time-line me-1"></i>Pendiente
                                            </span>
                                            <?php break; ?>
                                        <?php case ('anulada'): ?>
                                            <span class="badge bg-danger bg-opacity-10 text-danger border border-danger border-opacity-25 px-3 py-2">
                                                <i class="ri-close-line me-1"></i>Anulada
                                            </span>
                                            <?php break; ?>
                                    <?php endswitch; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detalles de Productos -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Productos</h5>
                </div>
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th class="border-0 fw-semibold text-uppercase text-muted small ps-4">Producto</th>
                                    <th class="border-0 fw-semibold text-uppercase text-muted small text-center">Cantidad</th>
                                    <th class="border-0 fw-semibold text-uppercase text-muted small text-end">Precio Unit.</th>
                                    <th class="border-0 fw-semibold text-uppercase text-muted small text-end pe-4">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $venta->detalles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td class="ps-4">
                                            <div class="d-flex align-items-center">
                                                <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                    <i class="ri-product-hunt-line text-primary"></i>
                                                </div>
                                                <div>
                                                    <div class="fw-semibold"><?php echo e($detalle->nombre_producto); ?></div>
                                                    <small class="text-muted"><?php echo e($detalle->codigo_producto); ?></small>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($detalle->variante): ?>
                                                        <div class="small text-info">
                                                            <i class="ri-palette-line me-1"></i><?php echo e($detalle->variante->name); ?>

                                                        </div>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-light text-dark border"><?php echo e($detalle->cantidad); ?></span>
                                        </td>
                                        <td class="text-end">
                                            <span class="fw-semibold"><?php echo e(format_money($detalle->precio_unitario)); ?></span>
                                        </td>
                                        <td class="text-end pe-4">
                                            <span class="fw-bold text-dark"><?php echo e(format_money($detalle->subtotal)); ?></span>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                            <tfoot class="table-light">
                                <tr>
                                    <td colspan="3" class="text-end fw-bold ps-4">Total:</td>
                                    <td class="text-end pe-4">
                                        <span class="fw-bold fs-5 text-success"><?php echo e(format_money($venta->total)); ?></span>
                                    </td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Información Adicional -->
        <div class="col-lg-4">
            <!-- Resumen -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0">
                    <h5 class="card-title mb-0">Resumen</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between mb-2">
                        <span>Subtotal:</span>
                        <span class="fw-semibold"><?php echo e(format_money($venta->total - $venta->impuesto)); ?></span>
                    </div>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($venta->descuento > 0): ?>
                        <div class="d-flex justify-content-between mb-2 text-success">
                            <span>Descuento:</span>
                            <span class="fw-semibold">-<?php echo e(format_money($venta->descuento)); ?></span>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($venta->impuesto > 0): ?>
                        <div class="d-flex justify-content-between mb-2">
                            <span>Impuesto:</span>
                            <span class="fw-semibold"><?php echo e(format_money($venta->impuesto)); ?></span>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    <hr>
                    <div class="d-flex justify-content-between">
                        <span class="fw-bold">Total:</span>
                        <span class="fw-bold fs-5 text-success"><?php echo e(format_money($venta->total)); ?></span>
                    </div>
                </div>
            </div>

            <!-- Información de Pago -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($venta->pagos->count() > 0): ?>
                <div class="card border-0 shadow-sm mb-4">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Información de Pago</h5>
                    </div>
                    <div class="card-body">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $venta->pagos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <div>
                                    <div class="fw-semibold"><?php echo e(ucfirst(str_replace('_', ' ', $pago->metodo_pago))); ?></div>
                                    <small class="text-muted"><?php echo e($pago->created_at->format('d/m/Y H:i')); ?></small>
                                </div>
                                <div class="text-end">
                                    <div class="fw-bold"><?php echo e(format_money($pago->monto)); ?></div>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pago->cambio > 0): ?>
                                        <small class="text-muted">Cambio: <?php echo e(format_money($pago->cambio)); ?></small>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <!-- Información de Caja -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($venta->caja): ?>
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-0">
                        <h5 class="card-title mb-0">Información de Caja</h5>
                    </div>
                    <div class="card-body">
                        <div class="mb-2">
                            <span class="text-muted">Caja:</span>
                            <span class="fw-semibold ms-2">#<?php echo e($venta->caja->numero_corte); ?></span>
                        </div>
                        <div class="mb-2">
                            <span class="text-muted">Fecha:</span>
                            <span class="fw-semibold ms-2"><?php echo e($venta->caja->fecha->format('d/m/Y')); ?></span>
                        </div>
                        <div>
                            <span class="text-muted">Estado:</span>
                            <span class="badge bg-<?php echo e($venta->caja->estado === 'abierta' ? 'success' : 'secondary'); ?> ms-2">
                                <?php echo e(ucfirst($venta->caja->estado)); ?>

                            </span>
                        </div>
                    </div>
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>
</div><?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/ventas/detalle.blade.php ENDPATH**/ ?>