<div class="dropdown mini-wishlist-dropdown" wire:ignore.self>
    <button class="btn btn-icon btn-primary" 
            type="button" 
            data-bs-toggle="dropdown"
            aria-label="Lista de deseos">
        <i class="ri-heart-3-line fs-5"></i>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($wishlistCount > 0): ?>
            <span class="position-absolute topbar-badge wishlist-badge fs-10 translate-middle badge rounded-pill bg-danger animate__animated animate__heartBeat animate__infinite animate__slower">
                <?php echo e($wishlistCount > 99 ? '99+' : $wishlistCount); ?>

            </span>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </button>

    <div class="dropdown-menu dropdown-menu-end dropdown-menu-lg p-0 dropdown-menu-wishlist">
        <!-- Header con gradiente rosa/rojo -->
        <div class="dropdown-head wishlist-header rounded-top">
            <div class="p-3">
                <div class="d-flex align-items-center">
                    <div class="flex-shrink-0 me-3">
                        <div class="avatar-sm bg-white bg-opacity-25 rounded-circle d-flex align-items-center justify-content-center">
                            <i class="ri-heart-3-fill text-white fs-5 heart-pulse"></i>
                        </div>
                    </div>
                    <div class="flex-grow-1">
                        <h6 class="mb-0 text-white fw-semibold">Mis Favoritos</h6>
                        <p class="mb-0 text-white text-opacity-75 fs-12">
                            <?php echo e($wishlistCount); ?> <?php echo e($wishlistCount == 1 ? 'producto' : 'productos'); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($wishlistItems->count() > 0): ?>
            <div class="mini-wishlist-items" data-simplebar>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $wishlistItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="wishlist-item-wrapper" wire:key="wishlist-item-<?php echo e($item->id); ?>">
                        <div class="d-flex align-items-center p-3 wishlist-item">
                            <div class="flex-shrink-0 me-3">
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->producto && $item->producto->images && $item->producto->images->first()): ?>
                                    <div class="avatar-md rounded bg-light overflow-hidden">
                                        <img src="<?php echo e(asset('app/'.$item->producto->images->first()->path)); ?>"
                                             alt="<?php echo e($item->producto->name); ?>"
                                             class="img-fluid h-100 w-100"
                                             style="object-fit: cover;"
                                             loading="lazy">
                                    </div>
                                <?php else: ?>
                                    <div class="avatar-md rounded bg-light d-flex align-items-center justify-content-center">
                                        <i class="ri-image-line text-muted fs-4"></i>
                                    </div>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </div>
                            
                            <div class="flex-grow-1 overflow-hidden">
                                <h6 class="mb-1 text-truncate fw-medium"><?php echo e($item->producto->name); ?></h6>
                                <div class="d-flex align-items-center gap-2">
                                    <span class="fw-semibold text-danger"><?php echo e(format_money($item->producto->price)); ?></span>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($item->producto->old_price && $item->producto->old_price > $item->producto->price): ?>
                                        <small class="text-muted text-decoration-line-through">
                                            <?php echo e(format_money($item->producto->old_price)); ?>

                                        </small>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="flex-shrink-0 ms-2 d-flex flex-column gap-1">
                                <a href="/front/producto/<?php echo e($item->producto->slug ?? $item->producto->id); ?>" 
                                   class="btn btn-icon btn-sm btn-soft-primary rounded-circle wishlist-action-btn"
                                   title="Ver producto">
                                    <i class="ri-eye-line"></i>
                                </a>
                                <button wire:click="removeItem(<?php echo e($item->id); ?>)"
                                        wire:loading.attr="disabled"
                                        wire:target="removeItem(<?php echo e($item->id); ?>)"
                                        class="btn btn-icon btn-sm btn-ghost-danger rounded-circle wishlist-action-btn"
                                        title="Eliminar de favoritos">
                                    <span wire:loading.remove wire:target="removeItem(<?php echo e($item->id); ?>)">
                                        <i class="ri-close-line"></i>
                                    </span>
                                    <span wire:loading wire:target="removeItem(<?php echo e($item->id); ?>)">
                                        <span class="spinner-border spinner-border-sm"></span>
                                    </span>
                                </button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>

            <!-- Footer -->
            <div class="dropdown-footer border-top bg-light bg-opacity-50">
                <div class="p-3">
                    <a href="/front/wishlist" class="btn btn-danger btn-sm w-100 d-flex align-items-center justify-content-center gap-2">
                        <i class="ri-heart-3-line"></i>
                        <span>Ver Todos los Favoritos</span>
                        <span class="badge bg-white text-danger ms-1"><?php echo e($wishlistCount); ?></span>
                    </a>
                </div>
            </div>
        <?php else: ?>
            <!-- Empty State -->
            <div class="p-4 text-center empty-wishlist-state">
                <div class="avatar-lg mx-auto mb-3">
                    <div class="avatar-title bg-danger-subtle text-danger rounded-circle empty-wishlist-icon">
                        <i class="ri-heart-3-line fs-2"></i>
                    </div>
                </div>
                <h6 class="mb-2 text-dark">Sin favoritos aún</h6>
                <p class="text-muted fs-13 mb-3">Guarda productos que te gusten</p>
                <a href="/" class="btn btn-danger btn-sm px-4">
                    <i class="ri-store-2-line me-1"></i>Explorar Tienda
                </a>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
    
    <style>
    .mini-wishlist-dropdown .dropdown-menu-wishlist {
        min-width: 340px;
        max-width: 340px;
        border: none;
        box-shadow: 0 5px 25px rgba(0,0,0,0.15);
        border-radius: 0.5rem;
        animation: fadeInUp 0.2s ease-out;
    }
    
    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translateY(10px);
        }
        to {
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .wishlist-header {
        background: linear-gradient(135deg, #f06548 0%, #dc3545 50%, #c92a3e 100%);
    }
    
    .wishlist-btn:hover i {
        color: #f06548;
    }
    
    .heart-pulse {
        animation: heartPulse 1.5s infinite;
    }
    
    @keyframes heartPulse {
        0%, 100% {
            transform: scale(1);
        }
        25% {
            transform: scale(1.1);
        }
        50% {
            transform: scale(1);
        }
        75% {
            transform: scale(1.1);
        }
    }
    
    .mini-wishlist-items {
        max-height: 280px;
        overflow-y: auto;
    }
    
    .wishlist-item {
        transition: all 0.2s ease;
        border-bottom: 1px solid rgba(0,0,0,0.05);
    }
    
    .wishlist-item:hover {
        background-color: rgba(240, 101, 72, 0.04);
    }
    
    .wishlist-item-wrapper:last-child .wishlist-item {
        border-bottom: none;
    }
    
    .wishlist-action-btn {
        opacity: 0.6;
        transition: all 0.2s ease;
    }
    
    .wishlist-item:hover .wishlist-action-btn {
        opacity: 1;
    }
    
    .wishlist-action-btn:hover {
        transform: scale(1.1);
    }
    
    .avatar-md {
        width: 50px;
        height: 50px;
    }
    
    .avatar-sm {
        width: 36px;
        height: 36px;
    }
    
    .avatar-lg {
        width: 64px;
        height: 64px;
    }
    
    .avatar-title {
        display: flex;
        align-items: center;
        justify-content: center;
        width: 100%;
        height: 100%;
    }
    
    .topbar-badge {
        top: 2px !important;
        right: -2px !important;
        left: auto !important;
        padding: 0.25em 0.5em;
    }
    
    .wishlist-badge {
        background: linear-gradient(135deg, #f06548 0%, #dc3545 100%) !important;
    }
    
    .fs-10 {
        font-size: 10px !important;
    }
    
    .fs-12 {
        font-size: 12px !important;
    }
    
    .fs-13 {
        font-size: 13px !important;
    }
    
    .btn-icon {
        width: 38px;
        height: 38px;
        padding: 0;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }
    
    .btn-icon.btn-sm {
        width: 28px;
        height: 28px;
    }
    
    .btn-ghost-secondary {
        color: #495057;
        background-color: transparent;
    }
    
    .btn-ghost-secondary:hover {
        color: #495057;
        background-color: rgba(73, 80, 87, 0.1);
    }
    
    .btn-ghost-danger {
        color: #f06548;
        background-color: transparent;
    }
    
    .btn-ghost-danger:hover {
        color: #fff;
        background-color: #f06548;
    }
    
    .btn-soft-primary {
        color: var(--bs-primary);
        background-color: rgba(var(--vz-primary-rgb), 0.1);
        border-color: transparent;
    }
    
    .btn-soft-primary:hover {
        color: #fff;
        background-color: var(--bs-primary);
    }
    
    .bg-danger-subtle {
        background-color: rgba(240, 101, 72, 0.15) !important;
    }
    
    .empty-wishlist-icon {
        animation: float 3s ease-in-out infinite;
    }
    
    @keyframes float {
        0%, 100% {
            transform: translateY(0);
        }
        50% {
            transform: translateY(-5px);
        }
    }
    
    .mini-wishlist-items::-webkit-scrollbar {
        width: 5px;
    }
    
    .mini-wishlist-items::-webkit-scrollbar-track {
        background: transparent;
    }
    
    .mini-wishlist-items::-webkit-scrollbar-thumb {
        background: rgba(240, 101, 72, 0.2);
        border-radius: 10px;
    }
    
    .mini-wishlist-items::-webkit-scrollbar-thumb:hover {
        background: rgba(240, 101, 72, 0.4);
    }
    </style>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/front/mini-wishlist.blade.php ENDPATH**/ ?>