<div>
    <?php $__env->startSection('title', 'Mis Pedidos'); ?>

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$empleado): ?>
        <div class="alert alert-warning">
            <i class="ri-alert-line me-2"></i>
            No se encontró tu perfil de empleado. Contacta al administrador.
        </div>
    <?php else: ?>
        <!-- Estadísticas Rápidas -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <div class="row align-items-center">
                            <div class="col-md-8">
                                <h4 class="text-white mb-1">Mis Pedidos</h4>
                                <p class="mb-0 opacity-75"><?php echo e($empleado->nombre_completo ?? 'Empleado'); ?> • Período: <?php echo e(\Carbon\Carbon::parse($fechaDesde)->format('d/m/Y')); ?> - <?php echo e(\Carbon\Carbon::parse($fechaHasta)->format('d/m/Y')); ?></p>
                            </div>
                            <div class="col-md-4 text-end">
                                <a href="<?php echo e(route('admin.empleados.dashboard')); ?>" class="btn btn-outline-light">
                                    <i class="ri-arrow-left-line me-1"></i> Volver al Dashboard
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estadísticas -->
        <div class="row g-4 mb-4">
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-primary rounded">
                                <i class="ri-file-list-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-primary"><?php echo e($stats['total'] ?? 0); ?></h4>
                        <small class="text-muted">Total Pedidos</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-warning rounded">
                                <i class="ri-time-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-warning"><?php echo e($stats['pendientes'] ?? 0); ?></h4>
                        <small class="text-muted">Pendientes</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-info rounded">
                                <i class="ri-loader-4-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-info"><?php echo e($stats['procesando'] ?? 0); ?></h4>
                        <small class="text-muted">Procesando</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-md-4 col-sm-6">
                <div class="card text-center">
                    <div class="card-body">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class="ri-check-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-success"><?php echo e($stats['entregados'] ?? 0); ?></h4>
                        <small class="text-muted">Entregados</small>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-md-8">
                <div class="card text-center h-100">
                    <div class="card-body d-flex flex-column justify-content-center">
                        <div class="avatar avatar-lg mx-auto mb-2">
                            <div class="avatar-initial bg-label-success rounded">
                                <i class="ri-money-dollar-circle-line fs-4"></i>
                            </div>
                        </div>
                        <h4 class="mb-0 text-success"><?php echo e(format_money($stats['total_ingresos'] ?? 0)); ?></h4>
                        <small class="text-muted">Ingresos Generados</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filtros y Tabla -->
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h5 class="mb-0">Lista de Pedidos</h5>
                        <div class="d-flex gap-2">
                            <button class="btn btn-outline-secondary btn-sm" wire:click="clearFilters">
                                <i class="ri-refresh-line me-1"></i> Limpiar Filtros
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <!-- Filtros Mejorados -->
                        <div class="row g-3 mb-4">
                            <div class="col-md-4">
                                <div class="input-group">
                                    <span class="input-group-text"><i class="ri-search-line"></i></span>
                                    <input type="text" class="form-control" wire:model.live.debounce.300ms="search" placeholder="Buscar por código o cliente...">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" wire:model.live="estado">
                                    <option value="">Todos los estados</option>
                                    <option value="Pendiente">Pendiente</option>
                                    <option value="Procesando">Procesando</option>
                                    <option value="entregado">Entregado</option>
                                    <option value="cancelado">Cancelado</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <input type="date" class="form-control" wire:model.live="fechaDesde" placeholder="Fecha desde">
                            </div>
                            <div class="col-md-2">
                                <input type="date" class="form-control" wire:model.live="fechaHasta" placeholder="Fecha hasta">
                            </div>
                            <div class="col-md-2">
                                <select class="form-select" wire:model.live="perPage">
                                    <option value="10">10 por página</option>
                                    <option value="15">15 por página</option>
                                    <option value="25">25 por página</option>
                                    <option value="50">50 por página</option>
                                </select>
                            </div>
                        </div>

                        <!-- Tabla Mejorada -->
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th wire:click="sortBy('codigo')" style="cursor: pointer;">
                                            Código 
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'codigo'): ?>
                                                <i class="ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </th>
                                        <th>Cliente</th>
                                        <th wire:click="sortBy('created_at')" style="cursor: pointer;">
                                            Fecha 
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'created_at'): ?>
                                                <i class="ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </th>
                                        <th>Estado</th>
                                        <th wire:click="sortBy('total_usd')" style="cursor: pointer;">
                                            Total 
                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'total_usd'): ?>
                                                <i class="ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                        </th>
                                        <th class="text-center">Productos</th>
                                        <th class="text-center">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $pedidos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pedido): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr class="order-row" style="cursor: pointer;" onclick="window.open('<?php echo e(route('admin.empleados.pedido.detalle', $pedido->codigo)); ?>', '_blank')">
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-2">
                                                        <div class="avatar-initial bg-label-<?php echo e($pedido->estado == 'Pendiente' ? 'warning' : ($pedido->estado == 'entregado' ? 'success' : 'info')); ?> rounded">
                                                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado == 'Pendiente'): ?>
                                                                <i class="ri-time-line"></i>
                                                            <?php elseif($pedido->estado == 'Procesando'): ?>
                                                                <i class="ri-loader-4-line"></i>
                                                            <?php elseif($pedido->estado == 'entregado'): ?>
                                                                <i class="ri-check-line"></i>
                                                            <?php else: ?>
                                                                <i class="ri-file-list-line"></i>
                                                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                        </div>
                                                    </div>
                                                    <span class="fw-bold">#<?php echo e($pedido->codigo); ?></span>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="avatar avatar-sm me-2">
                                                        <span class="avatar-initial rounded-circle bg-label-primary">
                                                            <?php echo e(strtoupper(substr($pedido->user->name ?? 'C', 0, 1))); ?>

                                                        </span>
                                                    </div>
                                                    <div>
                                                        <h6 class="mb-0"><?php echo e($pedido->user->name ?? 'Cliente'); ?></h6>
                                                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->user->telefono): ?>
                                                            <small class="text-muted"><?php echo e($pedido->user->telefono); ?></small>
                                                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div>
                                                    <span class="fw-medium"><?php echo e($pedido->created_at->format('d/m/Y')); ?></span>
                                                    <br>
                                                    <small class="text-muted"><?php echo e($pedido->created_at->format('H:i')); ?> • <?php echo e($pedido->created_at->diffForHumans()); ?></small>
                                                </div>
                                            </td>
                                            <td>
                                                <span class="badge bg-<?php echo e($pedido->estado == 'Pendiente' ? 'warning' : ($pedido->estado == 'Procesando' ? 'info' : ($pedido->estado == 'entregado' ? 'success' : 'secondary'))); ?> rounded-pill">
                                                    <?php echo e($pedido->estado); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div>
                                                    <span class="fw-bold text-primary"><?php echo e(format_money($pedido->total_usd)); ?></span>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(is_venezuela_company()): ?>
                                                        <br>
                                                        <small class="text-muted"><?php echo e(format_money($pedido->total_bs)); ?> Bs</small>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </td>
                                            <td class="text-center">
                                                <span class="badge bg-label-secondary rounded-pill">
                                                    <?php echo e($pedido->detalles->count()); ?>

                                                </span>
                                            </td>
                                            <td class="text-center" onclick="event.stopPropagation();">
                                                <div class="d-flex gap-1 justify-content-center">
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->estado == 'Pendiente'): ?>
                                                        <button class="btn btn-sm btn-success" wire:click="updateOrderStatus(<?php echo e($pedido->id); ?>, 'Procesando')" title="Procesar">
                                                            <i class="ri-play-line"></i>
                                                        </button>
                                                    <?php elseif($pedido->estado == 'Procesando'): ?>
                                                        <button class="btn btn-sm btn-primary" wire:click="updateOrderStatus(<?php echo e($pedido->id); ?>, 'entregado')" title="Entregar">
                                                            <i class="ri-check-line"></i>
                                                        </button>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->user->telefono): ?>
                                                        <a href="tel:<?php echo e($pedido->user->telefono); ?>" class="btn btn-sm btn-outline-success" title="Llamar">
                                                            <i class="ri-phone-line"></i>
                                                        </a>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                    
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedido->latitud && $pedido->longitud): ?>
                                                        <a href="https://www.google.com/maps/dir//<?php echo e($pedido->latitud); ?>,<?php echo e($pedido->longitud); ?>" target="_blank" class="btn btn-sm btn-outline-info" title="Navegar">
                                                            <i class="ri-navigation-line"></i>
                                                        </a>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="7" class="text-center py-5">
                                                <div class="avatar avatar-xl mx-auto mb-3">
                                                    <div class="avatar-initial bg-label-secondary rounded">
                                                        <i class="ri-search-line" style="font-size: 2rem;"></i>
                                                    </div>
                                                </div>
                                                <h6 class="text-muted mb-2">No se encontraron pedidos</h6>
                                                <p class="text-muted mb-3">Intenta ajustar los filtros de búsqueda o el rango de fechas</p>
                                                <button class="btn btn-outline-primary btn-sm" wire:click="clearFilters">
                                                    <i class="ri-refresh-line me-1"></i> Limpiar Filtros
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Paginación y Resumen -->
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pedidos->hasPages()): ?>
                            <div class="d-flex justify-content-between align-items-center mt-4">
                                <div class="text-muted">
                                    Mostrando <?php echo e($pedidos->firstItem()); ?> - <?php echo e($pedidos->lastItem()); ?> de <?php echo e($pedidos->total()); ?> pedidos
                                </div>
                                <?php echo e($pedidos->links()); ?>

                            </div>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>

<?php $__env->startPush('styles'); ?>
<style>
.order-row:hover {
    background-color: #f8f9fa;
    transform: translateX(2px);
    transition: all 0.2s ease;
}
.table th[wire\:click] {
    user-select: none;
}
.table th[wire\:click]:hover {
    background-color: #e9ecef;
}
</style>
<?php $__env->stopPush(); ?><?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/pedidos/historico.blade.php ENDPATH**/ ?>