<div>
    <!-- Statistics Cards -->
    <div class="row g-4 mb-4">
        <div class="col-sm-6 col-xl-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Total Marcas</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2"><?php echo e($stats['total'] ?? 0); ?></h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-primary">
                                <i class=" ri-award-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Marcas Activas</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2"><?php echo e($stats['activas'] ?? 0); ?></h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-success">
                                <i class=" ri-award-fill ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-4">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Marcas Inactivas</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2"><?php echo e($stats['inactivas'] ?? 0); ?></h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-danger">
                                <i class=" ri-close-circle-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros y acciones -->
    <div class="card">
        <div class="card-header border-bottom d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3">
            <div>
                <h5 class="card-title mb-0">Lista de Marcas</h5>
                <p class="card-subtitle mt-1 mb-0">Gestiona las marcas de tus productos</p>
            </div>
            <div class="d-flex flex-wrap gap-2">
                <div class="input-group w-px-300">
                    <span class="input-group-text"><i class=" ri-search-line"></i></span>
                    <input type="text" class="form-control" placeholder="Buscar marcas..." wire:model.live.debounce.300ms="search">
                </div>

                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class=" ri-filter-line me-1"></i>Filtros
                    </button>
                    <div class="dropdown-menu p-3" style="min-width: 280px;">
                        <div class="mb-3">
                            <label class="form-label">Estado</label>
                            <select class="form-select" wire:model.live="status">
                                <option value="">Todos los estados</option>
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>

                        <div class="mb-0">
                            <label class="form-label">Mostrar</label>
                            <select class="form-select" wire:model.live="perPage">
                                <option value="10">10 por página</option>
                                <option value="25">25 por página</option>
                                <option value="50">50 por página</option>
                                <option value="100">100 por página</option>
                            </select>
                        </div>
                    </div>
                </div>

                <a href="<?php echo e(route('admin.marcas.create')); ?>" class="btn btn-primary d-flex align-items-center">
                    <i class=" ri-add-line ri-20px me-1"></i>
                    <span class="d-none d-sm-inline-block">Agregar Marca</span>
                </a>
            </div>
        </div>

        <div class="card-datatable table-responsive">
            <table class="table">
                <thead class="table-light">
                    <tr>
                        <th style="width: 5%">#</th>
                        <th style="width: 35%">Nombre</th>
                        <th style="width: 40%">Descripción</th>
                        <th style="width: 10%">Estado</th>
                        <th style="width: 10%">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $marcas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $marca): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td>
                                <span class="fw-medium"><?php echo e($marca->id); ?></span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-sm me-3">
                                        <span class="avatar-initial rounded bg-label-primary">
                                            <i class=" ri-bookmark-line"></i>
                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="mb-0"><?php echo e($marca->nombre); ?></h6>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($marca->descripcion): ?>
                                    <span class="text-muted"><?php echo e(Str::limit($marca->descripcion, 50)); ?></span>
                                <?php else: ?>
                                    <span class="text-muted">Sin descripción</span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </td>
                            <td>
                                <div class="form-check form-switch mb-0">
                                    <input class="form-check-input" type="checkbox"
                                           wire:click="toggleEstado(<?php echo e($marca->id); ?>)"
                                           <?php if($marca->activo): ?> checked <?php endif; ?>
                                           style="cursor: pointer;">
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class=" ri-more-2-line"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit marcas')): ?>
                                        <a class="dropdown-item" href="<?php echo e(route('admin.marcas.edit', $marca)); ?>">
                                            <i class=" ri-edit-line me-1"></i> Editar
                                        </a>
                                        <?php endif; ?>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete marcas')): ?>
                                        <button type="button" class="dropdown-item text-danger"
                                                wire:click="delete(<?php echo e($marca->id); ?>)"
                                                wire:confirm="¿Estás seguro de que deseas eliminar esta marca?">
                                            <i class=" ri-delete-bin-line me-1"></i> Eliminar
                                        </button>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center py-4">
                                <i class=" ri-award-line fs-1 text-muted mb-2"></i>
                                <p class="mb-0">No se encontraron marcas</p>
                                <p class="text-muted">Prueba cambiando los filtros o crea una nueva marca</p>
                                <a href="<?php echo e(route('admin.marcas.create')); ?>" class="btn btn-primary mt-2">
                                    <i class=" ri-add-line me-1"></i>
                                    Crear Marca
                                </a>
                            </td>
                        </tr>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="card-footer border-top">
            <?php echo e($marcas->links('livewire.pagination')); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/marcas/index.blade.php ENDPATH**/ ?>