<div>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session()->has('message')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo e(session('message')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <?php if(session()->has('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo e(session('error')); ?>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title mb-1">Detalle de Caja - <?php echo e(format_date($caja->fecha)); ?></h5>
                            <p class="mb-0">
                                Estado:
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($caja->estado === 'abierta'): ?>
                                    <span class="badge bg-success">Abierta</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Cerrada</span>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </p>
                        </div>
                        <div class="d-flex gap-2">
                            <button type="button" class="btn btn-success" wire:click="exportarExcel">
                                <i class="ri-file-excel-line "></i> Exportar Excel
                            </button>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($caja->estado === 'abierta'): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit cajas')): ?>
                                <button type="button" class="btn btn-warning" wire:click="abrirModalCerrar">
                                    <i class="ri-lock-line "></i> Cerrar Caja
                                </button>
                                <?php endif; ?>
                            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            <a href="<?php echo e(route('admin.cajas.index')); ?>" class="btn btn-secondary">
                                <i class="ri-arrow-go-back-line "></i> Volver
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Resumen General -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card border-start border-primary border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Monto Inicial</h6>
                            <h3 class="mb-0">
                                <?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $caja->monto_inicial]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($caja->monto_inicial)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
                            </h3>
                        </div>
                        <div class="bg-primary bg-opacity-10 p-3 rounded">
                            <i class="ri-money-dollar-circle-line  text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Ingresos</h6>
                            <h3 class="mb-0">
                                <?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $caja->total_ingresos]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($caja->total_ingresos)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
                            </h3>
                        </div>
                        <div class="bg-success bg-opacity-10 p-3 rounded">
                            <i class="ri-trending-up-line  text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Monto Final</h6>
                            <h3 class="mb-0">
                                <?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $caja->monto_final]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($caja->monto_final)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
                            </h3>
                        </div>
                        <div class="bg-info bg-opacity-10 p-3 rounded">
                            <i class="ri-money-cny-box-line  text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-warning border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Pagos</h6>
                            <h3 class="mb-0"><?php echo e($caja->pedidoPagos->count()); ?></h3>
                        </div>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            <i class="ri-bill-line  text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Resumen por Método de Pago -->
        <div class="col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-header">
                    <h6 class="card-title mb-0">Resumen por Método de Pago</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Método</th>
                                    <th class="text-end">Cantidad</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->resumenPorMetodo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php
                                                    $iconClass = match($metodo->metodo_pago) {
                                                        'efectivo' => 'ri-money-dollar-circle-line text-success',
                                                        'transferencia' => 'ri-bank-line text-info',
                                                        'tarjeta' => 'ri-bank-card-line text-primary',
                                                        'pago_movil' => 'ri-smartphone-line text-warning',
                                                        'punto_de_venta' => 'ri-calculator-line text-secondary',
                                                        default => 'ri-question-line text-muted'
                                                    };
                                                ?>
                                                <i class="<?php echo e($iconClass); ?> me-2"></i>
                                                <?php echo e(ucfirst($metodo->metodo_pago)); ?>

                                            </div>
                                        </td>
                                        <td class="text-end"><?php echo e($metodo->cantidad); ?></td>
                                        <td class="text-end fw-semibold">
                                            <?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $metodo->total,'class' => 'fw-semibold']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($metodo->total),'class' => 'fw-semibold']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center text-muted">No hay pagos registrados</td>
                                    </tr>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Resumen por Concepto -->
        <div class="col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-header">
                    <h6 class="card-title mb-0">Resumen por Concepto</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Concepto</th>
                                    <th class="text-end">Cantidad</th>
                                    <th class="text-end">Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $this->resumenPorConcepto; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $concepto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($concepto['concepto']); ?></td>
                                        <td class="text-end"><?php echo e($concepto['cantidad']); ?></td>
                                        <td class="text-end fw-semibold"><?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $concepto['total']]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($concepto['total'])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center text-muted">No hay conceptos registrados</td>
                                    </tr>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('styles'); ?>
<style>
    .hover-lift {
        transition: all 0.2s ease-in-out;
    }
    .hover-lift:hover {
        transform: translateY(-1px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        background-color: #f8f9fa;
    }
    .table > tbody > tr.hover-lift > td {
        border-top: 1px solid #e9ecef;
        border-bottom: 1px solid #e9ecef;
    }
    .badge {
        font-size: 0.75em;
        padding: 0.35em 0.65em;
    }
</style>
<?php $__env->stopPush(); ?>

<!-- Detalle de Pagos -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h6 class="card-title mb-0">Detalle de Pagos</h6>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead class="table-light">
                                <tr>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small" style="width: 15%"># Pedido</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small" style="width: 35%">Cliente</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small" style="width: 25%">Métodos de Pago</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small text-end" style="width: 15%">Total</th>
                                    <th scope="col" class="border-0 fw-semibold text-uppercase text-muted small text-center" style="width: 10%">Hora</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    // Obtener pedidos únicos que tienen pagos en esta caja
                                    // Mostrar pagos de pedidos confirmados (estado = 'pagado' o 'entregado')
                                    $pedidosPagados = $caja->pedidoPagos()
                                        ->whereHas('pedido', function($query) {
                                            $query->whereIn('estado', ['pagado', 'entregado']);
                                        })
                                        ->get()
                                        ->groupBy('pedidoId')
                                        ->map(function ($pagos) {
                                            $pedido = $pagos->first()->pedido;
                                            $primerPago = $pagos->first();
                                            return [
                                                'pedido' => $pedido,
                                                'total_pagado' => $pagos->sum('total_usd'),
                                                'fecha_pago' => $primerPago->created_at,
                                                'metodos_pago' => $pagos->pluck('metodo_pago')->unique()->values()
                                            ];
                                        })->sortByDesc('fecha_pago');
                                ?>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $pedidosPagados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $pedido = $data['pedido'];
                                        $cliente = $pedido ? $pedido->user : null;
                                    ?>
                                    <tr class="hover-lift">
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="bg-primary bg-opacity-10 rounded-3 p-2 me-3">
                                                    <i class="ri-shopping-bag-3-line text-primary fs-4"></i>
                                                </div>
                                                <div>
                                                    <div class="fw-bold text-primary fs-6">#<?php echo e($pedido->id ?? 'N/A'); ?></div>
                                                    <small class="text-muted"><?php echo e($data['fecha_pago']->format('d/m/y')); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="me-2">
                                                    <i class="ri-user-line text-secondary "></i>
                                                </div>
                                                <div>
                                                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($cliente): ?>
                                                        <div class="fw-semibold"><?php echo e($cliente->name ?? 'Cliente'); ?></div>
                                                        <small class="text-muted d-block"><?php echo e($cliente->telefono ?? $cliente->email ?? ''); ?></small>
                                                    <?php else: ?>
                                                        <div>Cliente</div>
                                                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="d-flex flex-wrap gap-1">
                                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $data['metodos_pago']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $metodo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php
                                                        $iconClass = match($metodo) {
                                                            'efectivo' => 'ri-money-dollar-circle-line text-success',
                                                            'transferencia' => 'ri-bank-line text-info',
                                                            'pago_movil' => 'ri-smartphone-line text-primary',
                                                            'tarjeta' => 'ri-bank-card-line text-warning',
                                                            'punto_de_venta' => 'ri-calculator-line text-secondary',
                                                            default => 'ri-question-line text-muted'
                                                        };
                                                        $badgeClass = match($metodo) {
                                                            'efectivo' => 'bg-success bg-opacity-10 text-success border border-success border-opacity-25',
                                                            'transferencia' => 'bg-info bg-opacity-10 text-info border border-info border-opacity-25',
                                                            'pago_movil' => 'bg-primary bg-opacity-10 text-primary border border-primary border-opacity-25',
                                                            'tarjeta' => 'bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25',
                                                            'punto_de_venta' => 'bg-secondary bg-opacity-10 text-secondary border border-secondary border-opacity-25',
                                                            default => 'bg-light text-dark'
                                                        };
                                                    ?>
                                                    <span class="badge <?php echo e($badgeClass); ?> d-inline-flex align-items-center px-2 py-1">
                                                        <i class="<?php echo e($iconClass); ?> me-1"></i>
                                                        <?php echo e(ucfirst(str_replace('_', ' ', $metodo))); ?>

                                                    </span>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                                            </div>
                                        </td>
                                        <td class="text-end">
                                            <div class="fw-bold  text-dark">$<?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $data['total_pagado']]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($data['total_pagado'])]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?></div>
                                        </td>
                                        <td class="text-center">
                                            <div class="text-muted">
                                                <i class="ri-time-line"></i>
                                                <div class="small"><?php echo e($data['fecha_pago']->format('H:i')); ?></div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="3" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="ri-inbox-unarchive-line fs-1"></i>
                                                <p class="mt-2 mb-0">No hay pedidos pagados en esta caja</p>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal Cerrar Caja -->
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showCerrarModal): ?>
    <div class="modal fade show d-block" tabindex="-1" style="background-color: rgba(0,0,0,0.5);">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Cerrar Caja</h5>
                    <button type="button" class="btn-close" wire:click="$set('showCerrarModal', false)"></button>
                </div>
                <form wire:submit="cerrarCaja">
                    <div class="modal-body">
                        <div class="alert alert-warning">
                            <i class="ri-alert-line  me-2"></i>
                            <strong>¿Estás seguro de cerrar la caja?</strong><br>
                            Una vez cerrada no se podrán agregar más pagos a esta caja.
                        </div>

                        <div class="row mb-3">
                            <div class="col-6">
                                <label class="form-label">Monto Final Calculado:</label>
                                <div class="fw-bold text-success"><?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $caja->monto_final]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($caja->monto_final)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?></div>
                            </div>
                            <div class="col-6">
                                <label class="form-label">Total Ingresos:</label>
                                <div class="fw-bold text-primary"><?php if (isset($component)) { $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.dual-currency','data' => ['amount' => $caja->total_ingresos]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('dual-currency'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['amount' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($caja->total_ingresos)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $attributes = $__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__attributesOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a)): ?>
<?php $component = $__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a; ?>
<?php unset($__componentOriginala654dbf2e75b78ec6a20b1f631d54f7a); ?>
<?php endif; ?></div>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Observaciones de Cierre</label>
                            <textarea class="form-control" wire:model="observaciones_cierre" rows="3"
                                      placeholder="Observaciones sobre el cierre de caja..."></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" wire:click="$set('showCerrarModal', false)">
                            Cancelar
                        </button>
                        <button type="submit" class="btn btn-warning">
                            <i class="ri-lock-line "></i> Cerrar Caja
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/cajas/show.blade.php ENDPATH**/ ?>