<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Foto de perfil</h5>
    </div>
    <div class="card-body">
        <form wire:submit.prevent="save">
            <div class="d-flex flex-column align-items-center">
                <!-- Vista previa del avatar -->
                <div class="mb-3 position-relative">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($tempAvatar): ?>
                        <img src="<?php echo e($tempAvatar); ?>" class="rounded-circle border" width="150" height="150" alt="Vista previa" style="object-fit: cover;">
                    <?php elseif($user->avatar): ?>
                        <img src="<?php echo e(Storage::url($user->avatar)); ?>" class="rounded-circle border" width="150" height="150" alt="Avatar actual" style="object-fit: cover;">
                        <button type="button" wire:click="removeAvatar" class="btn btn-sm btn-danger position-absolute" style="top: 5px; right: 5px; border-radius: 50%; width: 30px; height: 30px; padding: 0;" title="Eliminar foto">
                            <i class="ri-close-line"></i>
                        </button>
                    <?php else: ?>
                        <div class="rounded-circle bg-primary d-flex justify-content-center align-items-center text-white" style="width: 150px; height: 150px;">
                            <i class="ri-user-line" style="font-size: 3rem;"></i>
                        </div>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>

                <!-- Input para subir archivo (oculto) -->
                <input type="file" wire:model="avatar" class="d-none" accept="image/*" id="avatarInput">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['avatar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger mb-2"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                <!-- Botones -->
                <div class="d-flex gap-2 flex-wrap justify-content-center">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($avatar): ?>
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-save-line me-1"></i> Guardar
                        </button>
                        <button type="button" wire:click="$set('avatar', null)" class="btn btn-secondary">
                            <i class="ri-close-line me-1"></i> Cancelar
                        </button>
                    <?php else: ?>
                        <button type="button" class="btn btn-primary" onclick="document.getElementById('avatarInput').click()">
                            <i class="ri-camera-line me-1"></i> <?php echo e($user->avatar ? 'Cambiar foto' : 'Subir foto'); ?>

                        </button>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </div>
                
                <small class="text-muted mt-2 text-center">
                    Formatos permitidos: JPG, PNG, GIF<br>
                    Tamaño máximo: 2MB
                </small>
            </div>
        </form>
    </div>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/users/profile/avatar-upload.blade.php ENDPATH**/ ?>