<div>
    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="avatar avatar-lg bg-primary bg-opacity-10 rounded-circle mx-auto mb-2">
                        <i class="ri-file-list-3-line text-primary"></i>
                    </div>
                    <h4 class="mb-1"><?php echo e($stats['total']); ?></h4>
                    <p class="text-muted mb-0">Total Series</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="avatar avatar-lg bg-success bg-opacity-10 rounded-circle mx-auto mb-2">
                        <i class="ri-check-line text-success"></i>
                    </div>
                    <h4 class="mb-1"><?php echo e($stats['activas']); ?></h4>
                    <p class="text-muted mb-0">Activas</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="avatar avatar-lg bg-secondary bg-opacity-10 rounded-circle mx-auto mb-2">
                        <i class="ri-pause-line text-secondary"></i>
                    </div>
                    <h4 class="mb-1"><?php echo e($stats['inactivas']); ?></h4>
                    <p class="text-muted mb-0">Inactivas</p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="avatar avatar-lg bg-info bg-opacity-10 rounded-circle mx-auto mb-2">
                        <i class="ri-pie-chart-line text-info"></i>
                    </div>
                    <h4 class="mb-1"><?php echo e(count($tipos)); ?></h4>
                    <p class="text-muted mb-0">Tipos</p>
                </div>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h5 class="mb-0">Series de Documentos</h5>
                    <small class="text-muted">Gestión de numeración de documentos</small>
                </div>
                <div class="d-flex gap-2">
                    <button wire:click="$toggle('showFilters')" class="btn btn-outline-secondary">
                        <i class="ri-filter-line me-1"></i> Filtros
                    </button>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create series')): ?>
                    <div class="dropdown">
                        <button class="btn btn-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="ri-add-line me-1"></i> Nuevo
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?php echo e(route('admin.series.create')); ?>">
                                <i class="ri-file-text-line me-2"></i>Nueva Serie
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a class="dropdown-item" href="<?php echo e(route('admin.series.create', ['tipo' => $key])); ?>">
                                <i class="ri-add-circle-line me-2"></i><?php echo e($tipo); ?>

                            </a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <div class="card-body">
            <!-- Filtros Avanzados -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($showFilters): ?>
            <div class="card bg-light mb-4">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-3">
                            <label class="form-label">Buscar</label>
                            <div class="input-group">
                                <span class="input-group-text"><i class="ri-search-line"></i></span>
                                <input type="text" wire:model.live.debounce.300ms="search" class="form-control" placeholder="Serie...">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Tipo</label>
                            <select wire:model.live="tipo_documento" class="form-select">
                                <option value="">Todos</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($key); ?>"><?php echo e($value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Estado</label>
                            <select wire:model.live="estado" class="form-select">
                                <option value="">Todos</option>
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Empresa</label>
                            <select wire:model.live="empresa_id" class="form-select">
                                <option value="">Todas</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($empresa->id); ?>"><?php echo e($empresa->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <label class="form-label">Sucursal</label>
                            <select wire:model.live="sucursal_id" class="form-select">
                                <option value="">Todas</option>
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($sucursal->id); ?>"><?php echo e($sucursal->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </select>
                        </div>
                        <div class="col-md-1">
                            <label class="form-label">&nbsp;</label>
                            <button wire:click="clearFilters" class="btn btn-outline-secondary w-100" title="Limpiar">
                                <i class="ri-refresh-line"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <!-- Acciones en Lote -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($selectedSeries) > 0): ?>
            <div class="alert alert-info d-flex justify-content-between align-items-center">
                <span><i class="ri-checkbox-line me-1"></i><?php echo e(count($selectedSeries)); ?> series seleccionadas</span>
                <div class="d-flex gap-2">
                    <button wire:click="bulkToggleActivo" class="btn btn-sm btn-success">
                        <i class="ri-check-line me-1"></i>Activar
                    </button>
                    <button wire:click="bulkDelete" wire:confirm="¿Eliminar las series seleccionadas?" class="btn btn-sm btn-danger">
                        <i class="ri-delete-bin-line me-1"></i>Eliminar
                    </button>
                </div>
            </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <!-- Tabla -->
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead class="table-light">
                        <tr>
                            <th width="40">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model.live="selectAll">
                                </div>
                            </th>
                            <th wire:click="sortBy('tipo_documento')" class="cursor-pointer">
                                <i class="ri-file-text-line me-1"></i>Tipo
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'tipo_documento'): ?>
                                    <i class="ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </th>
                            <th wire:click="sortBy('serie')" class="cursor-pointer">
                                <i class="ri-hashtag me-1"></i>Serie
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($sortBy === 'serie'): ?>
                                    <i class="ri-arrow-<?php echo e($sortDirection === 'asc' ? 'up' : 'down'); ?>-line"></i>
                                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </th>
                            <th><i class="ri-numbers-line me-1"></i>Correlativo</th>
                            <th><i class="ri-building-line me-1"></i>Empresa</th>
                            <th><i class="ri-store-line me-1"></i>Sucursal</th>
                            <th><i class="ri-toggle-line me-1"></i>Estado</th>
                            <th width="120">Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $series; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="<?php echo e(in_array($serie->id, $selectedSeries) ? 'table-active' : ''); ?>">
                            <td>
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model.live="selectedSeries" value="<?php echo e($serie->id); ?>">
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <?php
                                        $iconos = [
                                            'factura' => 'ri-file-text-line text-primary',
                                            'boleta' => 'ri-file-list-line text-info',
                                            'nota_credito' => 'ri-file-warning-line text-warning',
                                            'recibo' => 'ri-receipt-line text-success'
                                        ];
                                    ?>
                                    <i class="<?php echo e($iconos[$serie->tipo_documento] ?? 'ri-file-line'); ?> me-2 fs-5"></i>
                                    <div>
                                        <span class="fw-medium"><?php echo e($tipos[$serie->tipo_documento] ?? $serie->tipo_documento); ?></span>
                                        <br><small class="text-muted"><?php echo e(ucfirst($serie->tipo_documento)); ?></small>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-dark fs-6 font-monospace"><?php echo e($serie->serie); ?></span>
                            </td>
                            <td>
                                <div class="d-flex flex-column">
                                    <span class="fw-medium font-monospace"><?php echo e($serie->numero_completo); ?></span>
                                    <small class="text-muted">Longitud: <?php echo e($serie->longitud_correlativo); ?> dígitos</small>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-xs bg-primary bg-opacity-10 rounded-circle me-2">
                                        <i class="ri-building-line text-primary"></i>
                                    </div>
                                    <?php echo e($serie->empresa->nombre ?? '-'); ?>

                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-xs bg-info bg-opacity-10 rounded-circle me-2">
                                        <i class="ri-store-line text-info"></i>
                                    </div>
                                    <?php echo e($serie->sucursal->nombre ?? '-'); ?>

                                </div>
                            </td>
                            <td>
                                <div class="form-check form-switch">
                                    <input class="form-check-input"
                                           type="checkbox"
                                           wire:click="toggleActivo(<?php echo e($serie->id); ?>)"
                                           <?php echo e($serie->activo ? 'checked' : ''); ?>

                                           id="switch<?php echo e($serie->id); ?>">
                                    <label class="form-check-label" for="switch<?php echo e($serie->id); ?>">
                                        <span class="badge bg-<?php echo e($serie->activo ? 'success' : 'secondary'); ?>">
                                            <?php echo e($serie->activo ? 'Activo' : 'Inactivo'); ?>

                                        </span>
                                    </label>
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button class="btn btn-sm btn-icon btn-text-secondary rounded-pill" type="button" data-bs-toggle="dropdown">
                                        <i class="ri-more-2-line"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end">
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit series')): ?>
                                        <li><a class="dropdown-item" href="<?php echo e(route('admin.series.edit', $serie)); ?>">
                                            <i class="ri-edit-line me-2"></i>Editar
                                        </a></li>
                                        <?php endif; ?>
                                        <li><button class="dropdown-item" wire:click="toggleActivo(<?php echo e($serie->id); ?>)">
                                            <i class="ri-toggle-line me-2"></i><?php echo e($serie->activo ? 'Desactivar' : 'Activar'); ?>

                                        </button></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><button class="dropdown-item" onclick="navigator.clipboard.writeText('<?php echo e($serie->numero_completo); ?>')">                                            <i class="ri-file-copy-line me-2"></i>Copiar Número
                                        </button></li>
                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete series')): ?>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><button class="dropdown-item text-danger" wire:click="delete(<?php echo e($serie->id); ?>)"
                                                wire:confirm="¿Eliminar la serie <?php echo e($serie->serie); ?>?">
                                            <i class="ri-delete-bin-line me-2"></i>Eliminar
                                        </button></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="text-center py-5">
                                <div class="d-flex flex-column align-items-center">
                                    <div class="avatar avatar-xl bg-light rounded-circle mb-3">
                                        <i class="ri-file-list-3-line text-muted fs-1"></i>
                                    </div>
                                    <h6 class="text-muted mb-1">No hay series registradas</h6>
                                    <p class="text-muted mb-3">Crea tu primera serie para comenzar a numerar documentos</p>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create series')): ?>
                                    <a href="<?php echo e(route('admin.series.create')); ?>" class="btn btn-primary">
                                        <i class="ri-add-line me-1"></i>Nueva Serie
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Footer con paginación y controles -->
        <div class="card-footer">
            <div class="d-flex justify-content-between align-items-center">
                <div class="d-flex align-items-center gap-3">
                    <span class="text-muted">Mostrar</span>
                    <select wire:model.live="perPage" class="form-select form-select-sm" style="width: auto;">
                        <option value="10">10</option>
                        <option value="15">15</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                    </select>
                    <span class="text-muted">registros</span>
                </div>
                
                <div class="d-flex align-items-center gap-3">
                    <span class="text-muted"><?php echo e($series->firstItem() ?? 0); ?>-<?php echo e($series->lastItem() ?? 0); ?> de <?php echo e($series->total()); ?></span>
                    <?php echo e($series->links('livewire.pagination')); ?>

                </div>
            </div>
        </div>
    </div>

    <style>
    .cursor-pointer {
        cursor: pointer;
    }
    .font-monospace {
        font-family: 'Courier New', monospace;
    }
    .avatar {
        width: 2rem;
        height: 2rem;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .avatar.avatar-xs {
        width: 1.5rem;
        height: 1.5rem;
    }
    .avatar.avatar-lg {
        width: 3rem;
        height: 3rem;
    }
    .avatar.avatar-xl {
        width: 4rem;
        height: 4rem;
    }
    </style>
</div>
<?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/series/index.blade.php ENDPATH**/ ?>