<script>
    // QuickView Image Handler - Mejora de funcionalidad de imágenes
    (function() {
        'use strict';
        
        let quickViewSwiper = null;
        let thumbsSwiper = null;
        let isInitializing = false;

        // Función para inicializar Swiper
        window.initQuickViewSwiper = function() {
            if (isInitializing) {
                console.log('Swiper ya se está inicializando...');
                return;
            }
            
            console.log('=== INICIALIZANDO QUICKVIEW SWIPER ===');
            isInitializing = true;
            
            // Destruir instancias anteriores si existen
            if (thumbsSwiper) {
                console.log('Destruyendo thumbsSwiper anterior');
                thumbsSwiper.destroy();
                thumbsSwiper = null;
            }
            if (quickViewSwiper) {
                console.log('Destruyendo quickViewSwiper anterior');
                quickViewSwiper.destroy();
                quickViewSwiper = null;
            }

            // Esperar un momento para que el DOM se actualice
            setTimeout(() => {
                // Inicializar Swiper de miniaturas primero
                const thumbsElement = document.querySelector('.product-gallery-thumbs');
                if (thumbsElement) {
                    console.log('Inicializando thumbsSwiper');
                    thumbsSwiper = new Swiper('.product-gallery-thumbs', {
                        spaceBetween: 10,
                        slidesPerView: 4,
                        freeMode: true,
                        watchSlidesProgress: true,
                        breakpoints: {
                            320: {
                                slidesPerView: 3,
                            },
                            768: {
                                slidesPerView: 4,
                            }
                        }
                    });
                    console.log('thumbsSwiper inicializado');
                } else {
                    console.log('No se encontró elemento thumbs');
                }

                // Inicializar Swiper principal
                const mainElement = document.querySelector('.product-gallery-main');
                if (mainElement) {
                    console.log('Inicializando quickViewSwiper');
                    
                    // Verificar si hay imágenes
                    const hasImages = mainElement.querySelectorAll('.swiper-slide').length > 0;
                    console.log('Imágenes encontradas:', hasImages);
                    
                    quickViewSwiper = new Swiper('.product-gallery-main', {
                        spaceBetween: 10,
                        navigation: {
                            nextEl: '.swiper-button-next',
                            prevEl: '.swiper-button-prev',
                        },
                        thumbs: thumbsSwiper ? {
                            swiper: thumbsSwiper,
                        } : undefined,
                        effect: 'fade',
                        fadeEffect: {
                            crossFade: true
                        },
                        speed: 400,
                        on: {
                            init: function() {
                                console.log('QuickView Swiper inicializado completamente');
                                isInitializing = false;
                            },
                            slideChange: function() {
                                console.log('Slide cambiado a:', this.activeIndex);
                            }
                        }
                    });
                } else {
                    console.log('No se encontró elemento main');
                    isInitializing = false;
                }

                // Inicializar carrusel de productos relacionados
                initRelatedProductsSwiper();
            }, 100);
        };

        // Función para inicializar el carrusel de productos relacionados
        function initRelatedProductsSwiper() {
            console.log('🔄 Inicializando carrusel de productos relacionados...');
            
            // Destruir instancia existente si hay una
            if (window.relatedProductsSwiper) {
                window.relatedProductsSwiper.destroy(true, true);
                window.relatedProductsSwiper = null;
            }

            const relatedSwiperEl = document.querySelector('.related-products-swiper');
            if (relatedSwiperEl) {
                window.relatedProductsSwiper = new Swiper('.related-products-swiper', {
                    slidesPerView: 'auto',
                    spaceBetween: 16,
                    loop: true,
                    autoplay: {
                        delay: 3000,
                        disableOnInteraction: false,
                        pauseOnMouseEnter: true
                    },
                    pagination: {
                        el: '.related-products-pagination',
                        clickable: true,
                        dynamicBullets: true
                    },
                    breakpoints: {
                        320: {
                            slidesPerView: 2,
                            spaceBetween: 12
                        },
                        640: {
                            slidesPerView: 3,
                            spaceBetween: 14
                        },
                        768: {
                            slidesPerView: 4,
                            spaceBetween: 16
                        },
                        1024: {
                            slidesPerView: 5,
                            spaceBetween: 16
                        }
                    },
                    grabCursor: true,
                    watchOverflow: true
                });

                console.log('✅ Carrusel de productos relacionados inicializado');
            } else {
                console.log('⚠️ Elemento related-products-swiper no encontrado');
            }
        }

        // Función para actualizar galería con transición
        window.updateGalleryWithTransition = function() {
            console.log('=== ACTUALIZANDO GALERÍA CON TRANSICIÓN ===');
            
            // Aplicar efecto de transición a las imágenes
            const mainImages = document.querySelectorAll('.product-gallery-main img');
            console.log('Imágenes principales encontradas:', mainImages.length);
            
            mainImages.forEach((img, index) => {
                console.log('Aplicando transición a imagen', index);
                img.style.transition = 'opacity 0.3s ease-in-out';
                img.style.opacity = '0.5';
                setTimeout(() => {
                    img.style.opacity = '1';
                }, 50);
            });

            // Forzar actualización de Swiper
            setTimeout(() => {
                console.log('Forzando actualización de Swiper');
                
                // Actualizar el primer slide activo
                if (quickViewSwiper && quickViewSwiper.slides.length > 0) {
                    quickViewSwiper.slideTo(0, 0);
                    quickViewSwiper.update();
                    quickViewSwiper.navigation.update();
                    
                    if (thumbsSwiper) {
                        thumbsSwiper.slideTo(0, 0);
                        thumbsSwiper.update();
                    }
                }
                
                console.log('Swiper actualizado completamente');
            }, 200);
        };

        // Función para verificar si el modal está visible
        function isQuickViewModalVisible() {
            const modal = document.querySelector('.quick-view-modal');
            return modal && modal.style.display === 'block';
        }

        // Event listeners mejorados
        document.addEventListener('livewire:init', () => {
            console.log('=== LIVEWIRE INICIALIZADO ===');
            
            Livewire.on('variantSelected', (event) => {
                console.log('=== EVENTO variantSelected RECIBIDO ===', event);
                window.updateGalleryWithTransition();
            });

            Livewire.on('productChanged', (event) => {
                console.log('=== EVENTO productChanged RECIBIDO ===', event);
                window.updateGalleryWithTransition();
                // Reiniciar carrusel principal después de cambiar producto
                setTimeout(() => {
                    try {
                        if (window.resetRelatedProductsCarousel) {
                            console.log('Usando resetRelatedProductsCarousel desde productChanged...');
                            window.resetRelatedProductsCarousel();
                        } else if (typeof initRelatedProductsSwiper === 'function') {
                            console.log('resetRelatedProductsCarousel no existe, usando initRelatedProductsSwiper...');
                            initRelatedProductsSwiper();
                        }
                    } catch (error) {
                        console.warn('Error al reiniciar carrusel principal desde productChanged:', error);
                        if (typeof initRelatedProductsSwiper === 'function') {
                            initRelatedProductsSwiper();
                        }
                    }
                }, 500);
            });

            Livewire.on('refreshQuickView', () => {
                console.log('=== EVENTO refreshQuickView RECIBIDO ===');
                console.log('Intentando reiniciar carrusel principal...');
                // Esperar a que Livewire termine de actualizar el DOM
                setTimeout(() => {
                    window.initQuickViewSwiper();
                    // Re-inicializar carrusel de productos relacionados después de un breve delay
                    setTimeout(() => {
                        initRelatedProductsSwiper();
                        // Reiniciar carrusel principal después de actualizar el modal
                        try {
                            if (window.resetRelatedProductsCarousel) {
                                console.log('Usando resetRelatedProductsCarousel desde refreshQuickView...');
                                window.resetRelatedProductsCarousel();
                            } else if (typeof initRelatedProductsSwiper === 'function') {
                                console.log('resetRelatedProductsCarousel no existe, usando initRelatedProductsSwiper...');
                                initRelatedProductsSwiper();
                            }
                        } catch (error) {
                            console.warn('Error al reiniciar carrusel principal desde refreshQuickView:', error);
                            if (typeof initRelatedProductsSwiper === 'function') {
                                initRelatedProductsSwiper();
                            }
                        }
                    }, 500);
                }, 100);
            });

            // Escuchar evento de cierre de modal
    Livewire.on('quickViewModalClosed', () => {
        console.log('=== EVENTO quickViewModalClosed DESDE QUICKVIEW ===');
        console.log('Intentando reiniciar carrusel principal...');
        setTimeout(function() {
            try {
                if (window.resetRelatedProductsCarousel) {
                    console.log('Usando función resetRelatedProductsCarousel...');
                    window.resetRelatedProductsCarousel();
                } else {
                    console.log('Función resetRelatedProductsCarousel no existe, intentando initRelatedProductsSwiper...');
                    // Si la función no existe, intentar reinicializar directamente
                    if (typeof initRelatedProductsSwiper === 'function') {
                        initRelatedProductsSwiper();
                    } else {
                        console.warn('initRelatedProductsSwiper tampoco está disponible');
                    }
                }
            } catch (error) {
                console.warn('Error al reiniciar carrusel desde quickview:', error);
                if (typeof initRelatedProductsSwiper === 'function') {
                    initRelatedProductsSwiper();
                }
            }
        }, 500);
    });
        });

        // Observador de mutaciones mejorado
        function setupMutationObserver() {
            console.log('Configurando MutationObserver...');
            
            const observer = new MutationObserver((mutations) => {
                mutations.forEach((mutation) => {
                    if (mutation.addedNodes.length) {
                        mutation.addedNodes.forEach(node => {
                            if (node.nodeType === 1) { // Element node
                                // Verificar si se agregó el modal
                                if (node.classList && node.classList.contains('quick-view-modal')) {
                                    console.log('Modal agregado al DOM');
                                    setTimeout(window.initQuickViewSwiper, 500);
                                }
                                
                                // Verificar si el modal ya existe en los nodos hijos
                                const modal = node.querySelector ? node.querySelector('.quick-view-modal') : null;
                                if (modal) {
                                    console.log('Modal encontrado en nodos agregados');
                                    setTimeout(window.initQuickViewSwiper, 500);
                                }
                            }
                        });
                    }
                    
                    // Verificar cambios de atributos de estilo
                    if (mutation.type === 'attributes' && mutation.attributeName === 'style') {
                        const target = mutation.target;
                        if (target.classList && target.classList.contains('quick-view-modal')) {
                            console.log('Estilo del modal cambiado');
                            if (target.style.display === 'block') {
                                setTimeout(window.initQuickViewSwiper, 300);
                            }
                        }
                    }
                });
            });

            observer.observe(document.body, { 
                childList: true, 
                subtree: true,
                attributes: true,
                attributeFilter: ['style']
            });
            
            console.log('MutationObserver configurado');
        }

        // Inicialización cuando el DOM esté listo
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', setupMutationObserver);
        } else {
            setupMutationObserver();
        }

        // Re-inicializar cuando Livewire actualice el componente
        document.addEventListener('livewire:navigated', () => {
            console.log('=== LIVEWIRE NAVIGATED ===');
            setTimeout(window.initQuickViewSwiper, 200);
        });

        // Hook para cuando Livewire actualice el DOM
        if (typeof Livewire !== 'undefined') {
            Livewire.hook('morph.updated', ({ el }) => {
                if (el.classList && el.classList.contains('product-gallery')) {
                    console.log('=== GALERÍA ACTUALIZADA POR LIVEWIRE ===');
                    setTimeout(window.initQuickViewSwiper, 100);
                }
            });
        }

        // Verificación inicial
        setTimeout(() => {
            if (isQuickViewModalVisible()) {
                console.log('Modal visible al cargar, inicializando...');
                window.initQuickViewSwiper();
            } else {
                console.log('Modal no visible al cargar');
            }
        }, 1000);

        // Función de debugging
        window.debugQuickView = function() {
            console.log('=== DEBUG QUICKVIEW ===');
            console.log('Modal visible:', isQuickViewModalVisible());
            console.log('quickViewSwiper:', quickViewSwiper);
            console.log('thumbsSwiper:', thumbsSwiper);
            console.log('isInitializing:', isInitializing);
            
            const mainElement = document.querySelector('.product-gallery-main');
            const thumbsElement = document.querySelector('.product-gallery-thumbs');
            
            console.log('Main element:', mainElement);
            console.log('Thumbs element:', thumbsElement);
            
            if (mainElement) {
                console.log('Slides principales:', mainElement.querySelectorAll('.swiper-slide').length);
            }
            if (thumbsElement) {
                console.log('Slides thumbs:', thumbsElement.querySelectorAll('.swiper-slide').length);
            }
        };

        console.log('=== QUICKVIEW IMAGE HANDLER CARGADO ===');
    })();
</script><?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/front/quick-view-js.blade.php ENDPATH**/ ?>