<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="ri-notification-line me-2"></i>
            Notificaciones en Tiempo Real
        </h5>
        <div class="d-flex align-items-center gap-2">
            <small class="text-muted">
                Última actualización: <?php echo e($lastCheck->format('H:i:s')); ?>

            </small>
            <button wire:click="checkForUpdates" class="btn btn-sm btn-outline-primary">
                <i class="ri-refresh-line"></i>
            </button>
        </div>
    </div>
    <div class="card-body">
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($pendingOrders) > 0): ?>
            <div class="alert alert-warning d-flex align-items-center mb-3">
                <i class="ri-alert-line me-2"></i>
                <span>
                    Tienes <?php echo e(count($pendingOrders)); ?> pedido<?php echo e(count($pendingOrders) > 1 ? 's' : ''); ?> pendiente<?php echo e(count($pendingOrders) > 1 ? 's' : ''); ?>

                    <?php if(auth()->user()->hasRole('Empleado')): ?>
                        asignado<?php echo e(count($pendingOrders) > 1 ? 's' : ''); ?> a ti
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </span>
            </div>

            <div class="list-group">
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $pendingOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1">
                                Pedido #<?php echo e($order->codigo); ?>

                                <span class="badge bg-warning ms-2"><?php echo e($order->estado); ?></span>
                            </h6>
                            <small class="text-muted"><?php echo e($order->created_at->diffForHumans()); ?></small>
                        </div>
                        <p class="mb-1">
                            <strong>Cliente:</strong> <?php echo e($order->user->name ?? 'N/A'); ?>

                        </p>
                        <p class="mb-1">
                            <strong>Total:</strong> <?php echo e(format_money($order->total_usd)); ?>

                        </p>
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($order->empleados->count() > 0): ?>
                            <p class="mb-1">
                                <strong>Asignado a:</strong> 
                                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__currentLoopData = $order->empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empleado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="badge bg-info"><?php echo e($empleado->nombre_completo); ?></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                            </p>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                        <div class="mt-2">
                            <a href="<?php echo e(route('admin.pedidos.show', $order->id)); ?>" class="btn btn-sm btn-primary">
                                Ver Detalles
                            </a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            </div>
        <?php else: ?>
            <div class="text-center py-4">
                <i class="ri-check-double-line text-success" style="font-size: 3rem;"></i>
                <h6 class="mt-2">No hay pedidos pendientes</h6>
                <p class="text-muted mb-0">
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(auth()->user()->hasRole('Empleado')): ?>
                        No tienes pedidos asignados pendientes en este momento.
                    <?php else: ?>
                        Todos los pedidos están al día.
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </p>
            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
    // Actualizar notificaciones cada 30 segundos
    setInterval(function() {
        window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('checkForUpdates');
    }, 30000);

    // Escuchar eventos de broadcasting si está disponible
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(config('broadcasting.default') !== 'null'): ?>
    document.addEventListener('DOMContentLoaded', function() {
        if (typeof Echo !== 'undefined') {
            Echo.private('empresa.<?php echo e(auth()->user()->empresa_id); ?>')
                .listen('PedidoUpdated', (e) => {
                    // Actualizar notificaciones cuando se actualiza un pedido
                    window.Livewire.find('<?php echo e($_instance->getId()); ?>').call('checkForUpdates');
                });
        }
    });
    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
</script>
<?php $__env->stopPush(); ?><?php /**PATH /home/abastolo/public_html/app.abastolostrinis.com/resources/views/livewire/admin/real-time-notifications.blade.php ENDPATH**/ ?>