<div class="min-h-screen bg-gray-50">
@section('content')
    <!-- Hero Section - Tailwind CSS -->
    <section class="relative overflow-hidden bg-gradient-to-br from-indigo-600 via-purple-600 to-pink-600 py-20">
        <div class="absolute inset-0 bg-black opacity-20"></div>
        <div class="relative mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 items-center gap-12 lg:grid-cols-2">
                <!-- Hero Content -->
                <div class="text-center lg:text-left">
                    <h1 class="text-4xl font-extrabold text-white sm:text-5xl lg:text-6xl">
                        Bienvenido a
                        <span class="bg-gradient-to-r from-yellow-400 to-orange-500 bg-clip-text text-transparent">
                            Nuestra Tienda
                        </span>
                    </h1>
                    <p class="mt-6 text-xl text-white/90">
                        Descubre miles de productos de calidad con los mejores precios del mercado.
                        Envío rápido y seguro a todo el país.
                    </p>
                    <div class="mt-10 flex flex-col justify-center gap-4 sm:flex-row lg:justify-start">
                        <a href="{{ route('tienda.productos') }}"
                           class="inline-flex items-center justify-center rounded-full bg-white px-8 py-4 text-lg font-semibold text-gray-900 shadow-lg transition-all hover:bg-gray-100 hover:shadow-xl">
                            <i class="ri-shopping-bag-line mr-2"></i>
                            Ver Productos
                        </a>
                        <a href="#mas-vendidos"
                           class="inline-flex items-center justify-center rounded-full border-2 border-white px-8 py-4 text-lg font-semibold text-white transition-all hover:bg-white hover:text-gray-900">
                            <i class="ri-fire-line mr-2"></i>
                            Más Vendidos
                        </a>
                    </div>
                </div>

                <!-- Stats Grid -->
                <div class="grid grid-cols-2 gap-6">
                    <div class="rounded-2xl bg-white/10 p-6 text-center backdrop-blur-sm">
                        <div class="text-3xl font-bold text-white sm:text-4xl">{{ $stats['total_products'] }}</div>
                        <div class="mt-2 text-sm font-medium text-white/80">Productos</div>
                    </div>
                    <div class="rounded-2xl bg-white/10 p-6 text-center backdrop-blur-sm">
                        <div class="text-3xl font-bold text-white sm:text-4xl">{{ $stats['total_categories'] }}</div>
                        <div class="mt-2 text-sm font-medium text-white/80">Categorías</div>
                    </div>
                    <div class="rounded-2xl bg-white/10 p-6 text-center backdrop-blur-sm">
                        <div class="text-3xl font-bold text-white sm:text-4xl">{{ $stats['total_orders'] }}</div>
                        <div class="mt-2 text-sm font-medium text-white/80">Pedidos</div>
                    </div>
                    <div class="rounded-2xl bg-white/10 p-6 text-center backdrop-blur-sm">
                        <div class="text-3xl font-bold text-white sm:text-4xl">{{ $stats['total_customers'] }}</div>
                        <div class="mt-2 text-sm font-medium text-white/80">Clientes</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Productos Más Vendidos - Tailwind CSS -->
    <section id="mas-vendidos" class="bg-gradient-to-br from-gray-50 to-gray-100 py-20">
        <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <!-- Section Header -->
            <div class="mb-16 text-center">
                <h2 class="text-4xl font-bold text-gray-900 sm:text-5xl lg:text-6xl">
                    Productos Más Vendidos
                </h2>
                <p class="mt-6 text-xl text-gray-600">
                    Descubre lo que nuestros clientes prefieren
                </p>
                <div class="mx-auto mt-8 h-1 w-24 bg-gradient-to-r from-indigo-500 to-purple-600"></div>
            </div>

            <!-- Products Carousel -->
            <div class="relative">
                <div class="flex gap-6 overflow-x-auto pb-6" style="scroll-behavior: smooth;">
                    @foreach($productosMasVendidos as $producto)
                        <div class="flex-shrink-0 w-80">
                            <div class="group relative overflow-hidden rounded-3xl bg-white shadow-2xl transition-all duration-300 hover:shadow-3xl hover:scale-105">
                                <!-- Sales Badge -->
                                <div class="absolute left-6 top-6 z-10">
                                    <span class="inline-flex items-center rounded-full bg-gradient-to-r from-orange-500 to-red-500 px-4 py-2 text-sm font-bold text-white shadow-lg">
                                        <i class="ri-fire-line mr-1"></i>#{{ $loop->iteration }}
                                    </span>
                                </div>

                                <!-- Product Image -->
                                <div class="relative h-80 overflow-hidden">
                                    @if($producto->images && $producto->images->first())
                                        <img src="{{ Storage::url($producto->images->first()->path) }}"
                                             alt="{{ $producto->name }}"
                                             class="h-full w-full object-cover transition-transform duration-300 group-hover:scale-110">
                                    @else
                                        <div class="flex h-full w-full items-center justify-center bg-gradient-to-br from-gray-100 to-gray-200">
                                            <i class="ri-image-line text-gray-400" style="font-size: 4rem;"></i>
                                        </div>
                                    @endif

                                    <!-- Overlay Actions -->
                                    <div class="absolute inset-0 flex items-center justify-center gap-4 bg-black bg-opacity-0 transition-all duration-300 group-hover:bg-opacity-40">
                                        <button wire:click="toggleFavorito({{ $producto->id }})"
                                                class="translate-y-8 transform rounded-full p-4 shadow-xl transition-all duration-300 group-hover:translate-y-0 {{ in_array($producto->id, $favoritos) ? 'bg-red-500 text-white' : 'bg-white text-gray-700 hover:bg-red-500 hover:text-white' }}">
                                            <i class="{{ in_array($producto->id, $favoritos) ? 'ri-heart-fill' : 'ri-heart-line' }} text-xl"></i>
                                        </button>
                                        <button wire:click="addToCart({{ $producto->id }})"
                                                class="translate-y-8 transform rounded-full bg-white p-4 text-gray-700 shadow-xl transition-all duration-300 group-hover:translate-y-0 hover:bg-blue-500 hover:text-white">
                                            <i class="ri-shopping-cart-line text-xl"></i>
                                        </button>
                                    </div>

                                    <!-- Discount Badge -->
                                    @if($producto->discount > 0)
                                        <div class="absolute right-6 top-6">
                                            <span class="inline-flex items-center rounded-full bg-gradient-to-r from-green-500 to-emerald-500 px-4 py-2 text-sm font-bold text-white shadow-lg">
                                                <i class="ri-percent-line mr-1"></i>-{{ $producto->discount }}%
                                            </span>
                                        </div>
                                    @endif
                                </div>

                                <!-- Product Info -->
                                <div class="p-6">
                                    <div class="mb-4">
                                        <span class="mb-2 inline-flex items-center text-sm font-semibold text-indigo-600">
                                            <i class="ri-price-tag-3-line mr-1"></i>{{ $producto->categoria->nombre ?? 'Sin categoría' }}
                                        </span>
                                        <h3 class="text-xl font-bold text-gray-900" title="{{ $producto->name }}">
                                            {{ Str::limit($producto->name, 50) }}
                                        </h3>
                                    </div>

                                    <!-- Price Section -->
                                    <div class="mb-6">
                                        @if($currency === 'USD')
                                            @if($producto->discount > 0)
                                                <div class="flex items-center gap-2 mb-2">
                                                    <span class="text-sm text-gray-500 line-through">
                                                        ${{ number_format($producto->price, 2) }}
                                                    </span>
                                                    <span class="inline-flex items-center rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">
                                                        AHORRA {{ $producto->discount }}%
                                                    </span>
                                                </div>
                                                <div class="text-3xl font-bold text-gray-900">
                                                    ${{ number_format($producto->price * (1 - $producto->discount/100), 2) }}
                                                </div>
                                            @else
                                                <div class="text-3xl font-bold text-gray-900">
                                                    ${{ number_format($producto->price, 2) }}
                                                </div>
                                            @endif
                                        @else
                                            @if($producto->precioBs)
                                                @if($producto->discount > 0)
                                                    <div class="flex items-center gap-2 mb-2">
                                                        <span class="text-sm text-gray-500 line-through">
                                                            {{ number_format($producto->precioBs, 2) }} Bs
                                                        </span>
                                                        <span class="inline-flex items-center rounded-full bg-green-100 px-3 py-1 text-xs font-semibold text-green-800">
                                                            AHORRA {{ $producto->discount }}%
                                                        </span>
                                                    </div>
                                                    <div class="text-3xl font-bold text-gray-900">
                                                        {{ number_format($producto->precioBs * (1 - $producto->discount/100), 2) }} Bs
                                                    </div>
                                                @else
                                                    <div class="text-3xl font-bold text-gray-900">
                                                        {{ number_format($producto->precioBs, 2) }} Bs
                                                    </div>
                                                @endif
                                            @else
                                                <div class="text-lg text-gray-500">Precio no disponible</div>
                                            @endif
                                        @endif
                                    </div>

                                    <!-- Add to Cart Button -->
                                    <button wire:click="addToCart({{ $producto->id }})"
                                            class="w-full rounded-full bg-gradient-to-r from-indigo-600 to-purple-600 py-4 text-lg font-bold text-white shadow-lg transition-all hover:from-indigo-700 hover:to-purple-700 hover:shadow-xl">
                                        <i class="ri-shopping-bag-line mr-2"></i>Añadir al Carrito
                                    </button>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>

    <!-- Productos Destacados - Tailwind CSS -->
    <section class="bg-white py-20">
        <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <!-- Section Header -->
            <div class="mb-16 text-center">
                <h2 class="text-4xl font-bold text-gray-900 sm:text-5xl">
                    Productos Destacados
                </h2>
                <p class="mt-6 text-xl text-gray-600">
                    Nuestra selección especial para ti
                </p>
            </div>

            <!-- Products Grid -->
            <div class="grid grid-cols-1 gap-8 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
                @foreach($productosDestacados as $producto)
                    <div class="group relative">
                        <div class="overflow-hidden rounded-2xl bg-white shadow-lg transition-all duration-300 group-hover:shadow-2xl group-hover:scale-105">
                            <!-- Product Image -->
                            <div class="relative h-64 overflow-hidden">
                                @if($producto->images && $producto->images->first())
                                    <img src="{{ Storage::url($producto->images->first()->path) }}"
                                         alt="{{ $producto->name }}"
                                         class="h-full w-full object-cover transition-transform duration-300 group-hover:scale-110">
                                @else
                                    <div class="flex h-full w-full items-center justify-center bg-gradient-to-br from-gray-100 to-gray-200">
                                        <i class="ri-image-line text-gray-400 text-4xl"></i>
                                    </div>
                                @endif

                                <!-- Favorite Button -->
                                <div class="absolute right-4 top-4">
                                    <button wire:click="toggleFavorito({{ $producto->id }})"
                                            class="rounded-full p-3 shadow-lg transition-all {{ in_array($producto->id, $favoritos) ? 'bg-red-500 text-white' : 'bg-white text-gray-700 hover:bg-red-500 hover:text-white' }}">
                                        <i class="{{ in_array($producto->id, $favoritos) ? 'ri-heart-fill' : 'ri-heart-line' }}"></i>
                                    </button>
                                </div>

                                <!-- Discount Badge -->
                                @if($producto->discount > 0)
                                    <div class="absolute left-4 top-4">
                                        <span class="inline-flex items-center rounded-full bg-gradient-to-r from-red-500 to-pink-500 px-3 py-1 text-sm font-bold text-white shadow-lg">
                                            <i class="ri-percent-line mr-1"></i>-{{ $producto->discount }}%
                                        </span>
                                    </div>
                                @endif
                            </div>

                            <!-- Product Info -->
                            <div class="p-6">
                                <div class="mb-3">
                                    <span class="mb-2 inline-flex items-center text-sm font-semibold text-indigo-600">
                                        <i class="ri-price-tag-3-line mr-1"></i>{{ $producto->categoria->nombre ?? 'Sin categoría' }}
                                    </span>
                                    <h3 class="text-lg font-bold text-gray-900" title="{{ $producto->name }}">
                                        {{ Str::limit($producto->name, 45) }}
                                    </h3>
                                </div>

                                <!-- Price Section -->
                                <div class="mb-4">
                                    @if($currency === 'USD')
                                        @if($producto->discount > 0)
                                            <div class="flex items-center gap-2 mb-1">
                                                <span class="text-sm text-gray-500 line-through">
                                                    ${{ number_format($producto->price, 2) }}
                                                </span>
                                                <span class="inline-flex items-center rounded-full bg-green-100 px-2 py-1 text-xs font-semibold text-green-800">
                                                    -{{ $producto->discount }}%
                                                </span>
                                            </div>
                                            <div class="text-2xl font-bold text-gray-900">
                                                ${{ number_format($producto->price * (1 - $producto->discount/100), 2) }}
                                            </div>
                                        @else
                                            <div class="text-2xl font-bold text-gray-900">
                                                ${{ number_format($producto->price, 2) }}
                                            </div>
                                        @endif
                                    @else
                                        @if($producto->precioBs)
                                            @if($producto->discount > 0)
                                                <div class="flex items-center gap-2 mb-1">
                                                    <span class="text-sm text-gray-500 line-through">
                                                        {{ number_format($producto->precioBs, 2) }} Bs
                                                    </span>
                                                    <span class="inline-flex items-center rounded-full bg-green-100 px-2 py-1 text-xs font-semibold text-green-800">
                                                        -{{ $producto->discount }}%
                                                    </span>
                                                </div>
                                                <div class="text-2xl font-bold text-gray-900">
                                                    {{ number_format($producto->precioBs * (1 - $producto->discount/100), 2) }} Bs
                                                </div>
                                            @else
                                                <div class="text-2xl font-bold text-gray-900">
                                                    {{ number_format($producto->precioBs, 2) }} Bs
                                                </div>
                                            @endif
                                        @else
                                            <div class="text-gray-500">Precio no disponible</div>
                                        @endif
                                    @endif
                                </div>

                                <!-- Add to Cart Button -->
                                <button wire:click="addToCart({{ $producto->id }})"
                                        class="w-full rounded-full bg-gradient-to-r from-indigo-600 to-purple-600 py-3 text-base font-bold text-white shadow-lg transition-all hover:from-indigo-700 hover:to-purple-700 hover:shadow-xl">
                                    <i class="ri-shopping-cart-line mr-2"></i>Añadir al Carrito
                                </button>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>

            <!-- View All Products Button -->
            <div class="mt-16 text-center">
                <a href="{{ route('tienda.productos') }}"
                   class="inline-flex items-center justify-center rounded-full bg-white px-8 py-4 text-lg font-semibold text-gray-900 shadow-lg transition-all hover:bg-gray-50 hover:shadow-xl">
                    <i class="ri-apps-line mr-2"></i>Ver todos los productos
                </a>
            </div>
        </div>
    </section>

    <!-- Categorías Populares - Tailwind CSS -->
    <section class="bg-gradient-to-br from-gray-50 to-gray-100 py-20">
        <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
            <!-- Section Header -->
            <div class="mb-16 text-center">
                <h2 class="text-4xl font-bold text-gray-900 sm:text-5xl">
                    Categorías Populares
                </h2>
                <p class="mt-6 text-xl text-gray-600">
                    Explora nuestras categorías más visitadas
                </p>
            </div>

            <!-- Categories Grid -->
            <div class="grid grid-cols-2 gap-6 sm:grid-cols-3 lg:grid-cols-6">
                @foreach($categoriasPopulares as $categoria)
                    <a href="{{ route('tienda.productos', ['categoria' => $categoria->id]) }}"
                       class="group relative overflow-hidden rounded-2xl bg-white p-6 text-center shadow-lg transition-all duration-300 hover:shadow-2xl hover:scale-105">
                        <div class="mb-4">
                            @if($categoria->imagen)
                                <img src="{{ Storage::url($categoria->imagen) }}"
                                     alt="{{ $categoria->nombre }}"
                                     class="mx-auto h-16 w-16 rounded-full object-cover">
                            @else
                                <div class="mx-auto flex h-16 w-16 items-center justify-center rounded-full bg-gradient-to-br from-indigo-500 to-purple-600">
                                    <i class="ri-folder-line text-2xl text-white"></i>
                                </div>
                            @endif
                        </div>
                        <h3 class="mb-2 text-base font-bold text-gray-900 group-hover:text-indigo-600">
                            {{ Str::limit($categoria->nombre, 20) }}
                        </h3>
                        <p class="text-sm text-gray-600">
                            {{ $categoria->productos_count ?? 0 }} productos
                        </p>
                    </a>
                @endforeach
            </div>
        </div>
    </section>
@endsection

<!-- Add Tailwind CSS custom styles -->
<style>
    /* Custom scrollbar for horizontal scroll */
    .featured-products-scroll::-webkit-scrollbar {
        height: 8px;
    }

    .featured-products-scroll::-webkit-scrollbar-track {
        background: #f1f5f9;
        border-radius: 4px;
    }

    .featured-products-scroll::-webkit-scrollbar-thumb {
        background: linear-gradient(to right, #6366f1, #8b5cf6);
        border-radius: 4px;
    }

    .featured-products-scroll::-webkit-scrollbar-thumb:hover {
        background: linear-gradient(to right, #4f46e5, #7c3aed);
    }
</style>

<!-- Add to Cart Animation -->
<script>
    document.addEventListener('livewire:load', function () {
        Livewire.on('productAddedToCart', function (productId) {
            // Add animation class to the button
            const button = event.target;
            button.classList.add('animate-pulse');

            setTimeout(() => {
                button.classList.remove('animate-pulse');
            }, 1000);
        });
    });
</script>
</div>
