@if ($paginator->hasPages())
    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center gap-3 w-100">

        {{-- Información de página --}}
        <div class="pagination-info text-muted small">
            Mostrando {{ $paginator->firstItem() }} - {{ $paginator->lastItem() }} de {{ $paginator->total() }} resultados
        </div>

        <nav aria-label="Page navigation">
            <ul class="pagination pagination-modern mb-0">
                {{-- Botón Primera Página --}}
                @if ($paginator->onFirstPage())
                    <li class="page-item first disabled">
                        <span class="page-link rounded-pill" aria-label="Primera página" title="Primera página">
                            <i class="ri-skip-back-line icon-base icon-22px"></i>
                        </span>
                    </li>
                @else
                    <li class="page-item first">
                        <button type="button" class="page-link rounded-pill" wire:click="gotoPage(1)" wire:loading.attr="disabled" aria-label="Primera página" title="Primera página">
                            <i class="ri-skip-back-line icon-base icon-22px"></i>
                        </button>
                    </li>
                @endif

                {{-- Botón Página Anterior --}}
                @if ($paginator->onFirstPage())
                    <li class="page-item prev disabled">
                        <span class="page-link rounded-pill" aria-label="Página anterior" title="Página anterior">
                            <i class="ri-arrow-left-s-line icon-base icon-22px"></i>
                        </span>
                    </li>
                @else
                    <li class="page-item prev">
                        <button type="button" class="page-link rounded-pill" wire:click="previousPage" wire:loading.attr="disabled" aria-label="Página anterior" title="Página anterior">
                            <i class="ri-arrow-left-s-line icon-base icon-22px"></i>
                        </button>
                    </li>
                @endif

                {{-- Números de Página --}}
                @php
                    $start = max(1, $paginator->currentPage() - 2);
                    $end = min($paginator->lastPage(), $paginator->currentPage() + 2);
                @endphp

                @for ($page = $start; $page <= $end; $page++)
                    @if ($page == $paginator->currentPage())
                        <li class="page-item active">
                            <span class="page-link rounded-pill">{{ $page }}</span>
                        </li>
                    @else
                        <li class="page-item">
                            <button type="button" class="page-link rounded-pill" wire:click="gotoPage({{ $page }})" wire:loading.attr="disabled">{{ $page }}</button>
                        </li>
                    @endif
                @endfor

                {{-- Botón Página Siguiente --}}
                @if ($paginator->hasMorePages())
                    <li class="page-item next">
                        <button type="button" class="page-link rounded-pill" wire:click="nextPage" wire:loading.attr="disabled" aria-label="Página siguiente" title="Página siguiente">
                            <i class="ri-arrow-right-s-line icon-base icon-22px"></i>
                        </button>
                    </li>
                @else
                    <li class="page-item next disabled">
                        <span class="page-link rounded-pill" aria-label="Página siguiente" title="Página siguiente">
                            <i class="ri-arrow-right-s-line icon-base icon-22px"></i>
                        </span>
                    </li>
                @endif

                {{-- Botón Última Página --}}
                @if ($paginator->hasMorePages())
                    <li class="page-item last">
                        <button type="button" class="page-link rounded-pill" wire:click="gotoPage({{ $paginator->lastPage() }})" wire:loading.attr="disabled" aria-label="Última página" title="Última página">
                            <i class="ri-skip-forward-line icon-base icon-22px"></i>
                        </button>
                    </li>
                @else
                    <li class="page-item last disabled">
                        <span class="page-link rounded-pill" aria-label="Última página" title="Última página">
                            <i class="ri-skip-forward-line icon-base icon-22px"></i>
                        </span>
                    </li>
                @endif
            </ul>
        </nav>
    </div>
@endif
