<div>
    @section('title', 'Mis Favoritos')

    <section class="section bg-light py-4">
        <div class="container">
            {{-- Breadcrumb --}}
            <nav aria-label="breadcrumb" class="mb-4">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="/" class="text-decoration-none"><i class="ri-home-4-line"></i> Inicio</a></li>
                    <li class="breadcrumb-item"><a href="/tienda" class="text-decoration-none">Tienda</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Mis Favoritos</li>
                </ol>
            </nav>

            {{-- Header --}}
            <div class="card card-velzon border-0 mb-4">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-lg-6">
                            <div class="d-flex align-items-center gap-3">
                                <div class="avatar-sm flex-shrink-0">
                                    <div class="avatar-title bg-danger-subtle text-danger rounded-circle fs-3">
                                        <i class="ri-heart-3-fill"></i>
                                    </div>
                                </div>
                                <div>
                                    <h4 class="mb-1 fw-semibold">Mis Favoritos</h4>
                                    <p class="text-muted mb-0">
                                        <span class="badge badge-soft-primary me-1">{{ $wishlists->total() }}</span>
                                        producto(s) guardado(s) en tu lista
                                    </p>
                                </div>
                            </div>
                        </div>
                        @if($wishlists->count() > 0)
                            <div class="col-lg-6">
                                <div class="d-flex justify-content-lg-end gap-2 mt-3 mt-lg-0 flex-wrap">
                                    {{-- Agregar todo al carrito --}}
                                    <button type="button" 
                                            wire:click="addAllToCart"
                                            wire:loading.attr="disabled"
                                            class="btn btn-soft-success">
                                        <span wire:loading.remove wire:target="addAllToCart">
                                            <i class="ri-shopping-cart-2-line me-1"></i>
                                            Agregar todo al carrito
                                        </span>
                                        <span wire:loading wire:target="addAllToCart">
                                            <span class="spinner-border spinner-border-sm me-1"></span>
                                            Agregando...
                                        </span>
                                    </button>
                                    
                                    {{-- Toggle Vista --}}
                                    <div class="btn-group" role="group">
                                        <button type="button" 
                                                class="btn {{ $viewMode === 'grid' ? 'btn-primary' : 'btn-soft-primary' }}"
                                                wire:click="setViewMode('grid')">
                                            <i class="ri-grid-fill"></i>
                                        </button>
                                        <button type="button" 
                                                class="btn {{ $viewMode === 'list' ? 'btn-primary' : 'btn-soft-primary' }}"
                                                wire:click="setViewMode('list')">
                                            <i class="ri-list-check"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            @if($wishlists->count() > 0 || $selectedCategory)
                <div class="row">
                    {{-- Sidebar Filtros --}}
                    <div class="col-lg-3 mb-4">
                        <div class="filter-sidebar sticky-top" style="top: 100px;">
                            <div class="filter-header">
                                <h5><i class="ri-filter-3-line me-2"></i>Filtros</h5>
                                @if($selectedCategory)
                                    <a href="#" wire:click.prevent="clearFilters" class="filter-clear">
                                        <i class="ri-close-circle-line me-1"></i>Limpiar
                                    </a>
                                @endif
                            </div>
                            
                            {{-- Filtro por Categoría --}}
                            @if(count($categories) > 0)
                                <div class="filter-group">
                                    <div class="filter-group-title">
                                        <span><i class="ri-folder-line me-2"></i>Categorías</span>
                                    </div>
                                    <div class="d-flex flex-column gap-2">
                                        @foreach($categories as $category)
                                            <button type="button"
                                                    wire:click="filterByCategory({{ $category['id'] }})"
                                                    class="btn btn-sm {{ $selectedCategory == $category['id'] ? 'btn-primary' : 'btn-soft-secondary' }} text-start d-flex justify-content-between align-items-center">
                                                <span class="text-truncate">{{ $category['nombre'] }}</span>
                                                <span class="badge {{ $selectedCategory == $category['id'] ? 'bg-white text-primary' : 'bg-light text-dark' }}">
                                                    {{ $category['productos_count'] }}
                                                </span>
                                            </button>
                                        @endforeach
                                    </div>
                                </div>
                            @endif

                            {{-- Resumen --}}
                            <div class="mt-4 p-3 bg-light rounded-3">
                                <div class="d-flex align-items-center gap-2 mb-2">
                                    <i class="ri-information-line text-info"></i>
                                    <span class="fw-medium">Resumen</span>
                                </div>
                                <small class="text-muted">
                                    {{ $wishlists->total() }} producto(s) en favoritos
                                    @if($selectedCategory)
                                        <br><span class="text-primary">Filtrando por categoría</span>
                                    @endif
                                </small>
                            </div>
                        </div>
                    </div>

                    {{-- Productos --}}
                    <div class="col-lg-9">
                        @if($wishlists->count() > 0)
                            @if($viewMode === 'grid')
                                {{-- Vista Grid --}}
                                <div class="row g-3">
                                    @foreach($wishlists as $index => $wishlist)
                                        <div class="col-xl-4 col-md-6" 
                                             style="animation: fadeInUp 0.4s ease-out {{ $index * 0.05 }}s both;">
                                            <div class="product-card h-100 ribbon-box">
                                                {{-- Ribbon de descuento --}}
                                                @if($wishlist->producto->precio_original && $wishlist->producto->precio_original > $wishlist->producto->price)
                                                    @php
                                                        $discount = round((($wishlist->producto->precio_original - $wishlist->producto->price) / $wishlist->producto->precio_original) * 100);
                                                    @endphp
                                                    <span class="ribbon ribbon-top-left ribbon-danger ribbon-fill">-{{ $discount }}%</span>
                                                @endif

                                                <div class="product-img-wrapper">
                                                    @if($wishlist->producto->images && $wishlist->producto->images->first())
                                                        <img src="{{ asset('app/' . $wishlist->producto->images->first()->path) }}"
                                                             alt="{{ $wishlist->producto->name }}"
                                                             class="product-img">
                                                    @else
                                                        <div class="d-flex align-items-center justify-content-center h-100 bg-light" style="height: 200px !important;">
                                                            <i class="ri-image-line text-muted" style="font-size: 3rem;"></i>
                                                        </div>
                                                    @endif
                                                    
                                                    {{-- Overlay con acciones --}}
                                                    <div class="product-actions">
                                                        <button wire:click="addToCart({{ $wishlist->producto->id }})"
                                                                wire:loading.attr="disabled"
                                                                wire:target="addToCart({{ $wishlist->producto->id }})"
                                                                class="btn btn-sm btn-light btn-icon-circle" 
                                                                title="Añadir al carrito">
                                                            <span wire:loading.remove wire:target="addToCart({{ $wishlist->producto->id }})">
                                                                <i class="ri-shopping-cart-line"></i>
                                                            </span>
                                                            <span wire:loading wire:target="addToCart({{ $wishlist->producto->id }})">
                                                                <span class="spinner-border spinner-border-sm"></span>
                                                            </span>
                                                        </button>
                                                        <a href="{{ url('front.producto.show', $wishlist->producto->slug ?? $wishlist->producto->id) }}" 
                                                           class="btn btn-sm btn-light btn-icon-circle" 
                                                           title="Ver producto">
                                                            <i class="ri-eye-line"></i>
                                                        </a>
                                                        <button wire:click="removeFromWishlist({{ $wishlist->id }})"
                                                                wire:loading.attr="disabled"
                                                                wire:target="removeFromWishlist({{ $wishlist->id }})"
                                                                class="btn btn-sm btn-danger btn-icon-circle" 
                                                                title="Quitar de favoritos">
                                                            <span wire:loading.remove wire:target="removeFromWishlist({{ $wishlist->id }})">
                                                                <i class="ri-heart-fill"></i>
                                                            </span>
                                                            <span wire:loading wire:target="removeFromWishlist({{ $wishlist->id }})">
                                                                <span class="spinner-border spinner-border-sm"></span>
                                                            </span>
                                                        </button>
                                                    </div>
                                                </div>

                                                <div class="product-body">
                                                    {{-- Categoría --}}
                                                    <p class="product-category mb-1">
                                                        <i class="ri-price-tag-3-line me-1"></i>
                                                        {{ $wishlist->producto->categoria->nombre ?? 'Sin categoría' }}
                                                    </p>
                                                    
                                                    {{-- Nombre --}}
                                                    <h6 class="product-title mb-2">
                                                        <a href="{{ url('front.producto.show', $wishlist->producto->slug ?? $wishlist->producto->id) }}" 
                                                           class="text-decoration-none text-dark">
                                                            {{ $wishlist->producto->name }}
                                                        </a>
                                                    </h6>
                                                    
                                                    {{-- Rating --}}
                                                    <div class="product-rating mb-2">
                                                        @php
                                                            $rating = $wishlist->producto->rating ?? rand(3, 5);
                                                        @endphp
                                                        @for($i = 1; $i <= 5; $i++)
                                                            @if($i <= $rating)
                                                                <i class="ri-star-fill"></i>
                                                            @else
                                                                <i class="ri-star-line text-muted"></i>
                                                            @endif
                                                        @endfor
                                                        <span class="ms-1">({{ $wishlist->producto->reviews_count ?? rand(5, 50) }})</span>
                                                    </div>
                                                    
                                                    {{-- Precios --}}
                                                    <div class="d-flex align-items-center gap-2 flex-wrap">
                                                        <span class="price-text">{{ money($wishlist->producto->price) }}</span>
                                                        @if($wishlist->producto->precio_original && $wishlist->producto->precio_original > $wishlist->producto->price)
                                                            <span class="price-original">{{ money($wishlist->producto->precio_original) }}</span>
                                                        @endif
                                                        @if($wishlist->producto->precio_bs)
                                                            <span class="badge badge-soft-info ms-auto">{{ $wishlist->producto->precio_bs }} Bs</span>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                {{-- Vista Lista --}}
                                <div class="d-flex flex-column gap-3">
                                    @foreach($wishlists as $index => $wishlist)
                                        <div class="card card-velzon border-0 overflow-hidden" 
                                             style="animation: fadeInUp 0.4s ease-out {{ $index * 0.05 }}s both;">
                                            <div class="row g-0 align-items-center">
                                                <div class="col-md-3 col-lg-2">
                                                    <div class="position-relative">
                                                        @if($wishlist->producto->images && $wishlist->producto->images->first())
                                                            <img src="{{ asset('app/' . $wishlist->producto->images->first()->path) }}"
                                                                 alt="{{ $wishlist->producto->name }}"
                                                                 class="img-fluid w-100"
                                                                 style="height: 140px; object-fit: cover;">
                                                        @else
                                                            <div class="bg-light d-flex align-items-center justify-content-center" style="height: 140px;">
                                                                <i class="ri-image-line text-muted fs-1"></i>
                                                            </div>
                                                        @endif
                                                        @if($wishlist->producto->precio_original && $wishlist->producto->precio_original > $wishlist->producto->price)
                                                            @php
                                                                $discount = round((($wishlist->producto->precio_original - $wishlist->producto->price) / $wishlist->producto->precio_original) * 100);
                                                            @endphp
                                                            <span class="position-absolute top-0 start-0 badge bg-danger m-2">-{{ $discount }}%</span>
                                                        @endif
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-lg-7">
                                                    <div class="card-body py-3">
                                                        <p class="product-category mb-1">
                                                            <i class="ri-price-tag-3-line me-1"></i>
                                                            {{ $wishlist->producto->categoria->nombre ?? 'Sin categoría' }}
                                                        </p>
                                                        <h5 class="card-title mb-2">
                                                            <a href="{{ url('front.producto.show', $wishlist->producto->slug ?? $wishlist->producto->id) }}" 
                                                               class="text-decoration-none text-dark">
                                                                {{ $wishlist->producto->name }}
                                                            </a>
                                                        </h5>
                                                        
                                                        {{-- Rating --}}
                                                        <div class="product-rating mb-2">
                                                            @php
                                                                $rating = $wishlist->producto->rating ?? rand(3, 5);
                                                            @endphp
                                                            @for($i = 1; $i <= 5; $i++)
                                                                @if($i <= $rating)
                                                                    <i class="ri-star-fill"></i>
                                                                @else
                                                                    <i class="ri-star-line text-muted"></i>
                                                                @endif
                                                            @endfor
                                                            <span class="ms-1">({{ $wishlist->producto->reviews_count ?? rand(5, 50) }})</span>
                                                        </div>

                                                        <div class="d-flex align-items-center gap-2 flex-wrap">
                                                            <span class="price-text">{{ money($wishlist->producto->price) }}</span>
                                                            @if($wishlist->producto->precio_original && $wishlist->producto->precio_original > $wishlist->producto->price)
                                                                <span class="price-original">{{ money($wishlist->producto->precio_original) }}</span>
                                                            @endif
                                                            @if($wishlist->producto->precio_bs)
                                                                <span class="badge badge-soft-info">{{ $wishlist->producto->precio_bs }} Bs</span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-3 col-lg-3">
                                                    <div class="d-flex flex-column gap-2 p-3">
                                                        <button wire:click="addToCart({{ $wishlist->producto->id }})"
                                                                wire:loading.attr="disabled"
                                                                class="btn btn-primary btn-sm">
                                                            <span wire:loading.remove wire:target="addToCart({{ $wishlist->producto->id }})">
                                                                <i class="ri-shopping-cart-line me-1"></i>Añadir
                                                            </span>
                                                            <span wire:loading wire:target="addToCart({{ $wishlist->producto->id }})">
                                                                <span class="spinner-border spinner-border-sm"></span>
                                                            </span>
                                                        </button>
                                                        <a href="{{ url('front.producto.show', $wishlist->producto->slug ?? $wishlist->producto->id) }}" 
                                                           class="btn btn-soft-info btn-sm">
                                                            <i class="ri-eye-line me-1"></i>Ver
                                                        </a>
                                                        <button wire:click="removeFromWishlist({{ $wishlist->id }})"
                                                                wire:loading.attr="disabled"
                                                                class="btn btn-soft-danger btn-sm">
                                                            <span wire:loading.remove wire:target="removeFromWishlist({{ $wishlist->id }})">
                                                                <i class="ri-heart-fill me-1"></i>Quitar
                                                            </span>
                                                            <span wire:loading wire:target="removeFromWishlist({{ $wishlist->id }})">
                                                                <span class="spinner-border spinner-border-sm"></span>
                                                            </span>
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            @endif

                            {{-- Paginación --}}
                            <div class="d-flex justify-content-center mt-4">
                                {{ $wishlists->links('livewire.pagination') }}
                            </div>
                        @else
                            {{-- Empty state cuando hay filtro pero sin resultados --}}
                            <div class="card card-velzon border-0">
                                <div class="card-body">
                                    <div class="empty-state py-5">
                                        <div class="empty-state-icon mb-4">
                                            <i class="ri-filter-off-line"></i>
                                        </div>
                                        <h4 class="empty-state-title">No hay productos en esta categoría</h4>
                                        <p class="empty-state-text mb-4">No tienes productos favoritos en la categoría seleccionada.</p>
                                        <button wire:click="clearFilters" class="btn btn-primary rounded-pill">
                                            <i class="ri-refresh-line me-1"></i>Limpiar filtros
                                        </button>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            @else
                {{-- Empty State Mejorado --}}
                <div class="card card-velzon border-0">
                    <div class="card-body py-5">
                        <div class="text-center">
                            {{-- Ilustración SVG --}}
                            <div class="mb-4">
                                <svg width="200" height="200" viewBox="0 0 200 200" fill="none" xmlns="http://www.w3.org/2000/svg" class="mx-auto">
                                    <circle cx="100" cy="100" r="80" fill="#FEE2E2"/>
                                    <circle cx="100" cy="100" r="60" fill="#FECACA"/>
                                    <path d="M100 140C100 140 60 110 60 85C60 70 72 60 85 60C92 60 98 64 100 70C102 64 108 60 115 60C128 60 140 70 140 85C140 110 100 140 100 140Z" fill="#EF4444" stroke="#DC2626" stroke-width="3"/>
                                    <circle cx="80" cy="82" r="8" fill="#FCA5A5" opacity="0.6"/>
                                    <path d="M90 125L110 125" stroke="#DC2626" stroke-width="2" stroke-linecap="round" opacity="0.3"/>
                                    {{-- Sparkles --}}
                                    <circle cx="45" cy="60" r="4" fill="#FCD34D"/>
                                    <circle cx="155" cy="55" r="3" fill="#FCD34D"/>
                                    <circle cx="160" cy="140" r="5" fill="#FCD34D"/>
                                    <circle cx="35" cy="130" r="3" fill="#FCD34D"/>
                                    {{-- Stars --}}
                                    <path d="M50 90L52 85L54 90L59 92L54 94L52 99L50 94L45 92L50 90Z" fill="#FBBF24"/>
                                    <path d="M145 100L147 95L149 100L154 102L149 104L147 109L145 104L140 102L145 100Z" fill="#FBBF24"/>
                                </svg>
                            </div>
                            
                            <h3 class="fw-semibold mb-2">Tu lista de favoritos está vacía</h3>
                            <p class="text-muted mb-4 mx-auto" style="max-width: 400px;">
                                Guarda tus productos favoritos haciendo clic en el corazón <i class="ri-heart-line text-danger"></i> 
                                para encontrarlos fácilmente más tarde.
                            </p>
                            
                            <div class="d-flex justify-content-center gap-3 flex-wrap">
                                <a href="/" class="btn btn-primary rounded-pill px-4">
                                    <i class="ri-store-2-line me-2"></i>Explorar tienda
                                </a>
                                <a href="/tienda" class="btn btn-soft-primary rounded-pill px-4">
                                    <i class="ri-search-line me-2"></i>Buscar productos
                                </a>
                            </div>

                            {{-- Tips --}}
                            <div class="mt-5 pt-4 border-top">
                                <div class="row g-4 justify-content-center">
                                    <div class="col-md-4">
                                        <div class="d-flex align-items-start gap-3 text-start">
                                            <div class="flex-shrink-0">
                                                <div class="avatar-sm">
                                                    <div class="avatar-title bg-info-subtle text-info rounded-circle">
                                                        <i class="ri-heart-add-line"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h6 class="mb-1">Guarda tus favoritos</h6>
                                                <small class="text-muted">Haz clic en el corazón de cualquier producto</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="d-flex align-items-start gap-3 text-start">
                                            <div class="flex-shrink-0">
                                                <div class="avatar-sm">
                                                    <div class="avatar-title bg-success-subtle text-success rounded-circle">
                                                        <i class="ri-shopping-cart-2-line"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h6 class="mb-1">Compra fácil</h6>
                                                <small class="text-muted">Añade todos al carrito con un clic</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="d-flex align-items-start gap-3 text-start">
                                            <div class="flex-shrink-0">
                                                <div class="avatar-sm">
                                                    <div class="avatar-title bg-warning-subtle text-warning rounded-circle">
                                                        <i class="ri-notification-3-line"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            <div>
                                                <h6 class="mb-1">Recibe alertas</h6>
                                                <small class="text-muted">Te avisamos cuando bajen de precio</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>

    {{-- Estilos para animaciones --}}
    <style>
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .avatar-sm {
            width: 2.5rem;
            height: 2.5rem;
        }
        
        .avatar-title {
            width: 100%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1rem;
        }
        
        .bg-danger-subtle {
            background-color: rgba(240, 101, 72, 0.15) !important;
        }
        
        .bg-info-subtle {
            background-color: rgba(41, 156, 219, 0.15) !important;
        }
        
        .bg-success-subtle {
            background-color: rgba(10, 179, 156, 0.15) !important;
        }
        
        .bg-warning-subtle {
            background-color: rgba(247, 184, 75, 0.15) !important;
        }
    </style>
</div>
