<div>
    @section('styles')
    <link rel="stylesheet" href="/assets/vendor/css/pages/page-profile.css" />
    @endsection

    <div class="content-body">
        <div id="user-profile">
            @php
            $re = '/\b(\w)[^\s]*\s*/m';
            $str =\Auth::user()->name;
            $subst = '$1';
            $result = preg_replace($re, $subst, $str);
          @endphp
            <!-- profile header -->
            <div class="row">
                <div class="col-12">
                  <div class="card mb-6">
                    <div class="user-profile-header-banner">
                      <img src="/assets/img/pages/profile-banner.png" alt="Banner image" class="rounded-top" />
                    </div>
                    <div class="user-profile-header d-flex flex-column flex-lg-row text-sm-start text-center mb-5">
                      <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto">
                        <img
                          src="/assets/img/avatars/1.png"
                          alt="user image"
                          class="d-block h-auto ms-0 ms-sm-6 rounded user-profile-img" />
                      </div>
                      <div class="flex-grow-1 mt-3 mt-lg-5">
                        <div
                          class="d-flex align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-5 flex-md-row flex-column gap-4">
                          <div class="user-profile-info">
                            <h4 class="mb-2 mt-lg-6">{{ Auth::user()->name }}</h4>
                            <ul
                              class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-4 my-2">
                              <li class="list-inline-item d-flex gap-2 align-items-center">
                                <i class="ti ti-palette ti-lg"></iconify-icon><span class="fw-medium">{{ Auth::user()->role->name }}</span>
                              </li>
                              <li class="list-inline-item d-flex gap-2 align-items-center">
                                <i class="ti ti-calendar ti-lg"></iconify-icon><span class="fw-medium"> Creado {{ Auth::user()->created_at->diffForHumans() }}</span>
                              </li>
                            </ul>
                          </div>
                          <a href="/" class="btn btn-primary mb-1">
                            <i class="ti ti-user-check ti-xs me-2"></iconify-icon>Usuario Conectado
                          </a>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            <!--/ profile header -->

            <!-- profile info section -->
            <section id="profile-info">
                <div class="row">
                    <div class="col-xl-4 col-lg-5 col-md-5">
                        <!-- About User -->
                        <div class="card mb-6">
                          <div class="card-body">
                            <small class="card-text text-uppercase text-muted small">Datos sobre el usuario</small>
                            <ul class="list-unstyled my-3 py-1">
                              <li class="d-flex align-items-center mb-4">
                                <i class="ti ti-user ti-lg"></iconify-icon><span class="fw-medium mx-2">Nombre completo:</span>
                                <span>{{ Auth::user()->name }}</span>
                              </li>
                              <li class="d-flex align-items-center mb-4">
                                <i class="ti ti-check ti-lg"></iconify-icon><span class="fw-medium mx-2">Estado:</span>
                                <span class="badge bg-label-success">Activo</span>
                              </li>
                              <li class="d-flex align-items-center mb-4">
                                <i class="ti ti-crown ti-lg"></iconify-icon><span class="fw-medium mx-2">Role:</span>
                                <span>{{ Auth::user()->role->name }}</span>
                              </li>
                              <li class="d-flex align-items-center mb-2">
                                <i class="ti ti-language ti-lg"></iconify-icon><span class="fw-medium mx-2">Idioma:</span>
                                <span>Estañol</span>
                              </li>
                            </ul>
                            <small class="card-text text-uppercase text-muted small">Contacto</small>
                            <ul class="list-unstyled my-3 py-1">
                              <li class="d-flex align-items-center mb-4">
                                <i class="ti ti-phone-call ti-lg"></iconify-icon><span class="fw-medium mx-2">Teléfono:</span>
                                <span>{{ Auth::user()->telefono }}</span>
                              </li>
                              <li class="d-flex align-items-center mb-4">
                                <i class="ti ti-mail ti-lg"></iconify-icon><span class="fw-medium mx-2">Email:</span>
                                <span>john.doe@example.com</span>
                              </li>
                            </ul>

                          </div>
                        </div>
                        <!--/ About User -->
                        <!-- Profile Overview
                        <div class="card mb-6">
                          <div class="card-body">
                            <small class="card-text text-uppercase text-muted small">Overview</small>
                            <ul class="list-unstyled mb-0 mt-3 pt-1">
                              <li class="d-flex align-items-end mb-4">
                                <i class="ti ti-check ti-lg"></iconify-icon><span class="fw-medium mx-2">Task Compiled:</span>
                                <span>13.5k</span>
                              </li>
                              <li class="d-flex align-items-end mb-4">
                                <i class="ti ti-layout-grid ti-lg"></iconify-icon><span class="fw-medium mx-2">Projects Compiled:</span>
                                <span>146</span>
                              </li>
                              <li class="d-flex align-items-end">
                                <i class="ti ti-users ti-lg"></iconify-icon><span class="fw-medium mx-2">Connections:</span>
                                <span>897</span>
                              </li>
                            </ul>
                          </div>
                        </div>
                        <!--/ Profile Overview -->
                      </div>
                    <!-- center profile info section -->
                    <div class="col-lg-8 col-12 order-1 order-lg-2">
                        <!-- post 1 -->
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-start align-items-center mb-1">
                                    <div class="profile-user-info">
                                        <h6 class="mb-0">Histórico de sesión</h6>
                                        <small class="text-muted text-uppercase">{{  \Carbon\Carbon::parse(date('Y-m-d'))->formatLocalized(' %B ') }}</small>
                                    </div>
                                </div>
                                <div class="table-responsive">
                                    <table class="dt-fixedheader table dataTable dtr-column" id="DataTables_Table_1 table-sm" aria-describedby="DataTables_Table_1_info" style="width: 1396px;">
                                        <thead>
                                            <tr>
                                                <th class="control sorting_disabled dtr-hidden" rowspan="1" colspan="1" style="width: 0px; display: none;" aria-label=""></th>
                                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_1" rowspan="1" colspan="1" style="width: 3px;" aria-label="Name: activate to sort column ascending">id</th>
                                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_1" rowspan="1" colspan="1" style="width: 10px;" aria-label="Name: activate to sort column ascending">Ciudad</th>
                                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_1" rowspan="1" colspan="1" style="width: 180px;" aria-label="Email: activate to sort column ascending">Usuario</th>
                                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_1" rowspan="1" colspan="1" style="width: 306.625px;" aria-label="Date: activate to sort column ascending">Agente</th>
                                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_1" rowspan="1" colspan="1" style="width: 104.609px;" aria-label="Salary: activate to sort column ascending">Mes</th>
                                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_1" rowspan="1" colspan="1" style="width: 126.562px;" aria-label="Status: activate to sort column ascending">Direccion ip</th>
                                                <th class="sorting" tabindex="0" aria-controls="DataTables_Table_1" rowspan="1" colspan="1" style="width: 126.562px;" aria-label="Status: activate to sort column ascending">INGRESO</th>
                                                <th class="sorting_disabled" rowspan="1" colspan="1" style="width: 102.562px;" aria-label="SALIDA">SALIDA</th></tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $logins = \App\Models\Login::where('user_id',\Auth::id())->orderBy('id','DESC')->get()
                                                @endphp
                                                @foreach ($logins as $item)
                                                <tr class="odd small">
                                                    <td class="" style=""> {{ $loop->iteration }}</td>
                                                    <td class="" style=""> {{ $item->ciudad }}</td>
                                                    <td class="" style=""> {{ $item->user->name }}</td>
                                                    <td class="" style=""> {{ $item->user_agent }}</td>
                                                    <td class="" style=""> {{ $item->mes }}</td>
                                                    <td class="" style=""> {{ $item->ip_address }}</td>
                                                    <td class="" style=""> {{ $item->login_at }}</td>
                                                    <td class="" style=""> {{ $item->logout_at }}</td>

                                                </tr>
                                                @endforeach
                                            </tbody>

                                        </table>
                                </div>
                            </div>
                        </div>
                    </div>
               </div>
            </section>
        </div>
    </div>
</div>
