@extends('layouts.front.app')

@section('content')
<div class="container mt-5">
    <h1>Prueba de QuickView</h1>
    
    <div class="row">
        <div class="col-md-4 mb-4">
            <div class="card">
                <img src="https://via.placeholder.com/300x200" class="card-img-top" alt="Producto 1">
                <div class="card-body">
                    <h5 class="card-title">Producto de Prueba 1</h5>
                    <p class="card-text">$10.00</p>
                    <button onclick="openQuickView(1)" class="btn btn-primary">Ver QuickView</button>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4">
            <div class="card">
                <img src="https://via.placeholder.com/300x200" class="card-img-top" alt="Producto 2">
                <div class="card-body">
                    <h5 class="card-title">Producto de Prueba 2</h5>
                    <p class="card-text">$20.00</p>
                    <button onclick="openQuickView(2)" class="btn btn-primary">Ver QuickView</button>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4">
            <div class="card">
                <img src="https://via.placeholder.com/300x200" class="card-img-top" alt="Producto 3">
                <div class="card-body">
                    <h5 class="card-title">Producto de Prueba 3</h5>
                    <p class="card-text">$30.00</p>
                    <button onclick="openQuickView(3)" class="btn btn-primary">Ver QuickView</button>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-12">
            <h3>Consola de Debug</h3>
            <button onclick="debugQuickView()" class="btn btn-warning mb-2">Debug QuickView</button>
            <button onclick="clearConsole()" class="btn btn-secondary mb-2">Limpiar Consola</button>
            <div id="debug-info" class="alert alert-info" style="display: none;">
                <strong>Información de Debug:</strong>
                <div id="debug-content"></div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-12">
            <h4>Instrucciones de Prueba:</h4>
            <ol>
                <li>Abre la consola del navegador (F12)</li>
                <li>Haz clic en "Ver QuickView" en cualquier producto</li>
                <li>Verifica que las imágenes se carguen correctamente</li>
                <li>Prueba seleccionar diferentes variantes (si tiene)</li>
                <li>Prueba seleccionar productos relacionados</li>
                <li>Verifica que las imágenes cambien con transición suave</li>
                <li>Usa el botón "Debug QuickView" para ver información</li>
            </ol>
        </div>
    </div>
</div>

@livewire('front.quick-view')

<script>
    function openQuickView(productId) {
        console.log('Abriendo QuickView para producto:', productId);
        
        // Disparar evento para abrir el QuickView
        Livewire.dispatch('openQuickView', { productId: productId });
        
        // Mostrar información de debug
        document.getElementById('debug-info').style.display = 'block';
        document.getElementById('debug-content').innerHTML = `
            <p>Producto ID: ${productId}</p>
            <p>Evento openQuickView disparado</p>
            <p>Verifica la consola para más detalles...</p>
        `;
    }
    
    function clearConsole() {
        console.clear();
        document.getElementById('debug-content').innerHTML = '<p>Consola limpiada</p>';
    }
    
    // Función mejorada de debug
    function debugQuickView() {
        if (typeof window.debugQuickView === 'function') {
            window.debugQuickView();
        } else {
            console.log('Función debugQuickView no disponible');
            
            // Debug básico
            const modal = document.querySelector('.quick-view-modal');
            const mainElement = document.querySelector('.product-gallery-main');
            const thumbsElement = document.querySelector('.product-gallery-thumbs');
            
            console.log('=== DEBUG BÁSICO ===');
            console.log('Modal:', modal);
            console.log('Main element:', mainElement);
            console.log('Thumbs element:', thumbsElement);
            
            if (modal) {
                console.log('Modal visible:', modal.style.display === 'block');
            }
            
            if (mainElement) {
                console.log('Slides principales:', mainElement.querySelectorAll('.swiper-slide').length);
            }
            
            if (thumbsElement) {
                console.log('Slides thumbs:', thumbsElement.querySelectorAll('.swiper-slide').length);
            }
        }
        
        document.getElementById('debug-content').innerHTML = '<p>Debug ejecutado - revisa la consola</p>';
    }
</script>
@endsection