<div>
    <div>
    <div class="position-relative">
        <input type="text" 
               class="form-control search-input bg-light border-0 rounded-pill" 
               placeholder="Buscar productos..." 
               id="searchInput"
               wire:model.debounce.300ms="search"
               wire:focus="$set('showResults', true)"
               wire:blur="$set('showResults', false)"
               autocomplete="off">
        <span class="search-icon position-absolute top-50 translate-middle-y start-0 ms-3">
            <i class="ri-search-line text-muted"></i>
        </span>
        <kbd class="position-absolute top-50 translate-middle-y end-0 me-3 d-none d-sm-block">
            <span class="text-muted" style="font-size: 10px;">Ctrl+K</span>
        </kbd>
    </div>

    <!-- Search Dropdown -->
    @if($showResults && strlen($search) >= 2)
    <div class="search-dropdown dropdown-menu-lg p-3 shadow-lg rounded-3 border-0 show" 
         style="position: absolute; width: 350px; max-height: 400px; overflow-y: auto; z-index: 1050; background: #fff; display: block;">
        
        @if($isSearching)
            <div class="text-center py-3">
                <div class="spinner-border spinner-border-sm text-primary" role="status">
                    <span class="visually-hidden">Buscando...</span>
                </div>
                <p class="mb-0 mt-2 text-muted small">Buscando "{{ $search }}"...</p>
            </div>
        @elseif(count($results) > 0)
            <div class="search-results">
                <h6 class="text-muted text-uppercase fs-11 mb-3">
                    <i class="ri-search-line me-1"></i>Resultados de búsqueda
                </h6>
                
                @foreach($results as $product)
                <div class="search-result-item mb-2">
                    <a href="{{ url('/front/product/' . $product->id) }}" 
                       class="d-flex align-items-center p-2 rounded hover-bg-light text-decoration-none text-body">
                        <div class="me-3">
                            @if($product->imagen)
                                <img src="{{ asset('storage/' . $product->imagen) }}" 
                                     alt="{{ $product->nombre }}" 
                                     class="rounded" 
                                     style="width: 40px; height: 40px; object-fit: cover;">
                            @else
                                <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                     style="width: 40px; height: 40px;">
                                    <i class="ri-image-line text-muted"></i>
                                </div>
                            @endif
                        </div>
                        <div class="flex-grow-1">
                            <h6 class="mb-0 fs-14 fw-medium">{{ $product->nombre }}</h6>
                            <p class="mb-0 text-muted fs-12">
                                <small>Código: {{ $product->codigo }}</small>
                            </p>
                            <div class="d-flex align-items-center justify-content-between">
                                <span class="text-primary fw-semibold fs-13">
                                    S/ {{ number_format($product->precio_venta, 2, '.', ',') }}
                                </span>
                                @if($product->stock > 0)
                                    <span class="badge bg-success fs-10">Stock: {{ $product->stock }}</span>
                                @endif
                            </div>
                        </div>
                    </a>
                </div>
                @endforeach
                
                @if(count($results) == 8)
                <div class="text-center mt-3 pt-3 border-top">
                    <a href="{{ url('/front/products?search=' . $search) }}" class="btn btn-sm btn-primary">
                        <i class="ri-search-line me-1"></i>Ver todos los resultados
                    </a>
                </div>
                @endif
            </div>
        @else
            <div class="text-center py-4">
                <i class="ri-search-line text-muted fs-22 mb-2 d-block"></i>
                <p class="text-muted mb-0">No se encontraron productos para "{{ $search }}"</p>
                <small class="text-muted">Intenta con otro término de búsqueda</small>
            </div>
        @endif
    </div>
    @endif
</div>

<style>
.search-result-item:hover {
    background-color: #f8f9fa !important;
}
.hover-bg-light:hover {
    background-color: #f8f9fa !important;
}
.cursor-pointer {
    cursor: pointer;
}
</style>
</div>