<!-- left offcanvas -->
<div wire:ignore.self class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasLeft"
    aria-labelledby="offcanvasLeftLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasLeftLabel">Inicio de sesión</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div>
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div class=" mt-4 card-bg-fill">

                    <div class=" p-4">
                        <div class="text-center mt-2">
                            <h5 class="text-primary">¡Bienvenidos a nuestra tienda!</h5>
                            <p class="text-muted">Ingresa tus credenciales para comprar.</p>
                        </div>
                        <div class="p-2 mt-4">
                            <form wire:submit.prevent='loginUser'>

                                <div class="mb-3">
                                    <label for="username" class="form-label">Usuario</label>
                                    <input type="text" class="form-control  @error('username') is-invalid @enderror"
                                        id="username" wire:model="username" placeholder="Introduce tu usuario" />
                                    @error('username')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>

                                <div class="mb-3">

                                    <label for="login-password" class="form-label">Contraseña</label>
                                    <input type="password" class="form-control  @error('password') is-invalid @enderror"
                                        id="login-password" wire:model="password" placeholder="Introduce tu contraseña" />
                                    @error('password')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>

                                <div class="mt-4">
                                    <button class="btn btn-success w-100" type="submit">Ingresar</button>
                                </div>

                                <div class="mt-3 text-center">
                                    <a href="#" data-bs-toggle="offcanvas" data-bs-target="#offcanvasForgotPassword"
                                       class="text-muted text-decoration-underline">
                                        ¿Olvidaste tu contraseña?
                                    </a>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- end card body -->
                </div>
                <!-- end card -->

                <div class="mt-4 text-center">
                    <p class="mb-0">¿Aún no tienes cuenta? <a href="#" data-bs-toggle="offcanvas"
                            data-bs-target="#offcanvasRight" aria-controls="offcanvasRight"
                            class="fw-semibold text-primary text-decoration-underline"> Regístrate </a> </p>
                </div>

            </div>
        </div>
        <!-- end row -->
    </div>
</div>


<!-- left offcanvas -->
<div wire:ignore.self class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight"
    aria-labelledby="offcanvasRightLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasRightLabel">Registro de usuario</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div class="mt-4 card-bg-fill">

                    <div class="p-4">

                        <div class="p-2 mt-4">
                            <form class="needs-validation" wire:submit.prevent='storeUser'>

                                <div class="mb-3">
                                    <label for="register-name" class="form-label">Nombre completo</label>
                                    <input type="text" class="form-control  @error('name') is-invalid @enderror"
                                        id="register-name" wire:model="name" placeholder="Introduce tu nombre" />
                                    @error('name')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="register-email" class="form-label">Correo electrónico</label>
                                    <input type="text" class="form-control  @error('email') is-invalid @enderror"
                                        id="register-email" wire:model="email" placeholder="Introduce tu correo electrónico" />
                                    @error('email')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="register-username" class="form-label">Usuario</label>
                                    <input type="text" class="form-control  @error('username') is-invalid @enderror"
                                        id="register-username" wire:model="username" placeholder="Introduce tu usuario" />
                                    @error('username')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="telefono" class="form-label">Teléfono</label>
                                    <input type="phone" class="form-control  @error('telefono') is-invalid @enderror"
                                        id="telefono" wire:model="telefono" placeholder="Introduce tu N° telefónico" />
                                    @error('telefono')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="register-password" class="form-label">Contraseña</label>
                                    <input type="password" class="form-control  @error('password') is-invalid @enderror"
                                        id="register-password" wire:model="password" placeholder="****************" />
                                    @error('password')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>



                                <div class="p-3 bg-warning mb-2 rounded">
                                    <h5 class="fs-13">La contraseña debe contener:</h5>
                                    <p id="pass-length" class="invalid fs-12 mb-2 badge bg-warning">Mínimo <b>8
                                            caractéres</b></p>
                                </div>
                                <div class="mb-3">
                                    <label for="register-password-confirmation" class="form-label">Confirmación de contraseña</label>
                                    <input type="password"
                                        class="form-control  @error('password_confirmation') is-invalid @enderror"
                                        id="register-password-confirmation" wire:model="password_confirmation"
                                        placeholder="****************" />
                                    @error('password_confirmation')
                                        <p class='text-danger small inputerror'>{{ $message }} </p>
                                    @enderror
                                </div>
                                <div class="mt-4">
                                    <button class="btn btn-success w-100" type="submit" @if($isRegistering) disabled @endif>
                                        @if($isRegistering)
                                            <span class="spinner-border spinner-border-sm me-2" role="status" aria-hidden="true"></span>
                                            Registrando...
                                        @else
                                            Registrarse
                                        @endif
                                    </button>
                                </div>


                            </form>

                        </div>
                    </div>
                    <!-- end card body -->
                </div>
                <!-- end card -->


            </div>
        </div>
    </div>
</div>
<div wire:ignore.self class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRightWishLists"
    aria-labelledby="offcanvasRightWishListsLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasRightWishListsLabel">Productos Favoritos</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12 col-xl-12">
                <div class="mt-4 card-bg-fill">

                    <div class="p-4">

                        <div class="p-2 mt-4">

                            <div class="row">

                                @foreach ($wishlists as $product)
                                    <div class="col-lg-12 product-product artwork crypto-card 3d-style">
                                        <div class="card explore-box card-animate">
                                            <div class="bookmark-icon position-absolute top-0 end-0 p-2">

                                            </div>
                                            <div class="explore-place-bid-img">
                                                <img src="/media/producto/{{ $product->producto->image->path }}"
                                                    alt="" class="card-img-top explore-img" height="10" />
                                                <div class="bg-overlay"></div>
                                            </div>
                                            <div class="card-body">
                                                <h5 class="text-muted mb-0 float-end">
                                                    {{ money($product->producto->price) }}</h5>
                                                <h5 class="mb-1"><a>{{ $product->producto->name }}</a></h5>
                                                <p class="text-muted mb-0">{{ $product->producto->categoria->name }}
                                                </p>

                                            </div>
                                            <div class="card-footer border-top border-top-dashed">
                                                @if (Auth::check())
                                                    <div class="d-flex align-items-center">
                                                        <div class="flex-grow-1 fs-14">
                                                            @if (DB::table('wishlists')->where('producto_id', $product->producto->id)->where('user_id', Auth::user()->id)->first() != null)
                                                                <a wire:click='removeWishlist({{ $product->producto->id }})'
                                                                    class="btn btn-icon btn-danger mb-0">
                                                                    <span class=" ri-delete-bin-line text-white "></span>


                                                                </a>
                                                            @else
                                                                <a wire:click='addWishlist({{ $product->producto->id }})'
                                                                    class="btn btn-icon btn-success mb-0">
                                                                    <span
                                                                        class=" ri-heart-line-outline text-white "></span>


                                                                </a>
                                                            @endif
                                                        </div>
                                                        <a wire:click='addCart({{ $product->producto->id }})'
                                                            class="btn btn-icon btn-primary mb-0">
                                                            <span class=" ri-circle-fill text-white "></span>
                                                        </a>
                                                    </div>
                                                @else
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                    <!-- end card body -->
                </div>

            </div>
        </div>
    </div>
</div>

<!-- Forgot Password Modal -->
<div wire:ignore.self class="offcanvas offcanvas-start" tabindex="-1" id="offcanvasForgotPassword"
    aria-labelledby="offcanvasForgotPasswordLabel">
    <div class="offcanvas-header">
        <h5 id="offcanvasForgotPasswordLabel">Recuperar Contraseña</h5>
        <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="mt-4 card-bg-fill">
                <div class="p-4">
                    <div class="text-center mt-2">
                        <h5 class="text-primary">¡Recupera tu contraseña!</h5>
                        <p class="text-muted">Ingresa tu número de teléfono para recibir una nueva contraseña por WhatsApp.</p>
                    </div>

                    @if($resetMessage)
                        <div class="alert alert-success" role="alert">
                            {{ $resetMessage }}
                        </div>
                    @endif

                    @if($resetError)
                        <div class="alert alert-danger" role="alert">
                            {{ $resetError }}
                        </div>
                    @endif

                    <div class="p-2 mt-4">
                        <form wire:submit.prevent='sendPasswordResetCode'>
                            <div class="mb-3">
                                <label for="forgotEmail" class="form-label">Número de Teléfono</label>
                                <input type="tel" class="form-control @error('forgotEmail') is-invalid @enderror"
                                    id="forgotEmail" wire:model="forgotEmail" placeholder="Introduce tu número de teléfono" />
                                @error('forgotEmail')
                                    <p class='text-danger small inputerror'>{{ $message }}</p>
                                @enderror
                            </div>

                            <div class="mt-4">
                                <button class="btn btn-primary w-100" type="submit">Enviar Nueva Contraseña</button>
                            </div>
                        </form>

                        <div class="mt-3 text-center">
                            <a href="#" data-bs-toggle="offcanvas" data-bs-target="#offcanvasLeft"
                               class="text-muted text-decoration-underline">
                                Volver al inicio de sesión
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick View Modal -->
<livewire:front.quick-view />

