<div class="card sticky-top shadow-sm border-0 rounded-3">
    <div class="card-header bg-primary text-white rounded-top-3">
        <h5 class="mb-0 text-white">Resumen del Pedido</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-borderless mb-0">
                <tbody>
                    <tr>
                        <td>Subtotal:</td>
                        <td class="text-end">{{ format_money($cartTotal) }}</td>
                    </tr>
                    
                    @if(is_venezuela_company())
                    <tr>
                        <td>Tasa del día:</td>
                        <td class="text-end">
                            @if(tasa())
                                {{ number_format(tasa()->usd_rate, 2) }} Bs/$
                            @else
                                No disponible
                            @endif
                        </td>
                    </tr>
                    @endif
                    
                    <tr>
                        <td>Impuestos:</td>
                        <td class="text-end">0.00</td>
                    </tr>
                    <tr class="border-top">
                        <th>Total:</th>
                        <td class="text-end">
                            <strong>{{ format_money($cartTotal) }}</strong>
                        </td>
                    </tr>
                    
                    @if(is_venezuela_company())
                    <tr class="border-bottom">
                        <th>Total (Bs):</th>
                        <td class="text-end">
                            <strong>
                                @if(tasa())
                                    {{ number_format($cartTotal * tasa()->usd_rate, 2) }} Bs
                                @else
                                    Tasa no disponible
                                @endif
                            </strong>
                        </td>
                    </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <div class="mt-4">
            <h6 class="mb-3">Productos en el carrito</h6>
            <div class="order-summary-scroll">
                @foreach($cartItems as $item)
                <div class="d-flex mb-3 pb-3 border-bottom">
                    <div class="flex-shrink-0">
                        @if($item->associatedModel && $item->associatedModel->images && $item->associatedModel->images->first())
                            <img src="{{ asset('app/'.$item->associatedModel->images->first()->path) }}" 
                                 alt="{{ $item->name }}" 
                                 class="img-fluid rounded" 
                                 style="width: 50px; height: 50px; object-fit: cover;">
                        @else
                            <div class="bg-light rounded d-flex align-items-center justify-content-center" 
                                 style="width: 50px; height: 50px;">
                                <i class="ri-image-line text-muted"></i>
                            </div>
                        @endif
                    </div>
                    <div class="flex-grow-1 ms-3">
                        <h6 class="mb-1 small">{{ Str::limit($item->name, 30) }}</h6>
                        <p class="mb-1 small">Cantidad: {{ $item->quantity }}</p>
                        <p class="mb-0 text-primary small">{{ format_money($item->price * $item->quantity) }}</p>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</div>