<div>
    @section('title', 'Carrito de Compras')

    @push('styles')
    <style>
        .cart-page {
            min-height: 70vh;
        }

        .cart-items-container {
            max-height: 600px;
            overflow-y: auto;
            padding-right: 8px;
        }

        .cart-items-container::-webkit-scrollbar {
            width: 6px;
        }

        .cart-items-container::-webkit-scrollbar-track {
            background: var(--velzon-gray-100);
            border-radius: 3px;
        }

        .cart-items-container::-webkit-scrollbar-thumb {
            background: var(--velzon-gray-400);
            border-radius: 3px;
        }

        .cart-items-container::-webkit-scrollbar-thumb:hover {
            background: var(--velzon-gray-500);
        }

        .cart-item-card {
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-xl);
            border: 1px solid var(--velzon-gray-200);
            transition: all var(--velzon-transition);
            overflow: hidden;
        }

        .cart-item-card:hover {
            border-color: var(--velzon-primary);
            box-shadow: var(--velzon-shadow-soft);
            transform: translateY(-2px);
        }

        .cart-item-img {
            width: 100px;
            height: 100px;
            object-fit: cover;
            border-radius: var(--velzon-radius-lg);
            transition: transform var(--velzon-transition);
        }

        .cart-item-card:hover .cart-item-img {
            transform: scale(1.05);
        }

        .cart-item-placeholder {
            width: 100px;
            height: 100px;
            background: var(--velzon-gray-100);
            border-radius: var(--velzon-radius-lg);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .qty-selector-velzon {
            display: inline-flex;
            align-items: center;
            border: 1px solid var(--velzon-gray-300);
            border-radius: var(--velzon-radius-lg);
            overflow: hidden;
            background: var(--velzon-white);
        }

        .qty-selector-velzon .qty-btn {
            width: 36px;
            height: 36px;
            border: none;
            background: var(--velzon-gray-100);
            color: var(--velzon-gray-700);
            cursor: pointer;
            transition: all var(--velzon-transition-fast);
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .qty-selector-velzon .qty-btn:hover:not(:disabled) {
            background: var(--velzon-primary);
            color: var(--velzon-white);
        }

        .qty-selector-velzon .qty-btn:disabled {
            opacity: 0.5;
            cursor: not-allowed;
        }

        .qty-selector-velzon .qty-input {
            width: 50px;
            height: 36px;
            border: none;
            text-align: center;
            font-weight: 600;
            font-size: 0.9375rem;
            background: transparent;
        }

        .summary-card {
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-xl);
            border: 1px solid var(--velzon-gray-200);
            overflow: hidden;
        }

        .summary-header {
            background: linear-gradient(135deg, var(--velzon-primary) 0%, #5c6cb2 100%);
            color: var(--velzon-white);
            padding: 1.25rem;
        }

        .free-shipping-progress {
            background: var(--velzon-gray-100);
            border-radius: var(--velzon-radius-lg);
            padding: 1rem;
            margin-bottom: 1rem;
        }

        .progress-velzon {
            height: 8px;
            background: var(--velzon-gray-200);
            border-radius: 4px;
            overflow: hidden;
        }

        .progress-velzon .progress-bar {
            background: linear-gradient(90deg, var(--velzon-success) 0%, #2dd4bf 100%);
            border-radius: 4px;
            transition: width var(--velzon-transition);
        }

        .checkout-timeline {
            display: flex;
            justify-content: space-between;
            padding: 1rem 0;
            position: relative;
        }

        .checkout-timeline::before {
            content: '';
            position: absolute;
            top: 28px;
            left: 20%;
            right: 20%;
            height: 2px;
            background: var(--velzon-gray-200);
        }

        .timeline-step {
            display: flex;
            flex-direction: column;
            align-items: center;
            z-index: 1;
        }

        .timeline-step .step-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-bottom: 0.5rem;
            transition: all var(--velzon-transition);
        }

        .timeline-step.active .step-icon {
            background: var(--velzon-primary);
            color: var(--velzon-white);
            box-shadow: 0 4px 12px rgba(var(--velzon-primary-rgb), 0.35);
        }

        .timeline-step.completed .step-icon {
            background: var(--velzon-success);
            color: var(--velzon-white);
        }

        .timeline-step.pending .step-icon {
            background: var(--velzon-gray-200);
            color: var(--velzon-gray-500);
        }

        .timeline-step .step-label {
            font-size: 0.75rem;
            color: var(--velzon-gray-600);
            font-weight: 500;
        }

        .coupon-input-group {
            position: relative;
        }

        .coupon-input-group .form-control {
            padding-right: 100px;
            border-radius: var(--velzon-radius-lg);
            border: 2px dashed var(--velzon-gray-300);
            transition: all var(--velzon-transition-fast);
        }

        .coupon-input-group .form-control:focus {
            border-color: var(--velzon-primary);
            border-style: solid;
            box-shadow: 0 0 0 3px rgba(var(--velzon-primary-rgb), 0.1);
        }

        .coupon-input-group .btn-apply {
            position: absolute;
            right: 4px;
            top: 4px;
            bottom: 4px;
            border-radius: var(--velzon-radius);
        }

        .coupon-success {
            background: rgba(var(--velzon-success-rgb), 0.1);
            border: 1px solid var(--velzon-success);
            border-radius: var(--velzon-radius-lg);
            padding: 0.75rem 1rem;
        }

        .guarantee-item {
            display: flex;
            align-items: flex-start;
            padding: 0.75rem;
            border-radius: var(--velzon-radius);
            transition: background var(--velzon-transition-fast);
        }

        .guarantee-item:hover {
            background: var(--velzon-gray-50);
        }

        .guarantee-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 0.75rem;
            flex-shrink: 0;
        }

        .empty-cart-illustration {
            width: 200px;
            height: 200px;
            margin: 0 auto 2rem;
            background: linear-gradient(135deg, var(--velzon-gray-100) 0%, var(--velzon-gray-200) 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            position: relative;
            animation: float 3s ease-in-out infinite;
        }

        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }

        .empty-cart-illustration::after {
            content: '';
            position: absolute;
            bottom: -20px;
            left: 50%;
            transform: translateX(-50%);
            width: 100px;
            height: 10px;
            background: var(--velzon-gray-200);
            border-radius: 50%;
            animation: shadow 3s ease-in-out infinite;
        }

        @keyframes shadow {
            0%, 100% { transform: translateX(-50%) scale(1); opacity: 0.3; }
            50% { transform: translateX(-50%) scale(0.8); opacity: 0.2; }
        }

        .suggested-products {
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-xl);
            padding: 1.5rem;
            margin-top: 2rem;
        }

        .suggested-product-card {
            background: var(--velzon-gray-50);
            border-radius: var(--velzon-radius-lg);
            padding: 1rem;
            transition: all var(--velzon-transition);
            cursor: pointer;
        }

        .suggested-product-card:hover {
            background: var(--velzon-white);
            box-shadow: var(--velzon-shadow);
            transform: translateY(-4px);
        }

        .breadcrumb-velzon {
            background: transparent;
            padding: 0;
            margin: 0;
        }

        .breadcrumb-velzon .breadcrumb-item + .breadcrumb-item::before {
            content: "\ea6e";
            font-family: 'remixicon';
            color: var(--velzon-gray-400);
        }

        .breadcrumb-velzon .breadcrumb-item a {
            color: var(--velzon-gray-600);
            text-decoration: none;
            transition: color var(--velzon-transition-fast);
        }

        .breadcrumb-velzon .breadcrumb-item a:hover {
            color: var(--velzon-primary);
        }

        .stats-badge {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.5rem 1rem;
            background: var(--velzon-white);
            border-radius: var(--velzon-radius-lg);
            box-shadow: var(--velzon-shadow-sm);
        }

        .btn-remove-item {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            background: rgba(var(--velzon-danger-rgb), 0.1);
            color: var(--velzon-danger);
            border: none;
            transition: all var(--velzon-transition-fast);
        }

        .btn-remove-item:hover {
            background: var(--velzon-danger);
            color: var(--velzon-white);
            transform: scale(1.1);
        }

        .loading-overlay {
            position: absolute;
            inset: 0;
            background: rgba(255,255,255,0.8);
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: var(--velzon-radius-xl);
            z-index: 10;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .cart-item-card {
            animation: fadeIn 0.3s ease-out;
        }
    </style>
    @endpush

    <section class="section cart-page" style="background: var(--velzon-gray-100); padding-top: 2rem; padding-bottom: 3rem;">
        <div class="container">
            <!-- Breadcrumb & Header -->
            <div class="row mb-4">
                <div class="col-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb breadcrumb-velzon mb-3">
                            <li class="breadcrumb-item"><a href="/"><i class="ri-home-4-line me-1"></i>Inicio</a></li>
                            <li class="breadcrumb-item"><a href="/front/products">Tienda</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Carrito</li>
                        </ol>
                    </nav>

                    <div class="d-flex flex-wrap justify-content-between align-items-center gap-3">
                        <div>
                            <h2 class="mb-1" style="color: var(--velzon-gray-800); font-weight: 600;">
                                <i class="ri-shopping-cart-2-line me-2 text-velzon-primary"></i>
                                Carrito de Compras
                            </h2>
                            <p class="text-muted mb-0">Revisa tus productos antes de continuar</p>
                        </div>

                        @if($cartItems->count() > 0)
                            <div class="d-flex flex-wrap gap-2 align-items-center">
                                <div class="stats-badge">
                                    <i class="ri-shopping-bag-3-line text-velzon-primary"></i>
                                    <span class="fw-semibold">{{ $cartCount }}</span>
                                    <span class="text-muted">{{ $cartCount == 1 ? 'producto' : 'productos' }}</span>
                                </div>

                                <a href="/" class="btn btn-soft-primary rounded-pill">
                                    <i class="ri-arrow-left-line me-1"></i>
                                    Seguir comprando
                                </a>
                                <button wire:click="clearCart"
                                        class="btn btn-soft-danger rounded-pill"
                                        wire:confirm="¿Estás seguro de que quieres vaciar el carrito?">
                                    <i class="ri-delete-bin-2-line me-1"></i>
                                    Vaciar
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            @if($cartItems->count() > 0)
                <div class="row">
                    <!-- Cart Items -->
                    <div class="col-lg-8 mb-4 mb-lg-0">
                        <!-- Free Shipping Progress -->
                        @php
                            $freeShippingThreshold = 50; // USD
                            $remainingForFreeShipping = max(0, $freeShippingThreshold - $cartTotal);
                            $shippingProgress = min(100, ($cartTotal / $freeShippingThreshold) * 100);
                        @endphp

                        <div class="free-shipping-progress mb-4">
                            <div class="d-flex align-items-center justify-content-between mb-2">
                                <div class="d-flex align-items-center">
                                    <i class="ri-truck-line fs-5 me-2 {{ $remainingForFreeShipping == 0 ? 'text-velzon-success' : 'text-velzon-warning' }}"></i>
                                    @if($remainingForFreeShipping == 0)
                                        <span class="fw-semibold text-velzon-success">¡Tienes envío gratis!</span>
                                    @else
                                        <span class="text-muted">
                                            Agrega <strong class="text-velzon-primary">{{ format_money($remainingForFreeShipping) }}</strong> más para envío gratis
                                        </span>
                                    @endif
                                </div>
                                <span class="badge badge-soft-{{ $remainingForFreeShipping == 0 ? 'success' : 'warning' }}">
                                    {{ number_format($shippingProgress, 0) }}%
                                </span>
                            </div>
                            <div class="progress-velzon">
                                <div class="progress-bar" style="width: {{ $shippingProgress }}%"></div>
                            </div>
                        </div>

                        <!-- Cart Items List -->
                        <div class="cart-items-container">
                            @foreach($cartItems as $item)
                                <div class="cart-item-card mb-3 position-relative" wire:key="cart-item-{{ $item->id }}-{{ $loop->index }}">
                                    <div class="p-3">
                                        <div class="row align-items-center g-3">
                                            <!-- Product Image -->
                                            <div class="col-auto">
                                                @php
                                                    $imageToShow = null;
                                                    if (isset($item->attributes['variant_id']) && $item->attributes['variant_id']) {
                                                        $variant = $item->associatedModel->variants->find($item->attributes['variant_id']);
                                                        if ($variant && $variant->image_path) {
                                                            $imageToShow = $variant->image_path;
                                                        } elseif ($variant && $variant->image_thumbnail_path) {
                                                            $imageToShow = $variant->image_thumbnail_path;
                                                        }
                                                    }
                                                    if (!$imageToShow && $item->associatedModel && $item->associatedModel->images && $item->associatedModel->images->first()) {
                                                        $imageToShow = $item->associatedModel->images->first()->path;
                                                    }
                                                @endphp

                                                @if($imageToShow)
                                                    <img src="{{ asset('app/' . $imageToShow) }}"
                                                         alt="{{ $item->name }}"
                                                         class="cart-item-img">
                                                @else
                                                    <div class="cart-item-placeholder">
                                                        <i class="ri-image-line fs-3 text-muted"></i>
                                                    </div>
                                                @endif
                                            </div>

                                            <!-- Product Info -->
                                            <div class="col">
                                                <div class="d-flex justify-content-between align-items-start">
                                                    <div>
                                                        <span class="badge badge-soft-secondary mb-2">
                                                            <i class="ri-price-tag-3-line me-1"></i>
                                                            {{ $item->associatedModel->categoria->nombre ?? 'Sin categoría' }}
                                                        </span>
                                                        <h6 class="mb-1 fw-semibold" style="color: var(--velzon-gray-800);">
                                                            {{ $item->name }}
                                                        </h6>

                                                        @if(isset($item->attributes['variant_name']) && $item->attributes['variant_name'])
                                                            <p class="text-muted small mb-2">
                                                                <i class="ri-checkbox-circle-line me-1"></i>
                                                                {{ $item->attributes['variant_name'] }}
                                                            </p>
                                                        @endif

                                                        <span class="badge badge-soft-{{ $item->associatedModel->status == 1 ? 'success' : 'danger' }}">
                                                            <i class="ri-{{ $item->associatedModel->status == 1 ? 'check' : 'close' }}-line me-1"></i>
                                                            {{ $item->associatedModel->status == 1 ? 'Disponible' : 'No disponible' }}
                                                        </span>
                                                    </div>

                                                    <button wire:click="$dispatch('openQuickView', { productId: {{ $item->associatedModel->id }}, cartItemId: '{{ $item->id }}' })"
                                                            class="btn btn-soft-info btn-icon btn-icon-sm rounded-circle"
                                                            data-bs-toggle="modal"
                                                            data-bs-target="#quickViewModal"
                                                            title="Vista rápida">
                                                        <i class="ri-eye-line"></i>
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Quantity Selector -->
                                            <div class="col-auto">
                                                <label class="form-label small text-muted mb-1">Cantidad</label>
                                                <div class="qty-selector-velzon">
                                                    <button class="qty-btn" type="button"
                                                            wire:click="decreaseQuantity('{{ $item->id }}')"
                                                            wire:key="minus-{{ $item->id }}"
                                                            {{ $item->quantity <= 1 ? 'disabled' : '' }}
                                                            wire:loading.attr="disabled">
                                                        <i class="ri-subtract-line"></i>
                                                    </button>
                                                    <input type="text" class="qty-input"
                                                           value="{{ $item->quantity }}" readonly>
                                                    <button class="qty-btn" type="button"
                                                            wire:click="increaseQuantity('{{ $item->id }}')"
                                                            wire:key="plus-{{ $item->id }}"
                                                            wire:loading.attr="disabled">
                                                        <i class="ri-add-line"></i>
                                                    </button>
                                                </div>
                                            </div>

                                            <!-- Price -->
                                            <div class="col-auto text-center" style="min-width: 100px;">
                                                <label class="form-label small text-muted mb-1">Precio unit.</label>
                                                <div class="price-text" style="font-size: 1rem;">
                                                    {{ format_money($item->price) }}
                                                </div>
                                                @if($item->associatedModel && $item->associatedModel->precio_bs && is_venezuela_company())
                                                    <small class="text-muted d-block">
                                                        {{ number_format(( $item->price / tasa()->usd_rate), 2) }} $
                                                    </small>
                                                @endif
                                            </div>

                                            <!-- Subtotal -->
                                            <div class="col-auto text-end" style="min-width: 120px;">
                                                <label class="form-label small text-muted mb-1">Subtotal</label>
                                                <div class="price-text text-velzon-primary">
                                                    {{ format_money($item->price * $item->quantity) }}
                                                </div>
                                            </div>

                                            <!-- Remove Button -->
                                            <div class="col-auto">
                                                <button wire:click="removeItem('{{ $item->id }}')"
                                                        class="btn-remove-item"
                                                        wire:key="remove-{{ $item->id }}-{{ $loop->index }}"
                                                        wire:confirm="¿Estás seguro de que quieres eliminar este producto?"
                                                        title="Eliminar">
                                                    <i class="ri-delete-bin-line"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Loading overlay -->
                                    <div wire:loading wire:target="increaseQuantity('{{ $item->id }}'), decreaseQuantity('{{ $item->id }}'), removeItem('{{ $item->id }}')"
                                         class="loading-overlay">
                                        <div class="spinner-border spinner-border-sm text-primary" role="status">
                                            <span class="visually-hidden">Cargando...</span>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>

                    <!-- Order Summary Sidebar -->
                    <div class="col-lg-4">
                        <div class="summary-card sticky-top" style="top: 100px;">
                            <!-- Header -->
                            <div class="summary-header">
                                <div class="d-flex align-items-center">
                                    <i class="ri-file-list-3-line fs-4 me-2"></i>
                                    <h5 class="mb-0 text-white fw-semibold">Resumen del Pedido</h5>
                                </div>
                            </div>

                            <div class="p-4">
                                <!-- Checkout Timeline -->
                                <div class="checkout-timeline mb-4">
                                    <div class="timeline-step completed">
                                        <div class="step-icon">
                                            <i class="ri-shopping-cart-line"></i>
                                        </div>
                                        <span class="step-label">Carrito</span>
                                    </div>
                                    <div class="timeline-step active">
                                        <div class="step-icon">
                                            <i class="ri-wallet-3-line"></i>
                                        </div>
                                        <span class="step-label">Pago</span>
                                    </div>
                                    <div class="timeline-step pending">
                                        <div class="step-icon">
                                            <i class="ri-truck-line"></i>
                                        </div>
                                        <span class="step-label">Envío</span>
                                    </div>
                                </div>

                                <!-- Price Breakdown -->
                                <div class="mb-4">
                                    <div class="d-flex justify-content-between align-items-center py-2">
                                        <span class="text-muted">
                                            <i class="ri-price-tag-3-line me-2"></i>Subtotal ({{ $cartCount }} items)
                                        </span>
                                        <span class="fw-semibold">{{ format_money($cartTotal) }}</span>
                                    </div>

                                    @if(is_venezuela_company() && tasa())
                                    <div class="d-flex justify-content-between align-items-center py-2">
                                        <span class="text-muted">
                                            <i class="ri-exchange-dollar-line me-2"></i>Tasa del día
                                        </span>
                                        <span class="badge badge-soft-info">
                                            {{ number_format(tasa()->usd_rate, 2) }} Bs/$
                                        </span>
                                    </div>
                                    @endif

                                    <div class="d-flex justify-content-between align-items-center py-2">
                                        <span class="text-muted">
                                            <i class="ri-truck-line me-2"></i>Envío
                                        </span>
                                        <span class="text-velzon-success fw-medium">
                                            {{ $remainingForFreeShipping == 0 ? 'Gratis' : 'Por calcular' }}
                                        </span>
                                    </div>

                                    <div class="d-flex justify-content-between align-items-center py-2">
                                        <span class="text-muted">
                                            <i class="ri-percent-line me-2"></i>Impuestos
                                        </span>
                                        <span class="fw-medium">$0.00</span>
                                    </div>

                                    <hr class="my-3">

                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="fs-5 fw-bold" style="color: var(--velzon-gray-800);">Total</span>
                                        <span class="fs-4 fw-bold text-velzon-primary">{{ format_money($cartTotal) }}</span>
                                    </div>

                                    @if(is_venezuela_company() && tasa())
                                       @if($currency === 'usd' && tasa()->usd_rate > 0)
                                         <div class="d-flex justify-content-between align-items-center mt-2">
                                            <span class="text-muted small">Total en Bolívares</span>
                                            <span class="fw-bold" style="color: var(--velzon-gray-700);">
                                                {{ number_format($cartTotal * tasa()->usd_rate, 2) }} Bs
                                            </span>
                                        </div>
                                        @else
                                         <div class="d-flex justify-content-between align-items-center mt-2">
                                            <span class="text-muted small">Total en Divisas</span>
                                            <span class="fw-bold" style="color: var(--velzon-gray-700);">
                                                {{ number_format($cartTotal / tasa()->usd_rate, 2) }} $
                                            </span>
                                        </div>
                                       @endif
                                    @endif
                                </div>

                                <!-- Coupon Code -->
                                <div class="mb-4">
                                    <label class="form-label fw-medium">
                                        <i class="ri-coupon-3-line me-1"></i>
                                        Código de descuento
                                    </label>
                                    <div class="coupon-input-group">
                                        <input type="text"
                                               class="form-control"
                                               placeholder="Ingresa tu código"
                                               wire:model.defer="couponCode">
                                        <button class="btn btn-primary btn-apply" type="button">
                                            <i class="ri-check-line me-1"></i>
                                            Aplicar
                                        </button>
                                    </div>
                                </div>

                                <!-- Action Buttons -->
                                <div class="d-grid gap-2">
                                    <a href="/front/checkout" class="btn btn-success btn-lg rounded-pill">
                                        <i class="ri-secure-payment-line me-2"></i>
                                        Proceder al Pago
                                        <i class="ri-arrow-right-line ms-2"></i>
                                    </a>
                                    <a href="/front/wishlist" class="btn btn-soft-primary rounded-pill">
                                        <i class="ri-heart-line me-2"></i>
                                        Ver Lista de Deseos
                                    </a>
                                </div>
                            </div>
                        </div>

                        <!-- Guarantees -->
                        <div class="mt-4 p-3" style="background: var(--velzon-white); border-radius: var(--velzon-radius-xl);">
                            <div class="guarantee-item">
                                <div class="guarantee-icon" style="background: rgba(var(--velzon-success-rgb), 0.1);">
                                    <i class="ri-shield-check-line text-velzon-success"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1 fw-semibold" style="font-size: 0.875rem;">Compra 100% segura</h6>
                                    <p class="mb-0 text-muted small">Tus datos están protegidos</p>
                                </div>
                            </div>

                            <div class="guarantee-item">
                                <div class="guarantee-icon" style="background: rgba(var(--velzon-info-rgb), 0.1);">
                                    <i class="ri-customer-service-2-line text-velzon-info"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1 fw-semibold" style="font-size: 0.875rem;">Soporte 24/7</h6>
                                    <p class="mb-0 text-muted small">Estamos para ayudarte</p>
                                </div>
                            </div>

                            <div class="guarantee-item">
                                <div class="guarantee-icon" style="background: rgba(var(--velzon-warning-rgb), 0.15);">
                                    <i class="ri-exchange-line" style="color: #cc8d19;"></i>
                                </div>
                                <div>
                                    <h6 class="mb-1 fw-semibold" style="font-size: 0.875rem;">Devolución fácil</h6>
                                    <p class="mb-0 text-muted small">30 días para cambios</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Suggested Products -->
                @if(isset($suggestedProducts) && $suggestedProducts->count() > 0)
                <div class="suggested-products">
                    <div class="d-flex align-items-center justify-content-between mb-4">
                        <div>
                            <h5 class="mb-1 fw-semibold" style="color: var(--velzon-gray-800);">
                                <i class="ri-lightbulb-line me-2 text-velzon-warning"></i>
                                También te puede interesar
                            </h5>
                            <p class="text-muted mb-0 small">Productos recomendados para ti</p>
                        </div>
                        <a href="/front/products" class="btn btn-soft-primary btn-sm rounded-pill">
                            Ver todos <i class="ri-arrow-right-line ms-1"></i>
                        </a>
                    </div>

                    <div class="row g-3">
                        @foreach($suggestedProducts->take(4) as $product)
                        <div class="col-6 col-md-3">
                            <div class="suggested-product-card text-center">
                                <img src="{{ $product->images->first() ? asset('app/' . $product->images->first()->path) : asset('assets/images/placeholder.png') }}"
                                     alt="{{ $product->nombre }}"
                                     class="img-fluid rounded mb-2"
                                     style="height: 80px; object-fit: cover;">
                                <h6 class="mb-1 small fw-medium text-truncate">{{ $product->nombre }}</h6>
                                <span class="price-text" style="font-size: 0.9rem;">{{ format_money($product->precio) }}</span>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                @endif

            @else
                <!-- Empty Cart State -->
                <div class="row justify-content-center">
                    <div class="col-md-8 col-lg-6">
                        <div class="text-center py-5" style="background: var(--velzon-white); border-radius: var(--velzon-radius-xl); padding: 3rem !important;">
                            <div class="empty-cart-illustration">
                                <i class="ri-shopping-cart-2-line" style="font-size: 4rem; color: var(--velzon-gray-400);"></i>
                            </div>

                            <h3 class="mt-4 mb-2 fw-bold" style="color: var(--velzon-gray-800);">
                                Tu carrito está vacío
                            </h3>
                            <p class="text-muted mb-4 px-4">
                                Parece que aún no has agregado productos a tu carrito.
                                ¡Explora nuestra tienda y encuentra lo que necesitas!
                            </p>

                            <div class="d-flex flex-wrap justify-content-center gap-3">
                                <a href="/" class="btn btn-primary btn-lg rounded-pill px-4">
                                    <i class="ri-store-2-line me-2"></i>
                                    Explorar Tienda
                                </a>
                                <a href="/front/wishlist" class="btn btn-soft-danger rounded-pill px-4">
                                    <i class="ri-heart-line me-2"></i>
                                    Ver Favoritos
                                </a>
                            </div>

                            <div class="mt-5 pt-4 border-top">
                                <p class="text-muted small mb-3">¿Necesitas ayuda?</p>
                                <div class="d-flex justify-content-center gap-4">
                                    <a href="#" class="text-decoration-none text-muted">
                                        <i class="ri-customer-service-2-line me-1"></i>
                                        Contactar soporte
                                    </a>
                                    <a href="#" class="text-decoration-none text-muted">
                                        <i class="ri-question-line me-1"></i>
                                        Preguntas frecuentes
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </section>


</div>
