<div>
    <!-- start page title -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between bg-galaxy-transparent">
                <h4 class="mb-sm-0">Detalle del pedido</h4>

                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="/">Tienda en línea</a></li>
                        <li class="breadcrumb-item active">Detalle del pedido</li>
                    </ol>
                </div>

            </div>
        </div>
    </div>
    <!-- end page title -->

    <div class="row">
        <div class="col-xl-9">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center">
                        <h5 class="card-title flex-grow-1 mb-0">Pedido #{{ $pedido->codigo }}</h5>

                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive table-card">
                        <table class="table table-nowrap align-middle table-borderless mb-0">
                            <thead class="table-light text-muted">
                                <tr>
                                    <th scope="col">Detalle de los productos</th>
                                    <th scope="col">Precio</th>
                                    <th scope="col">Cantidad</th>
                                    <th scope="col">Rating</th>
                                    <th scope="col" class="text-end">Monto total</th>
                                </tr>
                            </thead>
                            <tbody>

                                @foreach ($pedido->detalles as $detalle)
                                    <tr>
                                        <td>
                                            <div class="d-flex">
                                                <div class="flex-shrink-0 avatar-md bg-light rounded p-1">
                                                    @if($detalle->producto && $detalle->producto->images && $detalle->producto->images->first())
                                                        <img src="{{ Storage::url($detalle->producto->images->first()->path) }}"
                                                            alt="{{ $detalle->producto->name }}" class="img-fluid d-block">
                                                    @else
                                                        <div class="bg-light rounded d-flex align-items-center justify-content-center"
                                                             style="height: 100%;">
                                                            <i class=" ri-circle-line  text-muted"></i>
                                                        </div>
                                                    @endif
                                                </div>
                                                <div class="flex-grow-1 ms-3">
                                                    <h5 class="fs-15"><a href="#"
                                                            class="link-primary">{{ $detalle->producto->name }}</a></h5>
                                                    <p class="text-muted mb-0"><span
                                                            class="fw-medium">{{ $detalle->producto->description }}</span>
                                                    </p>

                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ money($detalle->price) }}</td>
                                        <td>{{ $detalle->quantity }}</td>
                                        <td>
                                            <div class="text-warning fs-15">
                                                <i class=" ri-circle-line"></i><i class=" ri-circle-line"></i><i class=" ri-circle-line"></i><i class=" ri-circle-line"></i><i class=" ri-circle-line"></i>
                                            </div>
                                        </td>
                                        <td class="fw-medium text-end">
                                            {{ money($detalle->quantity * $detalle->price) }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </td>
                        </tr>
                        </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    @if (Auth::user()->roleId === 4)
                            <div class="btn-group">
                                <a target="_blank" class=" btn btn-success"
                                    href="https:\\wa.me/{{ $pedido->user->telefono }}"><i class=" ri-circle-line "></i> Contactar al cliente</a>
                                <a href="{{ 'https://www.google.es/maps/dir/%7B%7B+/' . $pedido->latitud . ',' . $pedido->longitud . '/@' . '10.4941216,-66.9079275' . ',18z/data=!3m1!4b1!4m9!4m8!1m5!1m1!1s0x8c2a5f4dfb851aab:0x6f856b651940158e!2m2!1d-66.9067414!2d10.4942726!1m0!3e2?entry=ttu&g_ep=EgoyMDI0MTIxMS4wIKXMDSoASAFQAw%3D%3D' }}"
                                    target="_blank" wire:click="empaquetado({{ $pedido->id }})"
                                    class="btn btn-primary">Ir a google maps</a>
                            </div>
                    @endif
                </div>
            </div>
            <!--end card-->
            <div class="card">
                <div class="card-header">
                    <div class="d-sm-flex align-items-center">
                        <h5 class="card-title flex-grow-1 mb-0">Estado del pedido</h5>
                        <div class="flex-shrink-0 mt-2 mt-sm-0">
                            @if ($pedido->estatus == 'pendiente')
                                <div class="flex gap-2 mt-4">
                                    <button wire:click='cancelarPedido({{ $pedido->id }})'
                                        class="bg-red-600 hover:bg-red-700 text-white py-2 px-4 rounded-lg transition duration-300 flex items-center">
                                        <i class='bx bx-x-circle mr-2'></iconify-icon>Cancelar pedido
                                    </button>

                                    <!-- Botón de contacto por WhatsApp -->
                                    <button wire:click='contactarPorWhatsApp'
                                        class="bg-green-600 hover:bg-green-700 text-white py-2 px-4 rounded-lg transition duration-300 flex items-center">
                                        <i class='bx bxl-whatsapp mr-2'></iconify-icon>Contactar
                                    </button>
                                </div>
                            @endif
                        </div>
                    </div>

                </div>
                <div class="card-body">
                    <div class="profile-timeline">
                        <div class="accordion accordion-flush" id="accordionFlushExample">

                            <div class="accordion-item border-0">
                                <div class="accordion-header" id="headingOne">
                                    <a class="accordion-button p-2 shadow-none" data-bs-toggle="collapse"
                                        href="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0 avatar-xs">
                                                <div class="avatar-title bg-success rounded-circle material-shadow">
                                                    <i class=" ri-circle-line"></i>
                                                </div>
                                            </div>
                                            <div class="flex-grow-1 ms-3">
                                                <h6 class="fs-15 mb-0 fw-semibold">Pedido #{{ $pedido->codigo }} -
                                                    <span class="fw-normal">
                                                        {{ \Carbon\Carbon::parse($pedido->created_at)->isoFormat('dddd D \d\e MMMM \d\e\l Y') }}
                                                    </span>
                                                </h6>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                                <div id="collapseOne" class="accordion-collapse collapse show"
                                    aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                                    @foreach (\App\Models\HistoricoPedido::where('pedidoId', $pedido->id)->get() as $item)
                                        <div class="accordion-body ms-2 ps-5 pt-0">
                                            <h6 class="mb-1">{{ $item->descripcion }}</h6>
                                            <p class="text-muted">
                                                {{ \Carbon\Carbon::parse($pedido->created_at)->isoFormat('dddd D \d\e MMMM \d\e\l Y H:m A') }}
                                            </p>
                                        </div>
                                    @endforeach
                                </div>
                            </div>




                        </div>
                        <!--end accordion-->
                    </div>
                </div>
            </div>
            <!--end card-->
        </div>
        <!--end col-->
        <div class="col-xl-3">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex">
                        <h5 class="card-title flex-grow-1 mb-0"><i class=" ri-circle-line  align-middle me-1 text-muted"></i> Detalle de
                            logística</h5>
                        <div class="flex-shrink-0">
                            <a href="javascript:void(0);" class="badge bg-primary-subtle text-primary fs-11">Entrega de
                                pedido</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="text-center">
                        <lord-icon src="https://cdn.lordicon.com/uetqnvvg.json" trigger="loop"
                            colors="primary:#405189,secondary:#0ab39c" style="width:80px;height:80px"></lord-icon>
                        <h5 class="fs-16 mt-2">RQK Logistics</h5>
                        <p class="text-muted mb-0">Fecha de pedido: {{ $pedido->created_at->format('d/m/Y') }}</p>
                        <p class="text-muted mb-0">Método de pago : {{ $metodo_pago }}</p>
                    </div>
                </div>
            </div>
            <!--end card-->

            <div class="card">
                <div class="card-header">
                    <div class="d-flex">
                        <h5 class="card-title flex-grow-1 mb-0">Detalles del cliente</h5>
                        <div class="flex-shrink-0">
                            <a href="/front/pedido/historico" class="link-secondary">Ver pedidos</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled mb-0 vstack gap-3">
                        <li>
                            <div class="d-flex align-items-center">

                                <div class="flex-grow-1 ms-3">
                                    <h6 class="fs-14 mb-1">{{ Auth::user()->name }}</h6>
                                    <p class="text-muted mb-0">Cliente</p>
                                </div>
                            </div>
                        </li>
                        <li><i class=" ri-circle-line me-2 align-middle text-muted fs-16"></i>{{ $pedido->user->username }}
                        </li>
                        <li><i class=" ri-circle-line me-2 align-middle text-muted fs-16"></i>{{ $pedido->user->telefono }}
                        </li>
                    </ul>
                </div>
            </div>
            <!--end card-->
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0"><i class=" ri-circle-line align-middle me-1 text-muted"></i> Dirección
                        de entrega</h5>
                </div>
                <div class="card-body">
                    <ul class="list-unstyled vstack gap-2 fs-13 mb-0">
                        <li class="fw-medium fs-14">{{ $pedido->user->name }}</li>
                        <li>Ubicación: {{ $ubicacion }}</li>
                        <li>Ubicación: {{ $longitud }}</li>
                        <li>Ubicación: {{ $latitud }}</li>
                    </ul>
                </div>
            </div>
            <!--end card
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0"><i class=" ri-circle-line align-middle me-1 text-muted"></i> Shipping Address</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-unstyled vstack gap-2 fs-13 mb-0">
                            <li class="fw-medium fs-14">Joseph Parker</li>
                            <li>+(256) 245451 451</li>
                            <li>2186 Joyce Street Rocky Mount</li>
                            <li>California - 24567</li>
                            <li>United States</li>
                        </ul>
                    </div>
                </div>


                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0"><i class=" ri-circle-line align-bottom me-1 text-muted"></i> Payment Details</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center mb-2">
                            <div class="flex-shrink-0">
                                <p class="text-muted mb-0">Transactions:</p>
                            </div>
                            <div class="flex-grow-1 ms-2">
                                <h6 class="mb-0">#VLZ124561278124</h6>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <div class="flex-shrink-0">
                                <p class="text-muted mb-0">Payment Method:</p>
                            </div>
                            <div class="flex-grow-1 ms-2">
                                <h6 class="mb-0">Debit Card</h6>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <div class="flex-shrink-0">
                                <p class="text-muted mb-0">Card Holder Name:</p>
                            </div>
                            <div class="flex-grow-1 ms-2">
                                <h6 class="mb-0">Joseph Parker</h6>
                            </div>
                        </div>
                        <div class="d-flex align-items-center mb-2">
                            <div class="flex-shrink-0">
                                <p class="text-muted mb-0">Card Number:</p>
                            </div>
                            <div class="flex-grow-1 ms-2">
                                <h6 class="mb-0">xxxx xxxx xxxx 2456</h6>
                            </div>
                        </div>
                        <div class="d-flex align-items-center">
                            <div class="flex-shrink-0">
                                <p class="text-muted mb-0">Total Amount:</p>
                            </div>
                            <div class="flex-grow-1 ms-2">
                                <h6 class="mb-0">$415.96</h6>
                            </div>
                        </div>
                    </div>
                </div>
                <!--end card-->
        </div>
        <!--end col-->
    </div>
    <!--end row-->

</div>
