<div class="product-comparison">
    @if(count($compareProducts) > 0)
        <button wire:click="toggleComparison" class="compare-btn">
            Comparar ({{ count($compareProducts) }})
        </button>
    @endif

    @if($showComparison && count($this->products) > 0)
        <div class="comparison-modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h3>Comparar Productos</h3>
                    <button wire:click="toggleComparison" class="close-btn">×</button>
                </div>
                
                <table class="comparison-table">
                    <thead>
                        <tr>
                            <th>Producto</th>
                            @foreach($this->products as $product)
                                <th>{{ $product->name }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td><strong>Precio</strong></td>
                            @foreach($this->products as $product)
                                <td>${{ number_format($product->price, 2) }}</td>
                            @endforeach
                        </tr>
                        <tr>
                            <td><strong>Categoría</strong></td>
                            @foreach($this->products as $product)
                                <td>{{ $product->categoria->nombre ?? 'N/A' }}</td>
                            @endforeach
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>

<style>
.compare-btn {
    position: fixed;
    bottom: 100px;
    right: 20px;
    background: #3b82f6;
    color: white;
    padding: 10px 20px;
    border-radius: 25px;
    border: none;
    cursor: pointer;
    z-index: 999;
}

.comparison-modal {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0,0,0,0.8);
    z-index: 1000;
    display: flex;
    align-items: center;
    justify-content: center;
    padding: 20px;
}

.modal-content {
    background: white;
    border-radius: 12px;
    padding: 20px;
    max-width: 90vw;
    max-height: 90vh;
    overflow: auto;
}

.modal-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 20px;
}

.close-btn {
    background: #6b7280;
    color: white;
    border: none;
    padding: 5px 10px;
    border-radius: 5px;
    cursor: pointer;
}

.comparison-table {
    width: 100%;
    border-collapse: collapse;
}

.comparison-table th,
.comparison-table td {
    padding: 10px;
    border: 1px solid #ddd;
    text-align: center;
}
</style>