<div>
    <div class="lazy-image-container">
    <img
        src="{{ $placeholder }}"
        data-src="{{ $src }}"
        alt="{{ $alt }}"
        class="lazy-image {{ $class }}"
        loading="lazy"
    >
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const lazyImages = document.querySelectorAll('.lazy-image');

    const imageObserver = new IntersectionObserver((entries, observer) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                const img = entry.target;
                img.src = img.dataset.src;
                img.classList.remove('lazy-image');
                img.classList.add('loaded');
                observer.unobserve(img);
            }
        });
    });

    lazyImages.forEach(img => imageObserver.observe(img));
});
</script>

<style>
.lazy-image {
    transition: opacity 0.3s;
    opacity: 0.7;
}

.lazy-image.loaded {
    opacity: 1;
}

.lazy-image-container {
    overflow: hidden;
}
</style>
</div>
