<div class="card">
    <div class="card-header">
        <h5 class="mb-0">Configuraciones de Seguridad</h5>
    </div>
    <div class="card-body">
        <!-- Security Score -->
        <div class="mb-4">
            <div class="d-flex justify-content-between align-items-center mb-2">
                <h6 class="mb-0">Nivel de Seguridad</h6>
                <span class="badge bg-{{ $securityInfo['level']['color'] }}">{{ $securityInfo['level']['name'] }}</span>
            </div>
            <div class="progress mb-2" style="height: 8px;">
                <div class="progress-bar bg-{{ $securityInfo['level']['color'] }}" 
                     role="progressbar" 
                     style="width: {{ $securityInfo['score'] }}%"
                     aria-valuenow="{{ $securityInfo['score'] }}" 
                     aria-valuemin="0" 
                     aria-valuemax="100">
                </div>
            </div>
            <small class="text-muted">{{ $securityInfo['score'] }}% de seguridad</small>
            
            @if(count($securityInfo['factors']) > 0)
                <div class="mt-3">
                    <small class="text-muted d-block mb-2">Factores de seguridad activos:</small>
                    <ul class="list-unstyled mb-0">
                        @foreach($securityInfo['factors'] as $factor)
                            <li class="mb-1">
                                <i class="ri-check-line text-success me-1"></i>
                                <small>{{ $factor }}</small>
                            </li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>

        <hr>

        <!-- Change Password -->
        <div class="mb-4">
            <h6 class="mb-3">Cambiar Contraseña</h6>
            <form wire:submit.prevent="updatePassword">
                <div class="row">
                    <div class="col-12 mb-3">
                        <label class="form-label">Contraseña Actual *</label>
                        <input type="password" 
                               wire:model="current_password" 
                               class="form-control @error('current_password') is-invalid @enderror"
                               placeholder="Ingresa tu contraseña actual">
                        @error('current_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Nueva Contraseña *</label>
                        <input type="password" 
                               wire:model="new_password" 
                               class="form-control @error('new_password') is-invalid @enderror"
                               placeholder="Mínimo 8 caracteres">
                        @error('new_password') <div class="invalid-feedback">{{ $message }}</div> @enderror
                    </div>
                    
                    <div class="col-md-6 mb-3">
                        <label class="form-label">Confirmar Nueva Contraseña *</label>
                        <input type="password" 
                               wire:model="new_password_confirmation" 
                               class="form-control"
                               placeholder="Repite la nueva contraseña">
                    </div>
                </div>
                
                <div class="mb-3">
                    <div class="form-check">
                        <input class="form-check-input" 
                               type="checkbox" 
                               wire:model="logout_other_devices" 
                               id="logoutOtherDevices">
                        <label class="form-check-label" for="logoutOtherDevices">
                            Cerrar sesión en otros dispositivos
                        </label>
                        <small class="form-text text-muted d-block">
                            Esto cerrará tu sesión en todos los demás dispositivos por seguridad.
                        </small>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary">
                    <i class="ri-lock-line me-1"></i> Actualizar Contraseña
                </button>
            </form>
        </div>

        <hr>

        <!-- Security Recommendations -->
        <div class="mb-0">
            <h6 class="mb-3">Recomendaciones de Seguridad</h6>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-{{ $user->two_factor_enabled ? 'success' : 'warning' }} rounded">
                                <i class="ri-shield-{{ $user->two_factor_enabled ? 'check' : 'line' }}-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Autenticación de Dos Factores</h6>
                            <p class="mb-2 text-muted">
                                {{ $user->two_factor_enabled ? 'Activada' : 'Añade una capa extra de seguridad' }}
                            </p>
                            @if(!$user->two_factor_enabled)
                                <small class="text-warning">
                                    <i class="ri-information-line me-1"></i>
                                    Recomendado activar
                                </small>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-{{ $user->email_verified_at ? 'success' : 'danger' }} rounded">
                                <i class="ri-mail-{{ $user->email_verified_at ? 'check' : 'line' }}-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Email Verificado</h6>
                            <p class="mb-2 text-muted">
                                {{ $user->email_verified_at ? 'Verificado el ' . $user->email_verified_at->format('d/m/Y') : 'Verifica tu email para mayor seguridad' }}
                            </p>
                            @if(!$user->email_verified_at)
                                <small class="text-danger">
                                    <i class="ri-error-warning-line me-1"></i>
                                    Verificación pendiente
                                </small>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-{{ ($user->phone && $user->address) ? 'success' : 'info' }} rounded">
                                <i class="ri-user-{{ ($user->phone && $user->address) ? 'check' : 'line' }}-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Perfil Completo</h6>
                            <p class="mb-2 text-muted">
                                {{ ($user->phone && $user->address) ? 'Información completa' : 'Completa tu información de contacto' }}
                            </p>
                            @if(!($user->phone && $user->address))
                                <small class="text-info">
                                    <i class="ri-information-line me-1"></i>
                                    Mejora tu perfil
                                </small>
                            @endif
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6 mb-3">
                    <div class="d-flex align-items-start">
                        <div class="avatar flex-shrink-0 me-3">
                            <div class="avatar-initial bg-{{ $user->avatar ? 'success' : 'secondary' }} rounded">
                                <i class="ri-camera-{{ $user->avatar ? 'check' : 'line' }}-line"></i>
                            </div>
                        </div>
                        <div>
                            <h6 class="mb-1">Foto de Perfil</h6>
                            <p class="mb-2 text-muted">
                                {{ $user->avatar ? 'Configurada' : 'Añade una foto para personalizar tu perfil' }}
                            </p>
                            @if(!$user->avatar)
                                <small class="text-secondary">
                                    <i class="ri-information-line me-1"></i>
                                    Opcional pero recomendado
                                </small>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>