<div>
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Accesos Rápidos</h5>
        </div>
        <div class="card-body">
            <div class="row">
                @foreach($quickActions as $action)
                    <div class="col-md-6 mb-3">
                        <div class="d-flex align-items-center p-3 border rounded hover-shadow" style="cursor: pointer;" 
                             @if(isset($action['action']))
                                wire:click="{{ $action['action'] }}"
                             @else
                                onclick="window.location.href='{{ $action['route'] }}'"
                             @endif>
                            <div class="avatar flex-shrink-0 me-3">
                                <div class="avatar-initial bg-{{ $action['color'] }} rounded">
                                    <i class="{{ $action['icon'] }}"></i>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <h6 class="mb-1">{{ $action['title'] }}</h6>
                                <p class="mb-0 text-muted small">{{ $action['description'] }}</p>
                                @if($action['count'] !== null)
                                    <small class="text-{{ $action['color'] }}">{{ number_format($action['count']) }} elementos</small>
                                @endif
                            </div>
                            <i class="ri-arrow-right-line text-muted"></i>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Información del Sistema</h5>
            <button wire:click="exportUserData" class="btn btn-sm btn-outline-primary">
                <i class="ri-download-line me-1"></i> Exportar Datos
            </button>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <div class="d-flex justify-content-between">
                        <span class="text-muted">Último acceso:</span>
                        <span class="fw-medium">{{ $systemInfo['last_login'] }}</span>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="d-flex justify-content-between">
                        <span class="text-muted">Cuenta creada:</span>
                        <span class="fw-medium">{{ $systemInfo['account_created'] }}</span>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="d-flex justify-content-between">
                        <span class="text-muted">Días activo:</span>
                        <span class="fw-medium">{{ number_format($systemInfo['days_active']) }} días</span>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="d-flex justify-content-between">
                        <span class="text-muted">Zona horaria:</span>
                        <span class="fw-medium">{{ $systemInfo['timezone'] }}</span>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="d-flex justify-content-between">
                        <span class="text-muted">Idioma:</span>
                        <span class="fw-medium">{{ strtoupper($systemInfo['locale']) }}</span>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <div class="d-flex justify-content-between">
                        <span class="text-muted">Versión Laravel:</span>
                        <span class="fw-medium">{{ $systemInfo['laravel_version'] }}</span>
                    </div>
                </div>
            </div>
            
            <hr>
            
            <div class="row">
                <div class="col-12">
                    <h6 class="mb-3">Configuraciones de Privacidad</h6>
                    <div class="d-flex flex-wrap gap-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" checked disabled>
                            <label class="form-check-label">
                                <i class="ri-shield-check-line text-success me-1"></i>
                                Datos encriptados
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" {{ $user->email_verified_at ? 'checked' : '' }} disabled>
                            <label class="form-check-label">
                                <i class="ri-mail-check-line text-{{ $user->email_verified_at ? 'success' : 'warning' }} me-1"></i>
                                Email verificado
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" {{ $user->two_factor_enabled ? 'checked' : '' }} disabled>
                            <label class="form-check-label">
                                <i class="ri-lock-line text-{{ $user->two_factor_enabled ? 'success' : 'secondary' }} me-1"></i>
                                2FA activado
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
.hover-shadow {
    transition: all 0.3s ease;
}

.hover-shadow:hover {
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}
</style>
@endpush