<div>
    <!-- Header -->
    <div class="row">
        <div class="col-12">
            <div class="card mb-4">
                <div class="user-profile-header-banner">
                    <img src="{{ asset('materialize/assets/img/pages/profile-banner.png') }}" alt="Banner image" class="rounded-top">
                </div>
                <div class="user-profile-header d-flex flex-column flex-sm-row text-sm-start text-center mb-4">
                    <div class="flex-shrink-0 mt-n2 mx-sm-0 mx-auto">
                        @if($user->avatar)
                            <img src="{{ Storage::url($user->avatar) }}" alt="user image" class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img">
                        @else
                            <div class="d-block h-auto ms-0 ms-sm-4 rounded user-profile-img bg-light d-flex justify-content-center align-items-center">
                                <i class=" ri-user-line "></i>
                            </div>
                        @endif
                    </div>
                    <div class="flex-grow-1 mt-3 mt-sm-5">
                        <div class="d-flex align-items-md-end align-items-sm-start align-items-center flex-md-row flex-column flex-sm-row flex-column justify-content-between mx-4 mx-sm-0">
                            <div class="user-profile-info">
                                <h4>{{ $user->name }}</h4>
                                <ul class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-2">
                                    <li class="list-inline-item">
                                        <i class=" ri-user-line  me-1"></i>
                                        <span class="text-muted">{{ $user->email }}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Nav tabs -->
    <ul class="nav nav-pills flex-column flex-sm-row mb-4">
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.users.profile', $user->id) }}">
                <i class=" ri-user-line  me-1"></i> Resumen
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link" href="{{ route('admin.users.password', $user->id) }}">
                <i class=" ri-user-line  me-1"></i> Cambio de contraseña
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link active" href="{{ route('admin.users.history', $user->id) }}">
                <i class=" ri-user-line  me-1"></i> Historial
            </a>
        </li>
    </ul>

    <!-- Filter Tabs -->
    <div class="card mb-4">
        <div class="card-body">
            <div class="btn-group" role="group">
                <button wire:click="setFilter('all')" class="btn btn-{{ $filter == 'all' ? 'primary' : 'outline-primary' }}">Todos</button>
                <button wire:click="setFilter('pendiente')" class="btn btn-{{ $filter == 'pendiente' ? 'warning' : 'outline-warning' }}">Pendientes</button>
                <button wire:click="setFilter('entregado')" class="btn btn-{{ $filter == 'entregado' ? 'success' : 'outline-success' }}">Entregados</button>
                <button wire:click="setFilter('cancelado')" class="btn btn-{{ $filter == 'cancelado' ? 'danger' : 'outline-danger' }}">Cancelados</button>
            </div>
        </div>
    </div>

    <!-- Activity History -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Historial de Actividad</h5>
            <small class="text-muted">Mostrando {{ $activities->count() }} de {{ $activities->total() }} registros</small>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Pedido</th>
                            <th>Fecha</th>
                            <th>Estado</th>
                            <th>Total</th>
                            <th>Productos</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($activities as $pedido)
                        <tr>
                            <td>#{{ $pedido->codigo }}</td>
                            <td>{{ $pedido->created_at->format('d/m/Y H:i') }}</td>
                            <td>
                                <span class="badge bg-{{ $pedido->estado == 'entregado' ? 'success' : ($pedido->estado == 'pendiente' ? 'warning' : 'info') }}">
                                    {{ ucfirst($pedido->estado) }}
                                </span>
                            </td>
                            <td>${{ number_format($pedido->total_usd, 2) }}</td>
                            <td>{{ $pedido->detalles->count() }} productos</td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center">No hay actividad registrada</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                {{ $activities->links() }}
            </div>
        </div>
    </div>


</div>

@push('styles')
<link rel="stylesheet" href="/materialize/assets/vendor/css/pages/page-profile.css" />
@endpush
