<div>
    @if (session()->has('message'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('message') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif

    <!-- Stats Cards -->
    <div class="row g-3 mb-4">
        <div class="col-md-3">
            <div class="card border-start border-primary border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Roles</h6>
                            <h2 class="mb-0">{{ $totalRoles }}</h2>
                        </div>
                        <div class="bg-primary bg-opacity-10 p-3 rounded">
                            <i class=" ri-shield-user-line text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-success border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Con Permisos</h6>
                            <h2 class="mb-0">{{ $rolesWithPermissions }}</h2>
                        </div>
                        <div class="bg-success bg-opacity-10 p-3 rounded">
                            <i class=" ri-shield-check-line text-success"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-warning border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Sin Permisos</h6>
                            <h2 class="mb-0">{{ $rolesWithoutPermissions }}</h2>
                        </div>
                        <div class="bg-warning bg-opacity-10 p-3 rounded">
                            <i class=" ri-shield-cross-line text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-start border-info border-4 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h6 class="text-muted mb-2">Total Permisos</h6>
                            <h2 class="mb-0">{{ $totalPermissions }}</h2>
                        </div>
                        <div class="bg-info bg-opacity-10 p-3 rounded">
                            <i class=" ri-key-line text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header border-bottom">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="card-title mb-1">Lista de Roles</h5>
                            <p class="mb-0">Administra los roles del sistema y sus permisos</p>
                        </div>
                        @can('create roles')
                        <div>
                            <a href="{{ route('admin.roles.create') }}" class="btn btn-primary">
                                <i class=" ri-shield-user-line"></i> Nuevo Rol
                            </a>
                        </div>
                        @endcan
                    </div>
                </div>

                <!-- Filtros -->
                <div class="card-header border-bottom">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label class="form-label">Buscar</label>
                            <input type="text" class="form-control" placeholder="Nombre, guard..."
                                   wire:model.live.debounce.300ms="search">
                        </div>

                        <div class="col-md-3">
                            <label class="form-label">Guard</label>
                            <select class="form-select" wire:model.live="guard">
                                <option value="">Todos</option>
                                @foreach($guards as $guard)
                                    <option value="{{ $guard }}">{{ $guard }}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-2">
                            <label class="form-label">Mostrar</label>
                            <select class="form-select" wire:model.live="perPage">
                                <option value="10">10 por página</option>
                                <option value="25">25 por página</option>
                                <option value="50">50 por página</option>
                                <option value="100">100 por página</option>
                            </select>
                        </div>

                        <div class="col-md-3 d-flex align-items-end gap-2">
                            <button type="button" class="btn btn-label-secondary" wire:click="clearFilters">
                                <i class=" ri-filter-off-line"></i> Limpiar
                            </button>
                            <button type="button" class="btn btn-label-secondary" wire:click="$refresh">
                                <i class=" ri-refresh-line"></i> Actualizar
                            </button>
                        </div>
                    </div>
                </div>

                <div class="card-datatable table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th wire:click="sortBy('name')" style="cursor: pointer;">
                                    Nombre @if($sortBy === 'name') <i class=" ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i> @endif
                                </th>
                                <th wire:click="sortBy('guard_name')" style="cursor: pointer;">
                                    Guard @if($sortBy === 'guard_name') <i class=" ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i> @endif
                                </th>
                                <th>Permisos Asignados</th>
                                <th>Creado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($roles as $role)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar avatar-sm me-2">
                                                <span class="avatar-initial rounded bg-label-primary">{{ substr($role->name, 0, 1) }}</span>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $role->name }}</h6>
                                                <small class="text-muted">{{ Str::limit($role->name, 30) }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-secondary">{{ $role->guard_name }}</span>
                                    </td>
                                    <td>
                                        @if($role->permissions->count() > 0)
                                            <span class="badge bg-success">{{ $role->permissions->count() }} permisos</span>
                                            <div class="mt-1">
                                                <small class="text-muted">
                                                    {{ $role->permissions->pluck('name')->take(3)->implode(', ') }}
                                                    @if($role->permissions->count() > 3)
                                                        <span class="text-muted">+{{ $role->permissions->count() - 3 }} más</span>
                                                    @endif
                                                </small>
                                            </div>
                                        @else
                                            <span class="badge bg-secondary">Sin permisos</span>
                                        @endif
                                    </td>
                                    <td>
                                        {{ $role->created_at->format('d/m/Y H:i') }}
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                <i class=" ri-more-2-line"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                @can('view roles')
                                                <a class="dropdown-item" href="{{ route('admin.roles.show', $role) }}">
                                                    <i class=" ri-eye-line me-1"></i> Ver
                                                </a>
                                                @endcan
                                                @can('edit roles')
                                                <a class="dropdown-item" href="{{ route('admin.roles.edit', $role) }}">
                                                    <i class=" ri-edit-line me-1"></i> Editar
                                                </a>
                                                @endcan
                                                @can('delete roles')
                                                <button type="button" class="dropdown-item text-danger"
                                                        wire:click="deleteRole({{ $role->id }})"
                                                        wire:confirm="¿Estás seguro de eliminar este rol?">
                                                    <i class=" ri-delete-bin-line me-1"></i> Eliminar
                                                </button>
                                                @endcan
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="5" class="text-center">
                                        <i class=" ri-shield-user-line fs-1 text-muted mb-3"></i>
                                        <p class="text-muted">No se encontraron roles</p>
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="card-footer">
                   {{ $roles->links('livewire.pagination') }}
                </div>
            </div>
        </div>
    </div>
</div>
