<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="card-title mb-0">
            <i class="ri-notification-line me-2"></i>
            Notificaciones en Tiempo Real
        </h5>
        <div class="d-flex align-items-center gap-2">
            <small class="text-muted">
                Última actualización: {{ $lastCheck->format('H:i:s') }}
            </small>
            <button wire:click="checkForUpdates" class="btn btn-sm btn-outline-primary">
                <i class="ri-refresh-line"></i>
            </button>
        </div>
    </div>
    <div class="card-body">
        @if(count($pendingOrders) > 0)
            <div class="alert alert-warning d-flex align-items-center mb-3">
                <i class="ri-alert-line me-2"></i>
                <span>
                    Tienes {{ count($pendingOrders) }} pedido{{ count($pendingOrders) > 1 ? 's' : '' }} pendiente{{ count($pendingOrders) > 1 ? 's' : '' }}
                    @if(auth()->user()->hasRole('Empleado'))
                        asignado{{ count($pendingOrders) > 1 ? 's' : '' }} a ti
                    @endif
                </span>
            </div>

            <div class="list-group">
                @foreach($pendingOrders as $order)
                    <div class="list-group-item list-group-item-action">
                        <div class="d-flex w-100 justify-content-between">
                            <h6 class="mb-1">
                                Pedido #{{ $order->codigo }}
                                <span class="badge bg-warning ms-2">{{ $order->estado }}</span>
                            </h6>
                            <small class="text-muted">{{ $order->created_at->diffForHumans() }}</small>
                        </div>
                        <p class="mb-1">
                            <strong>Cliente:</strong> {{ $order->user->name ?? 'N/A' }}
                        </p>
                        <p class="mb-1">
                            <strong>Total:</strong> {{ format_money($order->total_usd) }}
                        </p>
                        @if($order->empleados->count() > 0)
                            <p class="mb-1">
                                <strong>Asignado a:</strong> 
                                @foreach($order->empleados as $empleado)
                                    <span class="badge bg-info">{{ $empleado->nombre_completo }}</span>
                                @endforeach
                            </p>
                        @endif
                        <div class="mt-2">
                            <a href="{{ route('admin.pedidos.show', $order->id) }}" class="btn btn-sm btn-primary">
                                Ver Detalles
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center py-4">
                <i class="ri-check-double-line text-success" style="font-size: 3rem;"></i>
                <h6 class="mt-2">No hay pedidos pendientes</h6>
                <p class="text-muted mb-0">
                    @if(auth()->user()->hasRole('Empleado'))
                        No tienes pedidos asignados pendientes en este momento.
                    @else
                        Todos los pedidos están al día.
                    @endif
                </p>
            </div>
        @endif
    </div>
</div>

@push('scripts')
<script>
    // Actualizar notificaciones cada 30 segundos
    setInterval(function() {
        @this.call('checkForUpdates');
    }, 30000);

    // Escuchar eventos de broadcasting si está disponible
    @if(config('broadcasting.default') !== 'null')
    document.addEventListener('DOMContentLoaded', function() {
        if (typeof Echo !== 'undefined') {
            Echo.private('empresa.{{ auth()->user()->empresa_id }}')
                .listen('PedidoUpdated', (e) => {
                    // Actualizar notificaciones cuando se actualiza un pedido
                    @this.call('checkForUpdates');
                });
        }
    });
    @endif
</script>
@endpush