<div>
    <!-- Statistics Cards -->
    <div class="row g-4 mb-4">
        <div class="col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Total Promociones</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2">{{ $stats['total'] ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-primary">
                                <i class="ri-price-tag-3-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Activas</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2">{{ $stats['activas'] ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-success">
                                <i class="ri-checkbox-circle-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Automáticas</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2">{{ $stats['automaticas'] ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-info">
                                <i class="ri-flashlight-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-sm-6 col-xl-3">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex align-items-start justify-content-between">
                        <div class="content-left">
                            <span class="text-heading d-block">Con Cupones</span>
                            <div class="d-flex align-items-center mt-2">
                                <h4 class="mb-0 me-2">{{ $stats['con_cupones'] ?? 0 }}</h4>
                            </div>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-warning">
                                <i class="ri-coupon-line ri-24px"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros y acciones -->
    <div class="card">
        <div class="card-header border-bottom d-flex flex-column flex-md-row align-items-md-center justify-content-between gap-3">
            <div>
                <h5 class="card-title mb-0">Lista de Promociones</h5>
                <p class="card-subtitle mt-1 mb-0">Gestiona las promociones y descuentos</p>
            </div>
            <div class="d-flex flex-wrap gap-2">
                <div class="input-group w-px-300">
                    <span class="input-group-text"><i class="ri-search-line"></i></span>
                    <input type="text" class="form-control" placeholder="Buscar promociones..." wire:model.live.debounce.300ms="search">
                </div>

                <div class="dropdown">
                    <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="ri-filter-line me-1"></i>Filtros
                    </button>
                    <div class="dropdown-menu p-3" style="min-width: 280px;">
                        <div class="mb-3">
                            <label class="form-label">Estado</label>
                            <select class="form-select" wire:model.live="status">
                                <option value="">Todos los estados</option>
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Tipo de Descuento</label>
                            <select class="form-select" wire:model.live="discountType">
                                <option value="">Todos los tipos</option>
                                <option value="percent">Porcentaje</option>
                                <option value="fixed">Monto Fijo</option>
                                <option value="bxgy">Compra X Lleva Y</option>
                            </select>
                        </div>

                        <div class="mb-0">
                            <label class="form-label">Mostrar</label>
                            <select class="form-select" wire:model.live="perPage">
                                <option value="10">10 por página</option>
                                <option value="25">25 por página</option>
                                <option value="50">50 por página</option>
                            </select>
                        </div>
                    </div>
                </div>

                <a href="{{ route('admin.promociones.create') }}" class="btn btn-primary d-flex align-items-center">
                    <i class="ri-add-line ri-20px me-1"></i>
                    <span class="d-none d-sm-inline-block">Nueva Promoción</span>
                </a>
            </div>
        </div>

        <div class="card-datatable table-responsive">
            <table class="table">
                <thead class="table-light">
                    <tr>
                        <th style="width: 5%">#</th>
                        <th style="width: 25%">Nombre</th>
                        <th style="width: 15%">Tipo</th>
                        <th style="width: 10%">Valor</th>
                        <th style="width: 15%">Vigencia</th>
                        <th style="width: 10%">Usos</th>
                        <th style="width: 10%">Estado</th>
                        <th style="width: 10%">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($promotions as $promotion)
                        <tr>
                            <td>
                                <span class="fw-medium">{{ $promotion->id }}</span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-sm me-3">
                                        <span class="avatar-initial rounded bg-label-{{ $promotion->is_automatic ? 'info' : 'primary' }}">
                                            <i class="ri-{{ $promotion->is_automatic ? 'flashlight-line' : 'price-tag-3-line' }}"></i>
                                        </span>
                                    </div>
                                    <div>
                                        <h6 class="mb-0">{{ $promotion->name }}</h6>
                                        @if($promotion->coupons_count > 0)
                                            <small class="text-muted">{{ $promotion->coupons_count }} cupón(es)</small>
                                        @endif
                                    </div>
                                </div>
                            </td>
                            <td>
                                @switch($promotion->discount_type)
                                    @case('percent')
                                        <span class="badge bg-label-primary">Porcentaje</span>
                                        @break
                                    @case('fixed')
                                        <span class="badge bg-label-success">Monto Fijo</span>
                                        @break
                                    @case('bxgy')
                                        <span class="badge bg-label-warning">{{ $promotion->buy_qty }}x{{ $promotion->get_qty }}</span>
                                        @break
                                @endswitch
                            </td>
                            <td>
                                @if($promotion->discount_type === 'percent')
                                    <span class="fw-medium">{{ number_format($promotion->discount_value, 0) }}%</span>
                                @elseif($promotion->discount_type === 'fixed')
                                    <span class="fw-medium">${{ number_format($promotion->discount_value, 2) }}</span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </td>
                            <td>
                                @if($promotion->starts_at && $promotion->ends_at)
                                    <small>
                                        {{ $promotion->starts_at->format('d/m/Y') }}<br>
                                        {{ $promotion->ends_at->format('d/m/Y') }}
                                    </small>
                                @elseif($promotion->starts_at)
                                    <small>Desde {{ $promotion->starts_at->format('d/m/Y') }}</small>
                                @elseif($promotion->ends_at)
                                    <small>Hasta {{ $promotion->ends_at->format('d/m/Y') }}</small>
                                @else
                                    <span class="text-muted">Sin límite</span>
                                @endif
                            </td>
                            <td>
                                <span class="fw-medium">{{ $promotion->uses_count }}</span>
                                @if($promotion->max_uses)
                                    <span class="text-muted">/ {{ $promotion->max_uses }}</span>
                                @endif
                            </td>
                            <td>
                                <div class="form-check form-switch mb-0">
                                    <input class="form-check-input" type="checkbox"
                                           wire:click="toggleEstado({{ $promotion->id }})"
                                           @if($promotion->is_active) checked @endif
                                           style="cursor: pointer;">
                                </div>
                            </td>
                            <td>
                                <div class="dropdown">
                                    <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                        <i class="ri-more-2-line"></i>
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="{{ route('admin.promociones.edit', $promotion) }}">
                                            <i class="ri-edit-line me-1"></i> Editar
                                        </a>
                                        <a class="dropdown-item" href="{{ route('admin.cupones.index', ['promotion_id' => $promotion->id]) }}">
                                            <i class="ri-coupon-line me-1"></i> Ver Cupones
                                        </a>
                                        <button type="button" class="dropdown-item text-danger"
                                                wire:click="delete({{ $promotion->id }})"
                                                wire:confirm="¿Estás seguro de que deseas eliminar esta promoción?">
                                            <i class="ri-delete-bin-line me-1"></i> Eliminar
                                        </button>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center py-4">
                                <i class="ri-price-tag-3-line fs-1 text-muted mb-2"></i>
                                <p class="mb-0">No se encontraron promociones</p>
                                <p class="text-muted">Crea tu primera promoción para ofrecer descuentos</p>
                                <a href="{{ route('admin.promociones.create') }}" class="btn btn-primary mt-2">
                                    <i class="ri-add-line me-1"></i>
                                    Crear Promoción
                                </a>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="card-footer border-top">
            {{ $promotions->links('livewire.pagination') }}
        </div>
    </div>
</div>
