<div>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Crear Nueva Promoción</h5>
                </div>
                <div class="card-body">
                    <form wire:submit.prevent="save">
                        <!-- Información básica -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-muted mb-3">Información Básica</h6>
                            </div>
                            <div class="col-md-8 mb-3">
                                <label for="name" class="form-label">Nombre de la Promoción *</label>
                                <input type="text"
                                       class="form-control @error('name') is-invalid @enderror"
                                       id="name"
                                       wire:model="name"
                                       placeholder="Ej: Descuento de Verano 20%">
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-md-4 mb-3">
                                <label for="priority" class="form-label">Prioridad</label>
                                <input type="number"
                                       class="form-control"
                                       id="priority"
                                       wire:model="priority"
                                       min="0"
                                       placeholder="0">
                                <small class="text-muted">Mayor número = mayor prioridad</small>
                            </div>

                            <div class="col-12 mb-3">
                                <label for="description" class="form-label">Descripción</label>
                                <textarea class="form-control @error('description') is-invalid @enderror"
                                          id="description"
                                          wire:model="description"
                                          rows="2"
                                          placeholder="Descripción opcional de la promoción"></textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Tipo de descuento -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-muted mb-3">Tipo de Descuento</h6>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="discount_type" class="form-label">Tipo *</label>
                                <select class="form-select @error('discount_type') is-invalid @enderror"
                                        id="discount_type"
                                        wire:model.live="discount_type">
                                    <option value="percent">Porcentaje (%)</option>
                                    <option value="fixed">Monto Fijo ($)</option>
                                    <option value="bxgy">Compra X Lleva Y</option>
                                </select>
                                @error('discount_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            @if($discount_type !== 'bxgy')
                                <div class="col-md-4 mb-3">
                                    <label for="discount_value" class="form-label">Valor del Descuento *</label>
                                    <div class="input-group">
                                        <input type="number"
                                               class="form-control @error('discount_value') is-invalid @enderror"
                                               id="discount_value"
                                               wire:model="discount_value"
                                               step="0.01"
                                               min="0"
                                               placeholder="0.00">
                                        <span class="input-group-text">{{ $discount_type === 'percent' ? '%' : '$' }}</span>
                                        @error('discount_value')
                                            <div class="invalid-feedback">{{ $message }}</div>
                                        @enderror
                                    </div>
                                </div>
                            @else
                                <div class="col-md-4 mb-3">
                                    <label for="buy_qty" class="form-label">Compra (cantidad) *</label>
                                    <input type="number"
                                           class="form-control @error('buy_qty') is-invalid @enderror"
                                           id="buy_qty"
                                           wire:model="buy_qty"
                                           min="1"
                                           placeholder="2">
                                    @error('buy_qty')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="get_qty" class="form-label">Lleva Gratis (cantidad) *</label>
                                    <input type="number"
                                           class="form-control @error('get_qty') is-invalid @enderror"
                                           id="get_qty"
                                           wire:model="get_qty"
                                           min="1"
                                           placeholder="1">
                                    @error('get_qty')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            @endif
                        </div>

                        <!-- Vigencia -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-muted mb-3">Vigencia</h6>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="starts_at" class="form-label">Fecha de Inicio</label>
                                <input type="datetime-local"
                                       class="form-control @error('starts_at') is-invalid @enderror"
                                       id="starts_at"
                                       wire:model="starts_at">
                                @error('starts_at')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="ends_at" class="form-label">Fecha de Fin</label>
                                <input type="datetime-local"
                                       class="form-control @error('ends_at') is-invalid @enderror"
                                       id="ends_at"
                                       wire:model="ends_at">
                                @error('ends_at')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>

                        <!-- Límites de uso -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-muted mb-3">Límites de Uso</h6>
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="max_uses" class="form-label">Usos Máximos (Total)</label>
                                <input type="number"
                                       class="form-control"
                                       id="max_uses"
                                       wire:model="max_uses"
                                       min="1"
                                       placeholder="Sin límite">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="max_uses_per_user" class="form-label">Usos por Usuario</label>
                                <input type="number"
                                       class="form-control"
                                       id="max_uses_per_user"
                                       wire:model="max_uses_per_user"
                                       min="1"
                                       placeholder="Sin límite">
                            </div>
                            <div class="col-md-4 mb-3">
                                <label for="min_amount" class="form-label">Monto Mínimo de Compra</label>
                                <div class="input-group">
                                    <span class="input-group-text">$</span>
                                    <input type="number"
                                           class="form-control"
                                           id="min_amount"
                                           wire:model="min_amount"
                                           step="0.01"
                                           min="0"
                                           placeholder="0.00">
                                </div>
                            </div>
                        </div>

                        <!-- Opciones -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-muted mb-3">Opciones</h6>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="is_active" wire:model="is_active">
                                    <label class="form-check-label" for="is_active">Promoción Activa</label>
                                </div>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="is_automatic" wire:model="is_automatic">
                                    <label class="form-check-label" for="is_automatic">Aplicar Automáticamente</label>
                                </div>
                                <small class="text-muted">Se aplica sin necesidad de código</small>
                            </div>
                            <div class="col-md-4 mb-3">
                                <div class="form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="stackable" wire:model="stackable">
                                    <label class="form-check-label" for="stackable">Acumulable</label>
                                </div>
                                <small class="text-muted">Puede combinarse con otras</small>
                            </div>
                        </div>

                        <!-- Productos y Categorías -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h6 class="text-muted mb-3">Aplicar a (Opcional)</h6>
                                <p class="text-muted small">Deja vacío para aplicar a todos los productos</p>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Productos Específicos</label>
                                <select class="form-select" wire:model="selectedProducts" multiple size="5">
                                    @foreach($productos as $producto)
                                        <option value="{{ $producto->id }}">{{ $producto->nombre }} ({{ $producto->sku }})</option>
                                    @endforeach
                                </select>
                                <small class="text-muted">Mantén Ctrl para seleccionar varios</small>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label">Categorías</label>
                                <select class="form-select" wire:model="selectedCategories" multiple size="5">
                                    @foreach($categorias as $categoria)
                                        <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                                    @endforeach
                                </select>
                                <small class="text-muted">Mantén Ctrl para seleccionar varias</small>
                            </div>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary">
                                <i class="ri-save-line me-1"></i>
                                Guardar Promoción
                            </button>

                            <a href="{{ route('admin.promociones.index') }}" class="btn btn-secondary">
                                <i class="ri-arrow-left-line me-1"></i>
                                Cancelar
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
