<div>
    <!-- Breadcrumb -->
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0 font-size-18">Detalle del Producto</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item">
                            <a href="{{ route('admin.productos.index') }}">Productos</a>
                        </li>
                        <li class="breadcrumb-item active">{{ $producto->name ?? 'Detalle' }}</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    @if(!$producto)
        {{-- Producto no encontrado --}}
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <div class="text-center">
                            <div class="mb-4">
                                <i class=" ri-shopping-bag-line text-warning"></i>
                            </div>
                            <h5 class="text-warning mb-3">Producto no encontrado</h5>
                            <p class="text-muted mb-4">El producto que estás buscando no existe o no tienes permisos para verlo.</p>
                            <a href="{{ route('admin.productos.index') }}" class="btn btn-primary">
                                <i class=" ri-shopping-bag-line me-1"></i> Volver al listado
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @else
        {{-- Detalle del producto --}}
        <div class="row">
            <div class="col-lg-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Información Básica
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Código:</td>
                                        <td>
                                            <span class="badge bg-secondary">{{ $producto->code }}</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Nombre:</td>
                                        <td class="text-dark fw-medium">{{ $producto->name }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Descripción:</td>
                                        <td class="text-muted">{{ $producto->description ?? 'Sin descripción' }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">SKU:</td>
                                        <td class="text-muted">{{ $producto->sku ?? 'No asignado' }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Estado:</td>
                                        <td>{!! $this->statusBadge !!}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Categoría:</td>
                                        <td>
                                            @if($producto->categoria)
                                                <span class="badge bg-primary">{{ $producto->categoria->name }}</span>
                                            @else
                                                <span class="text-muted">Sin categoría</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Marca:</td>
                                        <td>
                                            @if($producto->marca)
                                                <span class="badge bg-secondary">{{ $producto->marca->name }}</span>
                                            @else
                                                <span class="text-muted">Sin marca</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Empresa:</td>
                                        <td>
                                            @if($producto->empresa)
                                                <span class="badge bg-dark">{{ $producto->empresa->name }}</span>
                                            @else
                                                <span class="text-muted">Sin empresa</span>
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Precios y Stock
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Precio USD:</td>
                                        <td class="text-success fw-bold">{{ $this->priceWithCurrency }}</td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Precio Bs:</td>
                                        <td class="text-success fw-bold">{{ $this->priceBsWithCurrency }}</td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless mb-0">
                                    <tr>
                                        <td class="fw-semibold">Stock Actual:</td>
                                        <td>
                                            <span class="badge bg-info">{{ $producto->quantity }} unidades</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Alerta de Stock:</td>
                                        <td>
                                            <span class="badge bg-warning">{{ $producto->quantity_alert }} unidades</span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="fw-semibold">Estado Stock:</td>
                                        <td>{!! $this->stockStatus !!}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class=" ri-shopping-bag-line me-2"></i>
                                Galería de Imágenes
                            </h5>
                            <span class="badge bg-info">{{ $producto->images->count() }} imágenes</span>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($producto->images->isNotEmpty())
                            <div class="row g-3">
                                @foreach($producto->images as $image)
                                    <div class="col-md-6 col-lg-4">
                                        <div class="card border h-100">
                                            <div class="position-relative">
                                                <img src="{{ Storage::url($image->path) }}"
                                                     alt="{{ $image->alt_text ?? $producto->name }}"
                                                     class="card-img-top"
                                                     style="height: 150px; object-fit: cover;">
                                                @if($image->featured)
                                                    <span class="position-absolute top-0 start-0 translate-middle badge bg-warning m-2">
                                                        <i class=" ri-shopping-bag-line"></i> Principal
                                                    </span>
                                                @endif
                                            </div>
                                            <div class="card-body p-2 text-center">
                                                <small class="text-muted">
                                                    {{ $image->featured ? 'Imagen Principal' : 'Imagen Secundaria' }}
                                                </small>
                                                @if($image->alt_text)
                                                    <div class="mt-1">
                                                        <small class="text-dark">{{ $image->alt_text }}</small>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-5">
                                <i class=" ri-shopping-bag-line text-muted"></i>
                                <p class="text-muted mt-2 mb-0">Este producto no tiene imágenes asociadas.</p>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h5 class="mb-0">
                                <i class=" ri-shopping-bag-line me-2"></i>
                                Variantes del Producto
                            </h5>
                            <span class="badge bg-info">{{ $producto->variants->count() }} variantes</span>
                        </div>
                    </div>
                    <div class="card-body">
                        @if($producto->variants->isNotEmpty())
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Variante</th>
                                            <th class="text-center">Stock</th>
                                            <th class="text-center">Estado</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($producto->variants as $variant)
                                            <tr>
                                                <td>
                                                    @php
                                                        $values = null;
                                                        if (is_array($variant->values)) {
                                                            $values = $variant->values;
                                                        } elseif (is_string($variant->values)) {
                                                            $values = json_decode($variant->values, true);
                                                        } else {
                                                            $values = (array) $variant->values;
                                                        }

                                                        // Si la decodificación falló o no es array, envolver en array
                                                        if (!is_array($values)) {
                                                            $values = [$variant->values];
                                                        }
                                                    @endphp
                                                    @foreach($values as $value)
                                                        <span class="badge bg-light text-dark me-1">{{ $value }}</span>
                                                    @endforeach
                                                </td>
                                                <td class="text-center">
                                                    <span class="badge bg-secondary">{{ $variant->quantity }}</span>
                                                </td>
                                                <td class="text-center">
                                                    {!! $this->getVariantStockStatus($variant->quantity) !!}
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-4">
                                <i class=" ri-shopping-bag-line text-muted"></i>
                                <p class="text-muted mt-2 mb-0">Este producto no tiene variantes configuradas.</p>
                            </div>
                        @endif
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Inventario
                        </h5>
                    </div>
                    <div class="card-body">
                        <table class="table table-borderless mb-0">
                            <tr>
                                <td class="fw-semibold">Política de Inventario:</td>
                                <td>
                                    <span class="badge bg-info">{{ $this->inventoryPolicyText }}</span>
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-semibold">Stock Total:</td>
                                <td>
                                    @if($this->hasVariants)
                                        <span class="badge bg-success">{{ $this->totalVariantStock }} unidades</span>
                                        <div class="small text-muted">(en variantes)</div>
                                    @else
                                        <span class="badge bg-success">{{ $producto->quantity }} unidades</span>
                                        <div class="small text-muted">(producto principal)</div>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td class="fw-semibold">Alerta de Stock:</td>
                                <td>
                                    <span class="badge bg-warning">{{ $producto->quantity_alert }} unidades</span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            SEO
                        </h5>
                    </div>
                    <div class="card-body">
                        @if($producto->seo)
                            <table class="table table-borderless mb-3">
                                <tr>
                                    <td class="fw-semibold">Título Meta:</td>
                                    <td class="text-dark">{{ $producto->seo->meta_title ?? 'No configurado' }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Descripción Meta:</td>
                                    <td class="text-muted">{{ $producto->seo->meta_description ?? 'No configurada' }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-semibold">Slug:</td>
                                    <td>
                                        <code class="text-primary">{{ $producto->seo->slug ?? 'No configurado' }}</code>
                                    </td>
                                </tr>
                            </table>

                            <div class="border rounded p-3 bg-light">
                                <h6 class="text-primary mb-2" style="color: #1a0dab;">
                                    {{ $producto->seo->meta_title ?? $producto->name }}
                                </h6>
                                <p class="text-success mb-2" style="color: #006621;">
                                    {{ url('/') }}/producto/{{ $producto->seo->slug ?? $producto->code }}
                                </p>
                                <p class="text-muted small mb-0">
                                    {{ $producto->seo->meta_description ?? Str::limit($producto->description, 160) }}
                                </p>
                            </div>
                        @else
                            <div class="alert alert-info mb-0">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                No hay configuración SEO disponible para este producto.
                            </div>
                        @endif
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">
                            <i class=" ri-shopping-bag-line me-2"></i>
                            Acciones
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <a href="{{ route('admin.productos.index') }}" class="btn btn-outline-secondary">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                Volver a Productos
                            </a>
                            <a href="{{ route('admin.productos.edit', $producto->id) }}" class="btn btn-primary">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                Editar Producto
                            </a>
                            <button type="button" class="btn btn-outline-danger" onclick="confirmDelete()">
                                <i class=" ri-shopping-bag-line me-1"></i>
                                Eliminar Producto
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@push('scripts')
<script>
function confirmDelete() {
    if (confirm('¿Está seguro de eliminar este producto? Esta acción no se puede deshacer.')) {
        @this.call('deleteProduct', {{ $producto->id }});
    }
}
</script>
@endpush

@push('styles')
<style>
.card {
    border-radius: 0.5rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    border: 1px solid rgba(0, 0, 0, 0.125);
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid rgba(0, 0, 0, 0.125);
    border-radius: calc(0.5rem - 1px) calc(0.5rem - 1px) 0 0 !important;
    padding: 1rem 1.25rem;
}

.card-header h5 {
    margin: 0;
    font-size: 1.1rem;
    font-weight: 600;
}

.table-borderless td {
    padding: 0.5rem 0;
}

.table-borderless tr:first-child td {
    padding-top: 0;
}

.table-borderless tr:last-child td {
    padding-bottom: 0;
}

.badge {
    font-weight: 500;
}

.text-muted {
    color: #6c757d !important;
}

.text-dark {
    color: #212529 !important;
}

.btn-outline-danger:hover {
    color: #fff;
    background-color: #dc3545;
    border-color: #dc3545;
}

.page-title-box {
    background-color: #fff;
    border-radius: 0.5rem;
    padding: 1rem 1.25rem;
    margin-bottom: 1.5rem;
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
}
</style>
@endpush
