<div>
    <!-- Información del Producto -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card bg-gradient-primary text-white">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <div class="d-flex align-items-center">
                                @if($producto->images->first())
                                    <img src="{{ asset('app/'.$producto->images->first()->path) }}" 
                                         alt="{{ $producto->name }}" 
                                         class="rounded me-3 border border-white" width="80" height="80">
                                @endif
                                <div>
                                    <h3 class="mb-2 text-white">{{ $producto->name }}</h3>
                                    <div class="d-flex gap-3 mb-2">
                                        <span class="badge bg-white text-primary">{{ $producto->code }}</span>
                                        <span class="badge bg-white text-primary">{{ $producto->categoria->nombre ?? 'Sin categoría' }}</span>
                                        <span class="badge bg-white text-primary">{{ $producto->marca->nombre ?? 'Sin marca' }}</span>
                                    </div>
                                    <p class="text-white-50 mb-0">{{ $producto->description }}</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row text-center mb-3">
                                <div class="col-4">
                                    <h2 class="text-white mb-0">{{ $producto->quantity }}</h2>
                                    <small class="text-white-75">Stock Actual</small>
                                </div>
                                <div class="col-4">
                                    <h2 class="text-warning mb-0">{{ $producto->quantity_alert }}</h2>
                                    <small class="text-white-75">Stock Mínimo</small>
                                </div>
                                <div class="col-4">
                                    <h2 class="text-success mb-0">{{ format_money($producto->price) }}</h2>
                                    <small class="text-white-75">Precio</small>
                                </div>
                            </div>
                            <div class="d-flex gap-2">
                                <button wire:click="openAdjustModal" class="btn btn-light btn-sm">
                                    <i class="ri-settings-3-line me-1"></i>
                                    Ajustar
                                </button>
                                <button wire:click="openBulkModal" class="btn btn-outline-light btn-sm">
                                    <i class="ri-add-line me-1"></i>
                                    Movimiento
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Estadísticas -->
    <div class="row mb-4">
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-body text-center">
                    <div class="avatar mx-auto mb-3">
                        <span class="avatar-initial rounded-circle bg-label-primary">
                            <i class="ri-history-line ri-24px"></i>
                        </span>
                    </div>
                    <h4 class="mb-1">{{ $stats['total_movements'] ?? 0 }}</h4>
                    <p class="text-muted mb-0">Total Movimientos</p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-body text-center">
                    <div class="avatar mx-auto mb-3">
                        <span class="avatar-initial rounded-circle bg-label-success">
                            <i class="ri-arrow-up-line ri-24px"></i>
                        </span>
                    </div>
                    <h4 class="mb-1 text-success">+{{ $stats['total_ingresos'] ?? 0 }}</h4>
                    <p class="text-muted mb-0">Total Ingresos</p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-body text-center">
                    <div class="avatar mx-auto mb-3">
                        <span class="avatar-initial rounded-circle bg-label-danger">
                            <i class="ri-arrow-down-line ri-24px"></i>
                        </span>
                    </div>
                    <h4 class="mb-1 text-danger">-{{ $stats['total_salidas'] ?? 0 }}</h4>
                    <p class="text-muted mb-0">Total Salidas</p>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-3">
            <div class="card h-100">
                <div class="card-body text-center">
                    <div class="avatar mx-auto mb-3">
                        <span class="avatar-initial rounded-circle bg-label-info">
                            <i class="ri-money-dollar-circle-line ri-24px"></i>
                        </span>
                    </div>
                    <h4 class="mb-1 text-info">{{ format_money($stats['valor_inventario'] ?? 0) }}</h4>
                    <p class="text-muted mb-0">Valor Inventario</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Gráfico de Movimientos -->
    @if(!empty($chartData))
    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Movimientos por Día</h5>
                    <small class="text-muted">Últimos 30 días</small>
                </div>
                <div class="card-body">
                    <canvas id="movementsChart" height="100"></canvas>
                </div>
            </div>
        </div>
    </div>
    @endif

    <!-- Filtros Avanzados -->
    <div class="card mb-4">
        <div class="card-header">
            <h5 class="mb-0">Filtros y Búsqueda</h5>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Tipo de Movimiento</label>
                    <select wire:model.live="filterType" class="form-select">
                        <option value="">Todos los movimientos</option>
                        <option value="ingreso">📈 Ingresos</option>
                        <option value="salida">📉 Salidas</option>
                        <option value="venta">💰 Ventas</option>
                        <option value="compra">🛒 Compras</option>
                        <option value="devolucion">↩️ Devoluciones</option>
                        <option value="ajuste">⚙️ Ajustes</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Desde</label>
                    <input type="date" wire:model.live="filterDateFrom" class="form-control">
                </div>
                <div class="col-md-2">
                    <label class="form-label">Hasta</label>
                    <input type="date" wire:model.live="filterDateTo" class="form-control">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Usuario</label>
                    <select wire:model.live="filterUser" class="form-select">
                        <option value="">Todos los usuarios</option>
                        @foreach($users as $user)
                            <option value="{{ $user->id }}">{{ $user->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">Por página</label>
                    <select wire:model.live="perPage" class="form-select">
                        <option value="15">15</option>
                        <option value="25">25</option>
                        <option value="50">50</option>
                    </select>
                </div>
            </div>
        </div>
    </div>

    <!-- Historial de Movimientos -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Historial de Movimientos</h5>
            <div class="d-flex gap-2">
                <small class="text-muted align-self-center">{{ $movements->total() }} registros</small>
            </div>
        </div>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th wire:click="sortBy('created_at')" style="cursor: pointer;">
                            Fecha
                            @if($sortField === 'created_at')
                                <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                            @endif
                        </th>
                        <th wire:click="sortBy('type')" style="cursor: pointer;">
                            Tipo
                            @if($sortField === 'type')
                                <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                            @endif
                        </th>
                        <th wire:click="sortBy('quantity')" style="cursor: pointer;">
                            Cantidad
                            @if($sortField === 'quantity')
                                <i class="ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                            @endif
                        </th>
                        <th>Stock</th>
                        <th>Costo</th>
                        <th>Referencia</th>
                        <th>Usuario</th>
                        <th>Notas</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($movements as $movement)
                    <tr class="align-middle">
                        <td>
                            <div>
                                <strong>{{ $movement->created_at->format('d/m/Y') }}</strong>
                                <br>
                                <small class="text-muted">{{ $movement->created_at->format('H:i:s') }}</small>
                                <br>
                                <small class="text-muted">{{ $movement->created_at->diffForHumans() }}</small>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-{{ $movement->type_color }} fs-6">
                                <i class="{{ $movement->type_icon }} me-1"></i>
                                {{ ucfirst($movement->type) }}
                            </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <span class="fw-bold fs-5 {{ $movement->quantity > 0 ? 'text-success' : 'text-danger' }}">
                                    {{ $movement->quantity > 0 ? '+' : '' }}{{ $movement->quantity }}
                                </span>
                            </div>
                        </td>
                        <td>
                            <div class="text-center">
                                <small class="text-muted d-block">Antes: {{ $movement->quantity_before }}</small>
                                <strong class="text-primary">Después: {{ $movement->quantity_after }}</strong>
                            </div>
                        </td>
                        <td>
                            @if($movement->total_cost)
                                <div>
                                    <strong>{{ format_money($movement->total_cost) }}</strong>
                                    @if($movement->unit_cost)
                                        <br><small class="text-muted">({{ format_money($movement->unit_cost) }}/u)</small>
                                    @endif
                                </div>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($movement->reference)
                                <span class="badge bg-label-info">{{ $movement->reference }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm me-2">
                                    <span class="avatar-initial rounded-circle bg-label-primary">
                                        {{ substr($movement->user->name, 0, 1) }}
                                    </span>
                                </div>
                                <div>
                                    <div class="fw-bold">{{ $movement->user->name }}</div>
                                    <small class="text-muted">{{ $movement->user->roles->first()?->name ?? 'Usuario' }}</small>
                                </div>
                            </div>
                        </td>
                        <td>
                            @if($movement->notes)
                                <span class="text-muted" title="{{ $movement->notes }}">{{ Str::limit($movement->notes, 30) }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="8" class="text-center py-5">
                            <div class="text-muted">
                                <i class="ri-history-line" style="font-size: 3rem;"></i>
                                <h5 class="mt-3">No hay movimientos registrados</h5>
                                <p>Los movimientos de inventario aparecerán aquí cuando se registren.</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($movements->hasPages())
        <div class="card-footer">
            {{ $movements->links() }}
        </div>
        @endif
    </div>

    <!-- Modal de Movimiento Masivo -->
    @if($showBulkModal)
    <div class="modal fade show" style="display: block;" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Registrar Movimiento de Inventario</h5>
                    <button type="button" class="btn-close" wire:click="closeBulkModal"></button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Tipo de Movimiento</label>
                            <select wire:model="bulkType" class="form-select">
                                <option value="ingreso">Ingreso</option>
                                <option value="salida">Salida</option>
                                <option value="compra">Compra</option>
                                <option value="venta">Venta</option>
                                <option value="devolucion">Devolución</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Cantidad</label>
                            <input type="number" wire:model="bulkQuantity" class="form-control" min="1">
                            @error('bulkQuantity') <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Costo Unitario (Opcional)</label>
                            <input type="number" wire:model="bulkCost" class="form-control" step="0.01" min="0">
                            @error('bulkCost') <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">Referencia (Opcional)</label>
                            <input type="text" wire:model="bulkReference" class="form-control" placeholder="Número de factura, pedido, etc.">
                            @error('bulkReference') <div class="text-danger">{{ $message }}</div> @enderror
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Notas (Opcional)</label>
                        <textarea wire:model="bulkNotes" class="form-control" rows="3" placeholder="Describe el motivo del movimiento..."></textarea>
                        @error('bulkNotes') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>
                    
                    @if($bulkQuantity > 0)
                    <div class="alert alert-info">
                        <h6>Resumen del Movimiento:</h6>
                        <ul class="mb-0">
                            <li><strong>Tipo:</strong> {{ ucfirst($bulkType) }}</li>
                            <li><strong>Cantidad:</strong> {{ in_array($bulkType, ['salida', 'venta']) ? '-' : '+' }}{{ $bulkQuantity }}</li>
                            <li><strong>Stock actual:</strong> {{ $producto->quantity }}</li>
                            <li><strong>Stock resultante:</strong> 
                                {{ in_array($bulkType, ['salida', 'venta']) ? $producto->quantity - $bulkQuantity : $producto->quantity + $bulkQuantity }}
                            </li>
                            @if($bulkCost > 0)
                                <li><strong>Costo total:</strong> {{ format_money($bulkCost * $bulkQuantity) }}</li>
                            @endif
                        </ul>
                    </div>
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeBulkModal">Cancelar</button>
                    <button type="button" class="btn btn-primary" wire:click="processBulkMovement">
                        <i class="ri-save-line me-1"></i>
                        Registrar Movimiento
                    </button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif

    <!-- Modal de Ajuste de Inventario -->
    @if($showAdjustModal)
    <div class="modal fade show" style="display: block;" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ajustar Inventario</h5>
                    <button type="button" class="btn-close" wire:click="closeAdjustModal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Stock Actual</label>
                        <input type="text" class="form-control" value="{{ $producto->quantity }}" readonly>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nueva Cantidad</label>
                        <input type="number" wire:model="adjustQuantity" class="form-control" min="0">
                        @error('adjustQuantity') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Motivo del Ajuste</label>
                        <textarea wire:model="adjustReason" class="form-control" rows="3" placeholder="Describe el motivo del ajuste..."></textarea>
                        @error('adjustReason') <div class="text-danger">{{ $message }}</div> @enderror
                    </div>
                    <div class="alert alert-info">
                        <strong>Diferencia:</strong> 
                        {{ $adjustQuantity - $producto->quantity > 0 ? '+' : '' }}{{ $adjustQuantity - $producto->quantity }}
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" wire:click="closeAdjustModal">Cancelar</button>
                    <button type="button" class="btn btn-primary" wire:click="adjustInventory">Ajustar Inventario</button>
                </div>
            </div>
        </div>
    </div>
    <div class="modal-backdrop fade show"></div>
    @endif
</div>

@push('styles')
<style>
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.text-white-75 {
    color: rgba(255, 255, 255, 0.75) !important;
}

.avatar {
    width: 2.375rem;
    height: 2.375rem;
    display: flex;
    align-items: center;
    justify-content: center;
}

.avatar-sm {
    width: 1.875rem;
    height: 1.875rem;
}

.avatar-initial {
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: 600;
}

.table th {
    border-top: 0;
    font-weight: 600;
    font-size: 0.875rem;
}

.badge {
    font-size: 0.75rem;
}

.card {
    box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
    border: 1px solid rgba(0, 0, 0, 0.125);
}

.table-hover tbody tr:hover {
    background-color: rgba(0, 0, 0, 0.025);
}

.modal-backdrop {
    background-color: rgba(0, 0, 0, 0.5);
}
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    @if(!empty($chartData))
    const ctx = document.getElementById('movementsChart');
    if (ctx) {
        const chartData = @json($chartData);
        
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: chartData.map(item => item.date),
                datasets: [{
                    label: 'Ingresos',
                    data: chartData.map(item => item.ingresos),
                    borderColor: 'rgb(34, 197, 94)',
                    backgroundColor: 'rgba(34, 197, 94, 0.1)',
                    tension: 0.4,
                    fill: true
                }, {
                    label: 'Salidas',
                    data: chartData.map(item => item.salidas),
                    borderColor: 'rgb(239, 68, 68)',
                    backgroundColor: 'rgba(239, 68, 68, 0.1)',
                    tension: 0.4,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                    },
                    title: {
                        display: false
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            color: 'rgba(0, 0, 0, 0.1)'
                        }
                    },
                    x: {
                        grid: {
                            color: 'rgba(0, 0, 0, 0.1)'
                        }
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index'
                }
            }
        });
    }
    @endif
});
</script>
@endpush