
<div>
    <div>
        <!-- Encabezado -->
        <div class="row">
            <div class="col-12 mb-4">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h4 class="fw-bold py-3 mb-0">Gestión de Productos</h4>
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb breadcrumb-style1">
                                <li class="breadcrumb-item">
                                    <a href="{{ route('admin.dashboard') }}">Dashboard</a>
                                </li>
                                <li class="breadcrumb-item active">Productos</li>
                            </ol>
                        </nav>
                    </div>
                    <div class="d-flex gap-2">
                        <button wire:click="exportSelected" class="btn btn-outline-primary">
                            <i class=" ri-download-line me-1"></i>
                            Exportar
                        </button>
                        <button wire:click="deleteSelected" class="btn btn-outline-danger"
                                @if(empty($selectedProductos)) disabled @endif
                                onclick="confirm('¿Estás seguro de eliminar los productos seleccionados?') || event.stopImmediatePropagation()">
                            <i class=" ri-delete-bin-line me-1"></i>
                            Eliminar Seleccionados ({{ count($selectedProductos ?? []) }})
                        </button>
                        <a href="{{ route('admin.productos.create') }}" class="btn btn-primary">
                            <i class=" ri-add-line me-1"></i>
                            Agregar Producto
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Estadísticas de Productos -->
        <div class="row mb-4">
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="content-left">
                                <span class="text-heading d-block mb-1">Total Productos</span>
                                <div class="d-flex align-items-center">
                                    <h3 class="text-primary mb-0">{{ $stats['total'] }}</h3>
                                    <span class="badge bg-label-success ms-2">{{ $stats['cambio_total'] }}</span>
                                </div>
                                <small class="text-muted">{{ $salesStats['ordenes_totales'] }} órdenes</small>
                            </div>
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-primary">
                                    <i class=" ri-shopping-bag-line"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="content-left">
                                <span class="text-heading d-block mb-1">Productos Activos</span>
                                <div class="d-flex align-items-center">
                                    <h3 class="text-success mb-0">{{ $stats['activos'] }}</h3>
                                    <span class="badge bg-label-success ms-2">{{ $stats['cambio_activos'] }}</span>
                                </div>
                                <small class="text-muted">Disponibles para venta</small>
                            </div>
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-success">
                                    <i class=" ri-checkbox-circle-line"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div class="content-left">
                                <span class="text-heading d-block mb-1">Bajo Stock</span>
                                <div class="d-flex align-items-center">
                                    <h3 class="text-warning mb-0">{{ $stats['bajo_stock'] }}</h3>
                                    <span class="badge bg-label-success ms-2">{{ $stats['cambio_bajo_stock'] }}</span>
                                </div>
                                <small class="text-muted">Necesitan reabastecimiento</small>
                            </div>
                            <div class="avatar">
                                <span class="avatar-initial rounded bg-label-warning">
                                    <i class=" ri-alert-line ri-md"></i>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>


        <div class="col-lg-3 col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-start">
                        <div class="content-left">
                            <span class="text-heading d-block mb-1">Sin Stock</span>
                            <div class="d-flex align-items-center">
                                <h3 class="text-danger mb-0">{{ $stats['sin_stock'] }}</h3>
                            </div>
                            <small class="text-muted">Agotados temporalmente</small>
                        </div>
                        <div class="avatar">
                            <span class="avatar-initial rounded bg-label-danger">
                                <i class=" ri-close-circle-line ri-md"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filtros y Búsqueda -->
    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Filtros de Productos</h5>
            <button wire:click="$toggle('showAdvancedFilters')" class="btn btn-sm btn-outline-primary">
                <i class=" ri-settings-3-line me-1"></i>
                Filtros Avanzados
            </button>
        </div>
        <div class="card-body">
            <div class="row">
                <!-- Búsqueda -->
                <div class="col-md-4 mb-3">
                    <label class="form-label">Búsqueda</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class=" ri-search-line"></i></span>
                        <input type="text" wire:model.live="search" class="form-control" placeholder="Buscar por nombre, código o descripción...">
                    </div>
                </div>

                <!-- Estado -->
                <div class="col-md-2 mb-3">
                    <label class="form-label">Estado</label>
                    <select wire:model.live="status" class="form-select">
                        <option value="">Todos</option>
                        <option value="1">Activo</option>
                        <option value="0">Inactivo</option>
                    </select>
                </div>

                <!-- Categoría -->
                <div class="col-md-2 mb-3">
                    <label class="form-label">Categoría</label>
                    <select wire:model.live="categoria_id" class="form-select">
                        <option value="">Todas</option>
                        @foreach($categorias as $categoria)
                            <option value="{{ $categoria->id }}">{{ $categoria->nombre }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Marca -->
                <div class="col-md-2 mb-3">
                    <label class="form-label">Marca</label>
                    <select wire:model.live="marca_id" class="form-select">
                        <option value="">Todas</option>
                        @foreach($marcas as $marca)
                            <option value="{{ $marca->id }}">{{ $marca->nombre }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Stock -->
                <div class="col-md-2 mb-3">
                    <label class="form-label">Stock</label>
                    <select wire:model.live="stock_filter" class="form-select">
                        <option value="">Todos</option>
                        <option value="in">En Stock</option>
                        <option value="low">Bajo Stock</option>
                        <option value="out">Sin Stock</option>
                    </select>
                </div>
            </div>

            <!-- Filtros Avanzados -->
            @if($showAdvancedFilters)
            <div class="row mt-3 border-top pt-3">
                <div class="col-md-3 mb-3">
                    <label class="form-label">Precio Mínimo</label>
                    <input type="number" wire:model.live="precio_min" class="form-control" placeholder="0.00" step="0.01">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Precio Máximo</label>
                    <input type="number" wire:model.live="precio_max" class="form-control" placeholder="9999.99" step="0.01">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Desde Fecha</label>
                    <input type="date" wire:model.live="fecha_desde" class="form-control">
                </div>
                <div class="col-md-3 mb-3">
                    <label class="form-label">Hasta Fecha</label>
                    <input type="date" wire:model.live="fecha_hasta" class="form-control">
                </div>
            </div>
            @endif

            <!-- Botones de acción -->
            <div class="row mt-3">
                <div class="col-12">
                    <button wire:click="resetFilters" class="btn btn-outline-secondary">
                        <i class=" ri-refresh-line me-1"></i>
                        Limpiar Filtros
                    </button>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabla de Productos -->
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Lista de Productos</h5>
            <div class="d-flex align-items-center gap-2">
                <small class="text-muted">Mostrar</small>
                <select wire:model.live="perPage" class="form-select form-select-sm" style="width: auto;">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
                <small class="text-muted">registros</small>
            </div>
        </div>

        <div class="table-responsive text-nowrap">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th width="50">
                            <input type="checkbox" wire:model.live="selectAll" class="form-check-input">
                        </th>
                        <th wire:click="sortBy('code')" style="cursor: pointer;">
                            Código
                            @if($sortField === 'code')
                                <i class=" ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                            @endif
                        </th>
                        <th wire:click="sortBy('name')" style="cursor: pointer;">
                            Producto
                            @if($sortField === 'name')
                                <i class=" ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                            @endif
                        </th>
                        <th>Categoría</th>
                        <th>Marca</th>
                        <th wire:click="sortBy('price')" style="cursor: pointer;">
                            Precio
                            @if($sortField === 'price')
                                <i class=" ri-arrow-{{ $sortDirection === 'asc' ? 'up' : 'down' }}-line"></i>
                            @endif
                        </th>
                        <th>Stock</th>
                        <th>Estado</th>
                        <th width="150">Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($productos as $producto)
                    <tr>
                        <td>
                            <input type="checkbox" wire:model.live="selectedProductos" value="{{ $producto->id }}" class="form-check-input">
                        </td>
                        <td>
                            <span class="text-primary fw-bold">{{ $producto->code }}</span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                @if($producto->images->first())
                                    <img src="{{ asset('app/'.$producto->images->first()->path) }}"
                                         alt="{{ $producto->name }}"
                                         class="rounded me-3" width="40" height="40">
                                @else
                                    <div class="rounded me-3 bg-label-secondary d-flex align-items-center justify-content-center"
                                         style="width: 40px; height: 40px;">
                                        <i class=" ri-image-line text-muted"></i>
                                    </div>
                                @endif
                                <div>
                                    <h6 class="mb-0">{{ $producto->name }}</h6>
                                    <small class="text-muted">{{ Str::limit($producto->description, 50) }}</small>
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="badge bg-label-info">{{ $producto->categoria->nombre ?? 'Sin categoría' }}</span>
                        </td>
                        <td>
                            <span class="badge bg-label-secondary">{{ $producto->marca->nombre ?? 'Sin marca' }}</span>
                        </td>
                        <td>
                            <span class="text-primary fw-bold">{{ format_money($producto->price, 2) }}</span>
                        </td>
                        <td>
                            @if($producto->quantity == 0)
                                <span class="badge bg-danger">Sin stock</span>
                            @elseif($producto->quantity <= $producto->quantity_alert)
                                <span class="badge bg-warning">{{ $producto->quantity }}</span>
                            @else
                                <span class="badge bg-success">{{ $producto->quantity }}</span>
                            @endif
                        </td>
                        <td>
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" 
                                       wire:click="toggleStatus({{ $producto->id }})"
                                       {{ $producto->status ? 'checked' : '' }}>
                                <label class="form-check-label">
                                    {{ $producto->status ? 'Activo' : 'Inactivo' }}
                                </label>
                            </div>
                        </td>
                        <td>
                            <div class="dropdown">
                                <button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                    <i class=" ri-more-2-line"></i>
                                </button>
                                <div class="dropdown-menu">
                                    @can('view product details')
                                    <a class="dropdown-item" href="{{ route('admin.productos.show', $producto->id) }}">
                                        <i class=" ri-eye-line me-1"></i>
                                        Ver Detalle
                                    </a>
                                    @endcan
                                    <a class="dropdown-item" href="{{ route('admin.productos.edit', $producto->id) }}">
                                        <i class=" ri-edit-line me-1"></i>
                                        Editar
                                    </a>
                                    <a class="dropdown-item" href="{{ route('admin.productos.inventory', $producto->id) }}">
                                        <i class=" ri-history-line me-1"></i>
                                        Historial Inventario
                                    </a>
                                    <button class="dropdown-item" wire:click="duplicate({{ $producto->id }})">
                                        <i class=" ri-file-copy-line me-1"></i>
                                        Duplicar
                                    </button>
                                    <button class="dropdown-item" wire:click="toggleStatus({{ $producto->id }})">
                                        <i class=" ri-toggle-line me-1"></i>
                                        {{ $producto->status ? 'Desactivar' : 'Activar' }}
                                    </button>
                                    <div class="dropdown-divider"></div>
                                    <button class="dropdown-item text-danger"
                                            wire:click="delete({{ $producto->id }})"
                                            onclick="confirm('¿Estás seguro de eliminar este producto?') || event.stopImmediatePropagation()">
                                        <i class=" ri-delete-bin-line me-1"></i>
                                        Eliminar
                                    </button>
                                </div>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="9" class="text-center py-4">
                            <div class="text-muted">
                                <i class=" ri-shopping-bag-line fs-1 mb-3 d-block"></i>
                                No se encontraron productos
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($productos->hasPages())
        <div class="card-footer border-top">
            {{ $productos->links('livewire.pagination') }}
        </div>
        @endif
    </div>
</div>
</div>


@push('styles')
<style>
.table th {
    border-top: 0;
    font-weight: 600;
}

.badge {
    font-size: 0.75em;
}

.avatar {
    position: relative;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    width: 2.375rem;
    height: 2.375rem;
}

.avatar-initial {
    position: absolute;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.dropdown-menu {
    min-width: 200px;
}

.card .table-responsive {
    border-radius: 0.375rem;
}
</style>
@endpush
