<div class="modal fade show d-block modal-enhanced" tabindex="-1" style="background-color: rgba(0,0,0,0.6); z-index: 9999;">
    <div class="modal-dialog modal-dialog-centered modal-xl">
        <div class="modal-content border-0 shadow-lg modal-content-enhanced">
            <div class="modal-header bg-white border-0 pb-0">
                <h5 class="modal-title fw-bold text-dark">
                    <i class="ri-shopping-bag-3-line me-2 text-primary"></i>Seleccionar Producto
                </h5>
                <button type="button" class="btn-close" wire:click="closeVariantsModal"></button>
            </div>
            <div class="modal-body p-4">
                <!-- Información del producto mejorada -->
                <div class="product-showcase mb-4 p-4 bg-light rounded-3">
                    <div class="row align-items-center">
                        <div class="col-md-3">
                            <div class="product-image-container position-relative">
                                @if($selectedProductForVariants->featuredImage)
                                    <img src="{{ asset('app/'.$selectedProductForVariants->featuredImage->path) }}"
                                         class="img-fluid rounded-3 shadow-sm product-main-image"
                                         style="width: 100%; height: 200px; object-fit: cover;">
                                @else
                                    <div class="bg-white rounded-3 d-flex align-items-center justify-content-center shadow-sm" style="height: 200px;">
                                        <i class="ri-image-line text-muted" style="font-size: 4rem;"></i>
                                    </div>
                                @endif
                                <div class="position-absolute top-0 end-0 m-2">
                                    <span class="badge bg-white text-dark shadow-sm">
                                        <i class="ri-eye-line me-1"></i>Vista previa
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-9">
                            <div class="product-info">
                                <h3 class="fw-bold mb-2 text-dark">{{ $selectedProductForVariants->name }}</h3>
                                <p class="text-muted mb-3 fs-6">{{ $selectedProductForVariants->description ?: 'Sin descripción disponible' }}</p>
                                <div class="product-badges d-flex flex-wrap gap-2 mb-3">
                                    <span class="badge bg-primary bg-opacity-10 text-primary border border-primary border-opacity-25 px-3 py-2">
                                        <i class="ri-price-tag-3-line me-1"></i>
                                        {{ format_money($selectedProductForVariants->precio) }}
                                    </span>
                                    <span class="badge bg-{{ $selectedProductForVariants->quantity > 10 ? 'success' : ($selectedProductForVariants->quantity > 0 ? 'warning' : 'danger') }} bg-opacity-10 text-{{ $selectedProductForVariants->quantity > 10 ? 'success' : ($selectedProductForVariants->quantity > 0 ? 'warning' : 'danger') }} border border-{{ $selectedProductForVariants->quantity > 10 ? 'success' : ($selectedProductForVariants->quantity > 0 ? 'warning' : 'danger') }} border-opacity-25 px-3 py-2">
                                        <i class="ri-inventory-2-line me-1"></i>
                                        Stock: {{ $selectedProductForVariants->quantity }}
                                    </span>
                                    @if($selectedProductForVariants->code)
                                        <span class="badge bg-secondary bg-opacity-10 text-secondary border border-secondary border-opacity-25 px-3 py-2">
                                            <i class="ri-barcode-line me-1"></i>
                                            {{ $selectedProductForVariants->code }}
                                        </span>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Opciones de variantes mejoradas -->
                    <div class="col-lg-5">
                        <div class="variants-section">
                            <h6 class="fw-bold mb-3 text-dark d-flex align-items-center">
                                <i class="ri-list-check-2 me-2 text-primary"></i>
                                Opciones Disponibles
                                <span class="badge bg-light text-muted ms-2">
                                    {{ ($selectedProductForVariants->variants ? $selectedProductForVariants->variants->count() : 0) + 1 }} opciones
                                </span>
                            </h6>

                            <div class="variants-grid">
                                <!-- Producto Principal Mejorado -->
                                <div class="variant-card mb-3" wire:click="selectVariant('main')" style="cursor: pointer;">
                                    <div class="card variant-option {{ $selectedVariant === 'main' ? 'border-primary bg-primary bg-opacity-5' : 'border-light' }} h-100 position-relative">
                                        @if($selectedVariant === 'main')
                                            <div class="position-absolute top-0 end-0 m-3">
                                                <div class="selected-indicator bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 24px; height: 24px;">
                                                    <i class="ri-check-line small"></i>
                                                </div>
                                            </div>
                                        @endif
                                        <div class="card-body p-4">
                                            <div class="d-flex align-items-start">
                                                <div class="form-check me-3 mt-1">
                                                    <input class="form-check-input" type="radio" {{ $selectedVariant === 'main' ? 'checked' : '' }}>
                                                </div>
                                                <div class="flex-grow-1">
                                                    <div class="d-flex align-items-center mb-2">
                                                        <h6 class="card-title mb-0 fw-bold text-dark">Producto Principal</h6>
                                                        <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25 ms-2 small">
                                                            <i class="ri-star-line me-1"></i>Original
                                                        </span>
                                                    </div>
                                                    <div class="variant-details">
                                                        <div class="row align-items-center">
                                                            <div class="col-6">
                                                                <div class="price-display">
                                                                    <span class="h5 mb-0 text-primary fw-bold">{{ format_money($selectedProductForVariants->precio) }}</span>
                                                                </div>
                                                            </div>
                                                            <div class="col-6 text-end">
                                                                <span class="badge bg-{{ $selectedProductForVariants->quantity > 0 ? 'success' : 'danger' }} px-3 py-2">
                                                                    <i class="ri-inventory-2-line me-1"></i>
                                                                    {{ $selectedProductForVariants->quantity }} disponibles
                                                                </span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Variantes Mejoradas -->
                                @if($selectedProductForVariants->variants && $selectedProductForVariants->variants->count() > 0)
                                    @foreach($selectedProductForVariants->variants as $variante)
                                        <div class="variant-card mb-3" wire:click="selectVariant({{ $variante->id }})" style="cursor: pointer;">
                                            <div class="card variant-option {{ $selectedVariant == $variante->id ? 'border-primary bg-primary bg-opacity-5' : 'border-light' }} h-100 position-relative">
                                                @if($selectedVariant == $variante->id)
                                                    <div class="position-absolute top-0 end-0 m-3">
                                                        <div class="selected-indicator bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 24px; height: 24px;">
                                                            <i class="ri-check-line small"></i>
                                                        </div>
                                                    </div>
                                                @endif
                                                <div class="card-body p-4">
                                                    <div class="d-flex align-items-start">
                                                        <div class="form-check me-3 mt-1">
                                                            <input class="form-check-input" type="radio" {{ $selectedVariant == $variante->id ? 'checked' : '' }}>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <div class="d-flex align-items-center mb-2">
                                                                <h6 class="card-title mb-0 fw-bold text-dark">{{ $variante->formatted_values }}</h6>
                                                                <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 ms-2 small">
                                                                    <i class="ri-palette-line me-1"></i>Variante
                                                                </span>
                                                            </div>
                                                            <div class="variant-details">
                                                                <div class="row align-items-center">
                                                                    <div class="col-6">
                                                                        <div class="price-display">
                                                                            <span class="h5 mb-0 text-primary fw-bold">{{ format_money($selectedProductForVariants->precio + $variante->price_adjustment) }}</span>
                                                                            @if($variante->price_adjustment != 0)
                                                                                <small class="text-muted d-block">
                                                                                    Base: {{ format_money($selectedProductForVariants->precio) }}
                                                                                    {{ $variante->price_adjustment > 0 ? '+' : '' }}{{ format_money($variante->price_adjustment) }}
                                                                                </small>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-6 text-end">
                                                                        <span class="badge bg-{{ $variante->quantity > 0 ? 'success' : 'danger' }} px-3 py-2">
                                                                            <i class="ri-inventory-2-line me-1"></i>
                                                                            {{ $variante->quantity }} disponibles
                                                                        </span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Panel de compra mejorado -->
                    <div class="col-lg-7">
                        <div class="purchase-panel bg-white border rounded-3 p-4 h-100 shadow-sm">
                            <h6 class="fw-bold mb-4 text-dark d-flex align-items-center">
                                <i class="ri-shopping-cart-2-line me-2 text-primary"></i>
                                Configurar Compra
                            </h6>

                            <!-- Producto seleccionado -->
                            <div class="selected-product-info mb-4 p-3 bg-light rounded-3">
                                <label class="form-label small text-muted fw-bold mb-2">PRODUCTO SELECCIONADO:</label>
                                <div class="selected-product-name fw-bold text-dark">
                                    @if($selectedVariant === 'main')
                                        {{ $selectedProductForVariants->name }}
                                        <span class="badge bg-info bg-opacity-10 text-info border border-info border-opacity-25 ms-1 small">Original</span>
                                    @elseif($selectedVariant && $selectedProductForVariants->variants)
                                        @php
                                            $selectedVariantData = $selectedProductForVariants->variants->firstWhere('id', $selectedVariant);
                                        @endphp
                                        @if($selectedVariantData)
                                            {{ $selectedProductForVariants->name }}
                                            <span class="badge bg-warning bg-opacity-10 text-warning border border-warning border-opacity-25 ms-1 small">{{ $selectedVariantData->formatted_values }}</span>
                                        @endif
                                    @else
                                        <span class="text-muted">Seleccione una opción</span>
                                    @endif
                                </div>
                            </div>

                            <!-- Precio unitario -->
                            <div class="price-info mb-4">
                                <label class="form-label small text-muted fw-bold mb-2">PRECIO UNITARIO:</label>
                                <div class="price-display">
                                    @if($selectedVariant === 'main')
                                        <span class="h4 mb-0 text-success fw-bold">{{ format_money($selectedProductForVariants->precio) }}</span>
                                    @elseif($selectedVariant && $selectedProductForVariants->variants)
                                        @php
                                            $selectedVariantData = $selectedProductForVariants->variants->firstWhere('id', $selectedVariant);
                                        @endphp
                                        @if($selectedVariantData)
                                            <span class="h4 mb-0 text-success fw-bold">{{ format_money($selectedProductForVariants->precio + $selectedVariantData->price_adjustment) }}</span>
                                        @endif
                                    @else
                                        <span class="h4 mb-0 text-muted">--</span>
                                    @endif
                                </div>
                            </div>

                            <!-- Cantidad mejorada -->
                            <div class="quantity-selector mb-4">
                                <label class="form-label small text-muted fw-bold mb-2">CANTIDAD:</label>
                                <div class="input-group input-group-lg">
                                    <button class="btn btn-outline-secondary" wire:click="$set('variantQuantity', {{ max(1, $variantQuantity - 1) }})" {{ !$selectedVariant ? 'disabled' : '' }}>
                                        <i class="ri-subtract-line"></i>
                                    </button>
                                    <input type="number" class="form-control text-center fw-bold fs-5" wire:model.live="variantQuantity"
                                           min="1" max="1000" {{ !$selectedVariant ? 'disabled' : '' }}>
                                    <button class="btn btn-outline-secondary" wire:click="$set('variantQuantity', {{ $variantQuantity + 1 }})" {{ !$selectedVariant ? 'disabled' : '' }}>
                                        <i class="ri-add-line"></i>
                                    </button>
                                </div>
                            </div>

                            <!-- Total mejorado -->
                            <div class="total-section mb-4 p-4 bg-success bg-opacity-5 border border-success border-opacity-25 rounded-3">
                                <div class="d-flex justify-content-between align-items-center">
                                    <span class="fw-bold text-dark">TOTAL A PAGAR:</span>
                                    <span class="h3 mb-0 text-success fw-bold">
                                        @if($selectedVariant === 'main')
                                            {{ format_money($selectedProductForVariants->precio * $variantQuantity) }}
                                        @elseif($selectedVariant && $selectedProductForVariants->variants)
                                            @php
                                                $selectedVariantData = $selectedProductForVariants->variants->firstWhere('id', $selectedVariant);
                                            @endphp
                                            @if($selectedVariantData)
                                                {{ format_money(($selectedProductForVariants->precio + $selectedVariantData->price_adjustment) * $variantQuantity) }}
                                            @endif
                                        @else
                                            --
                                        @endif
                                    </span>
                                </div>
                            </div>

                            <!-- Botones mejorados -->
                            <div class="action-buttons d-grid gap-3">
                                <button type="button" class="btn btn-success btn-lg" wire:click="addVariantToCart" {{ !$selectedVariant ? 'disabled' : '' }}>
                                    <i class="ri-shopping-cart-line me-2"></i>Agregar al Carrito
                                </button>
                                <button type="button" class="btn btn-outline-secondary" wire:click="closeVariantsModal">
                                    <i class="ri-close-line me-2"></i>Cancelar
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
